/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.IndexedValue;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.PossiblyInnerType;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.renderer.CustomFlexibleRendering;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererImpl$WhenMappings;
import org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptionsImpl;
import org.jetbrains.kotlin.renderer.NameShortness;
import org.jetbrains.kotlin.renderer.OverrideRenderingPolicy;
import org.jetbrains.kotlin.renderer.ParameterNameRenderingPolicy;
import org.jetbrains.kotlin.renderer.RenderingFormat;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.Flexibility;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.LazyType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.error.MissingDependencyErrorClass;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"I\u0006)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005!Y!B\u0001\t#\u0015\tA\"A\u0003\u0002\t\u001d)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!Q!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\t\u0006\u00031\tQ!\u0001C\u0003\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA1B\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0006\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011A)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0002\t\u0013)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011)Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0019Q!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\tAaA\u0003\u0002\u0019\u0005)\u0011\u0001b\u0002\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0003\u0011!Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA!B\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!yQ!\u0001\u0003\u0003\u000b\u0005a\u0011!B\u0001\u0005\u000b\u0011\u0001A\u0002A\r\u00021\u0003I\u0012\u0001G\u0001\u001e\u0003#\u000b\u0011UB\u0005\u0004\u0011\u0007i\u0011\u0001\u0007\u0002R\u0007\u0005A)!J\b\u0005\u0003!\u0001\r!d\u0001\u0019\u0002\u0004IB\u0001Ca\u0001\u001b\u0007A\u001a\u0019A\r\u0005\u0011\t\u0007Q2\u0001MC\u0002\u0015\u0016B!\u0001\u0005D\u00025\r\u0001\u00141\u0001\u001a\u0010!\u001d\r!D\u0003\n\u0006%\r\u0001\u00142\u0001\u0019\t\u0004IB\u0001\u0003b\u0001\u001b\u0007A*\u0019A\u0013\u0006\t\u0005AQ\u0019AG\u00021\u0017\u0007QU\u0004\u0003\u0002\u0011\u0019\u0007Q\"\u0001M\u00043\u0011Ai\u0019AG\u00021\u0017\u0007\u0011\u0004\u0002\u0005H\u00025\r\u000142\u0001&\u0015\u0011\t\u0001r2\u0001\u000e\u0004a-\r!\u0007\u0003\t\u0011\u0004i\u0019\u0001gc\u0001K\u0015!\u0011\u0001#e\u0001\u001b\u0007AZ\u0019A\u0013\u0006\t\u0005A\u0011\u001aAG\u00021\u0017\u0007Q5\u0003\u0003\u0002\u0011'\u0007Q\"\u0001M\u00043\u0011A!\u001aAG\u00021+\u0007QE\u0003\u0003\f\u0011-\u0007Q2\u0001MF\u0002e!\u0001r3\u0001\u000e\u0004a\r\r!J\b\u0005\u0003!a\r!d\u0001\u0019\u0002\u0004IB\u0001Ca\u0001\u001b\u0007AJ\u001aA\r\u0005\u0011\t\u0007Q2\u0001MC\u0002\u0015zA!\u0001\u0005N\u00025\r\u0001\u00141\u0001\u001a\t!m\r!d\u0001\u0019\u001d\u0004IB\u0001\u0003b\u0001\u001b\u0007A*\u0019AS\u000e\t\u0005Ai\u001aA\u0007\u0006\u0013\u000bI\u0019\u0001gc\u00011\u0011\u0007\u0011\u0004\u0002\u0005B\u00025\r\u0001d4\u0001&!\u0011Y\u0001r4\u0001\u000e\u0004a-\r!\u0007\u0003\t!\u0004i\u0019\u0001Gh\u00013\u0015A\t\u001bAG\u0003\u0019\u0003A\u0012\u001bAS\u0015\t\u0005A\u0019\u001bAG\u00021\u0003\u0007\u0011\u0004\u0002\u0005S\u00025\r\u0001T5\u0001\u001a\t!\u0011\r!d\u0001\u0019\u0006\u0004IJ\u0001B\u0001\t'\u0004i\u0011\u0001g\u0002&\u001f\u0011\t\u0001r5\u0001\u000e\u0004a\u0005\r!\u0007\u0003\t)\u0004i\u0019\u0001'k\u00013\u0011A!\u0019AG\u00021\u000b\u0007Qe\u0004\u0003\u0002\u0011U\u0007Q2\u0001MA\u0002e!\u0001\u00026\u0001\u000e\u0004a%\u000e!\u0007\u0003\t\u0005\u0004i\u0019\u0001'b\u0001K)!1\u0002ck\u0001\u001b\u0007AZ\u0019A\r\u0005\u0011Q\u0007Q2\u0001\rW\u0002\u0015vA!\u0001\u0005$\u001b\u0007A\n\u0019A\r\u0005\u0011\u0005\u0007Q2\u0001MB\u0002e!\u0001B1\u0001\u000e\u0004a\u0015\r!\n\u0007\u0005\u0003!5\u000e!d\u0001\u0019\f\u0004Ib\u0001Cl\u0001\u001b\u000fI\u0011\u0001b\u0001\u00190\u0004)s\u0002B\u0001\t1\u0004i\u0019\u0001'a\u00013\u0011A\t\u001cAG\u00021e\u0007\u0011\u0004\u0002\u0005C\u00025\r\u0001T1\u0001&\u001e\u0011\t\u000127\u0001\u000e\u0004a\u0005\r!g\u0002\t5\u0004i\u0011\u0001g\u0002\u001a\t!\u0011\r!d\u0001\u0019\u0006\u0004)\u001b\u0002B\u0001\t6\u0004i\u0019\u0001gc\u00013\u000fA1\u001cA\u0007\u00021A*#\u0002B\u0001\t8\u0004i\u0019\u0001gc\u00013\u0011AA\u001cAG\u00021\u0017\u0007Q5\u0003\u0003\u0002\u0011s\u0007Q2\u0001MF\u0002e\u001d\u0001b7\u0001\u000e\u0003a\u0001Te\u0004\u0003\u0002\u0011u\u0007Q2\u0001MF\u0002e!\u0001R2\u0001\u000e\u0004a-\r!\u0007\u0003\t\u000f\u0004i\u0019\u0001gc\u0001K9!\u0011\u0001Co\u0001\u001b\u0007AZ\u0019AM\u0004\u0011\u001b\u0007Q\"\u0001\r13\u000fAq\u0019A\u0007\u00021A*[\u0002B\u0001\t<\u0004i\u0019\u0001gc\u00013\u001fAa\u001cA\u0007\u0006\u0013\u000bI\u0019\u0001'p\u00011\u0011\u0007QE\u0003\u0003\f\u0011w\u0007Q2\u0001MF\u0002e!\u0001b8\u0001\u000e\u0004a}\u000e!J\b\u0005\u0003!\u0001\u000f!d\u0001\u0019\u0002\u0004IB\u0001#q\u0001\u001b\u0007Ab\u001aA\r\u0005\u0011\t\u0007Q2\u0001MC\u0002\u0015NA!\u0001\u0005b\u00025\r\u000142\u0001\u001a\b!Y\u000e!D\u0001\u0019a\u0015NA!\u0001Eb\u00025\r\u000142\u0001\u001a\b!Y\u000e!D\u0001\u0019a\u0015zA!\u0001\u0005c\u00025\r\u0001\u00141\u0001\u001a\t!\u0015\u000f!d\u0001\u0019G\u0004IB\u0001\u0003b\u0001\u001b\u0007A*\u0019AS\u000f\t\u0005A9\u001dAG\u00021\u0003\u0007\u0011t\u0001\u0005e\u00025\t\u0001tA\r\u0005\u0011\t\u0007Q2\u0001MC\u0002\u0015RA!\u0001Ee\u00025\r\u000142\u0001\u001a\t!a\u000e!d\u0001\u0019\f\u0004)s\u0002B\u0001\tK\u0004i\u0019\u0001'a\u00013\u0011AY\u001dAG\u00021\u0019\b\u0011\u0004\u0002\u0005C\u00025\r\u0001T1\u0001&\u001f\u0011\t\u0001R:\u0001\u000e\u0004a\u0005\r!\u0007\u0003\tO\u0004i\u0019\u0001'f\u00013\u0011A!\u0019AG\u00021\u000b\u0007QE\u0003\u0003\u0002\u0011\u001f\bQ2\u0001MF\u0002e!\u0001\u0002;\u0001\u000e\u0004a-\r!J\b\u0005\u0003!E\u000f!d\u0001\u0019\u0002\u0004IB\u0001Cu\u0001\u001b\u0007A\u001a\u001eA\r\u0005\u0011\t\u0007Q2\u0001MC\u0002\u0015zA!\u0001\u0005k\u00025\r\u0001\u00141\u0001\u001a\t!Q\r!d\u0001\u0019\u0016\u0004IB\u0001\u0003b\u0001\u001b\u0007A*\u0019A\u0013\u0010\t\u0005A)\u001eAG\u00021\u0003\u0007\u0011\u0004\u0002\u0005B\u00025\r\u000141\u0001\u001a\t!\u0011\r!d\u0001\u0019\u0006\u0004)#\u0002B\u0006\tV\u0004i\u0019\u0001gc\u00013\u0011A1\u001eAG\u00021{\u0007Q5\u0003\u0003\u0002\u0011/\bQ2\u0001MF\u0002e\u001d\u0001b7\u0001\u000e\u0003a\u0001Te\u0004\u0003\u0002\u00111\bQ2\u0001MA\u0002e!\u0001b:\u0001\u000e\u0004aU\r!\u0007\u0003\t\u0005\u0004i\u0019\u0001'b\u0001K=!\u0011\u0001#w\u0001\u001b\u0007A\n\u0019A\r\u0005\u00115\bQ2\u0001Mn\u0002e!\u0001B1\u0001\u000e\u0004a\u0015\r!J\b\u0005\u0003!q\u000f!d\u0001\u0019\u0002\u0004IB\u0001#x\u0001\u001b\u0007Ar\u001eA\r\u0005\u0011\t\u0007Q2\u0001MC\u0002\u0015RA!\u0001Ep\u00025\r\u000142\u0001\u001a\t!\u0001\u0010!d\u0001\u0019b\u0004)s\u0002B\u0001\tc\u0004i\u0019\u0001'a\u00013\u0011A\u0019\u001fAG\u00021\u0019\b\u0011\u0004\u0002\u0005C\u00025\r\u0001T1\u0001&\u001f\u0011\t\u0001B=\u0001\u000e\u0004a\u0005\r!\u0007\u0003\tf\u0004i\u0019\u0001Gz\u00013\u0011A!\u0019AG\u00021\u000b\u0007Qe\u0004\u0003\u0002\u0011O\bQ2\u0001MA\u0002e!\u0001R=\u0001\u000e\u0004a\u0019\u0010!\u0007\u0003\t\u0005\u0004i\u0019\u0001'b\u0001K)!\u0011\u0001\u0003{\u0001\u001b\u0007A\n\u0019A\r\u0005\u0011\t\u0007Q2\u0001MC\u0002\u0015zA!\u0001Eu\u00025\r\u0001\u00141\u0001\u001a\t!!\u000e!d\u0001\u0019*\u0004IB\u0001\u0003b\u0001\u001b\u0007A*\u0019AS\n\t-AQ\u001fAG\u00021\u0017\u0007\u0011t\u0001\u0005\\\u00025\t\u0001\u0004MS\u000e\t-AY\u001fAG\u00021\u0017\u0007\u0011t\u0002\u0005w\u00025)\u0011RAE\u00021\u0013\u0007\u0001\u00042\u0001&\u0015\u0011Y\u0001R>\u0001\u000e\u0004a-\r!\u0007\u0003\to\u0004i\u0019\u0001g|\u0001K?!\u0011\u0001\u0003}\u0001\u001b\u0007AZ\u0019AM\u0004\u0011m\u0007Q\"\u0001\r13\u0015!\u0011\u0001C|\u0001\u001b\u0007Az\u001fAS\u0014\t\u0005A\t AG\u00021\u0003\u0007\u0011\u0004\u0002\u0005z\u00025\r\u00014?\u0001\u001a\t!\u0011\r!d\u0001\u0019\u0006\u0004I:\u0001\u0003~\u0001\u001b\u0005A:!*\n\u0005\u0003!U\u0010!d\u0001\u0019\u0002\u0004IB\u0001\u0003b\u0001\u001b\u0007A*\u0019AM\b\u0011m\bQ\"BE\u0003\u0013\u0007A\u001a \u0001\rE\u0002\u0015:B!\u0001E|\u00025\r\u0001\u00141\u0001\u001a\u0010!Y\u0010!D\u0003\n\u0006%\r\u00014?\u0001\u0019\t\u0004IB\u0001\u0003b\u0001\u001b\u0007A*\u0019AM\u0004\u0011q\bQ\"\u0001M\u0004K)!1\u0002#\u007f\u0001\u001b\u0007AZ\u0019A\r\u0005\u0011u\bQ2\u0001ME\u0002\u0015zA!\u0001E~\u00025\r\u0001\u00141\u0001\u001a\t!\u0015\u000f!d\u0001\u0019G\u0004IB\u0001\u0003b\u0001\u001b\u0007A*\u0019A\u0013\u0019\t\u0005Aa AG\u00021\u0003\u0007\u0011\u0004\u0002E\u007f\u00025\r\u0001d@\u0001\u001a\b!}\u0010!D\u0001\u0019\be!\u0001B1\u0001\u000e\u0004a\u0015\r!g\u0002\tu\u0004i\u0011\u0001g\u0002&%\u0011Y\u0001\u0002Q\u0001\u000e\u0004a-\r!g\u0004\t\u0002\u0006iQ!#\u0002\n\u0004ay\u0010\u0001G!\u00023\u000fA\u0019)A\u0007\u00021\u000f)s\u0003B\u0001\t\u0001\u0006i\u0019\u0001'a\u00013\u001fA\t)A\u0007\u0006\u0013\u000bI\u0019\u0001G\u0000\u00011\u0005\u000b\u0011t\u0001EB\u00035\t\u0001tA\r\u0005\u0011\t\u0007Q2\u0001MC\u0002\u0015BB!\u0001\u0005C\u00035\r\u0001\u00141\u0001\u001a\t!\u0015\u000f!d\u0001\u0019G\u0004I:\u0001c\u0000\u0001\u001b\u0005A:!\u0007\u0003\t\u0005\u0004i\u0019\u0001'b\u00013\u000fA! A\u0007\u00021\u000f)s\u0002B\u0001\t\u0006\u0006i\u0019\u0001'a\u00013\u0011A1)AG\u00021\u000f\u000b\u0011\u0004\u0002\u0005C\u00025\r\u0001T1\u0001&&\u0011\t\u0001\u0002R\u0001\u000e\u0004a\u0005\r!g\u0004\tw\u0004iQ!#\u0002\n\u0004aM\u0010\u0001\u0007c\u00013\u0011A!\u0019AG\u00021\u000b\u0007Qe\b\u0003\u0002\u0011\u0013\u000bQR\u0001G\u00011\u0017\u0007\u0011\u0004\u0002\u0005F\u00035\r\u000142\u0001\u001a\t!-\u0015!d\u0001\u0019\f\u0004IB\u0001\u0003$\u0002\u001b\u0007AZ\u0019A\r\u0005\u0011\u001b\u000bQ2\u0001MF\u0002e!\u0001bR\u0001\u000e\u0004a-\r!J\u0005\u0005\u0003!=\u0015!D\u0001\u0019\be\u001d\u0001b7\u0001\u000e\u0003a\u0001T%\u0003\u0003\u0002\u0011!\u000bQ\"\u0001M\u00043\u000fA\u0019)A\u0007\u00021\u000fIC\u0002B&\u001f\u0011\ri\u0011\u0001g\u0002R\u0007\u0019i!\u0001\u0002\u0003\t\nE\u0011A!\u0002E\u0006S1!1J\b\u0005\u0007\u001b\u0005A:!U\u0002\u0007\u001b\t!i\u0001#\u0003\u0012\u0005\u00119\u00012B\u0015\r\t-s\u0002rB\u0007\u00021\u000f\t6AB\u0007\u0003\t!AI!\u0005\u0002\u0005\u0012!-\u0011f\u0004\u0003L=!IQ\u0002B\u0005\u0003\u0013\u0005A\"\u0002g\u0005R\u0007\u0019i!\u0001\"\u0006\t\u0017E\u0011Aq\u0003\u0005\rS=!1J\bE\r\u001b\u0011I!!C\u0001\u0019\u0015aM\u0011k\u0001\u0004\u000e\u0005\u0011i\u0001bC\t\u0003\t7AA\"\u000b\u0007\u0005\u0017zAa\"D\u0001\u0019\bE\u001ba!\u0004\u0002\u0005\u001e!%\u0011C\u0001\u0003\u0010\u0011\u0017IC\u0002B&\u001f\u0011?i\u0011\u0001g\u0002R\u0007\u0019i!\u0001\u0002\t\t\nE\u0011A\u0011\u0005E\u0006S=!1J\b\u0005\u0012\u001b\u0011I!!C\u0001\u0019$aM\u0011k\u0001\u0004\u000e\u0005\u0011\u0011\u0002bC\t\u0003\tKAA\"\u000b\u0007\u0005\u0017zA1#D\u0001\u0019(E\u001ba!\u0004\u0002\u0005)!%\u0012C\u0001\u0003\u0016\u0011WIC\u0002B&\u001f\u0011Yi\u0011\u0001g\u0002R\u0007\u0019i!\u0001\"\f\t\nE\u0011Aa\u0006E\u0006S)!1\t\u0003E\u0002\u001b\u0005A\"!U\u0002\u0005\u000b\u0001i!\u0001b\f\t1%bAa\u0013\u0010\t25\t\u0001$G)\u0004\r5\u0011A1\u0007\u0005\u001b#\t!)\u0004C\u000e*\u0019\u0011Ye\u0004c\u000e\u000e\u0003aa\u0012k\u0001\u0004\u000e\u0005\u0011e\u0002\"H\t\u0003\twAa$\u000b\u0007\u0005\u0017zAi$D\u0001\u0019\bE\u001ba!\u0004\u0002\u0005?!%\u0011C\u0001C \u0011\u0017IC\u0002B&\u001f\u0011\u0001j\u0011\u0001g\u0002R\u0007\u0019i!\u0001\"\u0011\t\nE\u0011A!\tE\u0006S1!1J\bE\"\u001b\u0005A:!U\u0002\u0007\u001b\t!!\u0005#\u0003\u0012\u0005\u0011\u0015\u00032B\u0015\r\t-s\u0002bI\u0007\u00021\u000f\t6AB\u0007\u0003\t\u000fBI!\u0005\u0002\u0005I!-\u0011\u0006\u0004\u0003L=!%S\"\u0001M\u0004#\u000e1QB\u0001\u0003&\u0011\u0013\t\"\u0001b\u0013\t\f%bAa\u0013\u0010\tM5\t\u0001tA)\u0004\r5\u0011AQ\nE\u0005#\t!q\u0005c\u0003*\u0019\u0011Ye\u0004c\u0014\u000e\u0003a\u001d\u0011k\u0001\u0004\u000e\u0005\u0011A\u0003\u0012B\t\u0003\t#BY!\u000b\u0007\u0005\u0017zA\u0011&D\u0001\u0019\bE\u001ba!\u0004\u0002\u0005T!%\u0011C\u0001\u0003+\u0011\u0017IC\u0002B&\u001f\u0011+j\u0011\u0001g\u0002R\u0007\u0019i!\u0001B\u0016\t\nE\u0011Aq\u000bE\u0006S1!1J\b\u0005-\u001b\u0005AJ&U\u0002\u0007\u001b\t!Q\u0006c\u0017\u0012\u0005\u0011q\u0003RL\u0015\u0013\t-s\u0002bL\u0007\b\u0013\tI\u0011\u0001\u0007\u0019\n\u0005%\t\u0001\u0004\rM0#\u000e1QB\u0001C1\u0011E\n\"\u0001b\u0019\te%bAa\u0013\u0010\tf5\t\u0001tA)\u0004\r5\u0011Aa\rE\u0005#\t!9\u0007c\u0003*\u0019\u0011Ye\u0004\u0003\u001b\u000e\u0003a\u001d\u0011k\u0001\u0004\u000e\u0005\u0011%\u0004\u0012B\t\u0003\tUBY!\u000b\u0007\u0005\u0017zAY'D\u0001\u0019mE\u001ba!\u0004\u0002\u0005n!9\u0014C\u0001C8\u0011aJC\u0002B&\u001f\u0011cj\u0011\u0001g\u0002R\u0007\u0019i!\u0001B\u001d\t\nE\u0011A1\u000fE\u0006S1!1J\b\u0005;\u001b\u0005A:!U\u0002\u0007\u001b\t!)\b#\u0003\u0012\u0005\u0011Y\u00042B\u0015\r\t-s\u0002rO\u0007\u00021\u000f\t6AB\u0007\u0003\tqBI!\u0005\u0002\u0005z!-\u0011\u0006\u0004\u0003L=!iT\"\u0001M\u0004#\u000e1QB\u0001C>\u0011\u0013\t\"\u0001\u0002 \t\f%bAa\u0013\u0010\t~5\t\u0001tA)\u0004\r5\u0011Aa\u0010E\u0005#\t!y\bc\u0003"}, strings={"Lorg/jetbrains/kotlin/renderer/DescriptorRendererImpl;", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "options", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptionsImpl;", "(Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptionsImpl;)V", "alwaysRenderModifiers", "", "getAlwaysRenderModifiers", "()Z", "setAlwaysRenderModifiers", "(Z)V", "classWithPrimaryConstructor", "getClassWithPrimaryConstructor", "setClassWithPrimaryConstructor", "debugMode", "getDebugMode", "setDebugMode", "excludedAnnotationClasses", "", "Lorg/jetbrains/kotlin/name/FqName;", "getExcludedAnnotationClasses", "()Ljava/util/Set;", "setExcludedAnnotationClasses", "(Ljava/util/Set;)V", "excludedTypeAnnotationClasses", "getExcludedTypeAnnotationClasses", "setExcludedTypeAnnotationClasses", "flexibleTypesForCode", "getFlexibleTypesForCode", "setFlexibleTypesForCode", "includePropertyConstant", "getIncludePropertyConstant", "setIncludePropertyConstant", "modifiers", "Lorg/jetbrains/kotlin/renderer/DescriptorRendererModifier;", "getModifiers", "setModifiers", "nameShortness", "Lorg/jetbrains/kotlin/renderer/NameShortness;", "getNameShortness", "()Lorg/jetbrains/kotlin/renderer/NameShortness;", "setNameShortness", "(Lorg/jetbrains/kotlin/renderer/NameShortness;)V", "normalizedVisibilities", "getNormalizedVisibilities", "setNormalizedVisibilities", "getOptions", "()Lorg/jetbrains/kotlin/renderer/DescriptorRendererOptionsImpl;", "overrideRenderingPolicy", "Lorg/jetbrains/kotlin/renderer/OverrideRenderingPolicy;", "getOverrideRenderingPolicy", "()Lorg/jetbrains/kotlin/renderer/OverrideRenderingPolicy;", "setOverrideRenderingPolicy", "(Lorg/jetbrains/kotlin/renderer/OverrideRenderingPolicy;)V", "parameterNameRenderingPolicy", "Lorg/jetbrains/kotlin/renderer/ParameterNameRenderingPolicy;", "getParameterNameRenderingPolicy", "()Lorg/jetbrains/kotlin/renderer/ParameterNameRenderingPolicy;", "setParameterNameRenderingPolicy", "(Lorg/jetbrains/kotlin/renderer/ParameterNameRenderingPolicy;)V", "prettyFunctionTypes", "getPrettyFunctionTypes", "setPrettyFunctionTypes", "receiverAfterName", "getReceiverAfterName", "setReceiverAfterName", "renderAccessors", "getRenderAccessors", "setRenderAccessors", "renderCompanionObjectName", "getRenderCompanionObjectName", "setRenderCompanionObjectName", "renderDefaultAnnotationArguments", "getRenderDefaultAnnotationArguments", "setRenderDefaultAnnotationArguments", "renderDefaultValues", "getRenderDefaultValues", "setRenderDefaultValues", "secondaryConstructorsAsPrimary", "getSecondaryConstructorsAsPrimary", "setSecondaryConstructorsAsPrimary", "showInternalKeyword", "getShowInternalKeyword", "setShowInternalKeyword", "startFromName", "getStartFromName", "setStartFromName", "textFormat", "Lorg/jetbrains/kotlin/renderer/RenderingFormat;", "getTextFormat", "()Lorg/jetbrains/kotlin/renderer/RenderingFormat;", "setTextFormat", "(Lorg/jetbrains/kotlin/renderer/RenderingFormat;)V", "typeNormalizer", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getTypeNormalizer", "()Lkotlin/jvm/functions/Function1;", "setTypeNormalizer", "(Lkotlin/jvm/functions/Function1;)V", "uninferredTypeParameterAsName", "getUninferredTypeParameterAsName", "setUninferredTypeParameterAsName", "unitReturnType", "getUnitReturnType", "setUnitReturnType", "valueParametersHandler", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer$ValueParametersHandler;", "getValueParametersHandler", "()Lorg/jetbrains/kotlin/renderer/DescriptorRenderer$ValueParametersHandler;", "setValueParametersHandler", "(Lorg/jetbrains/kotlin/renderer/DescriptorRenderer$ValueParametersHandler;)V", "verbose", "getVerbose", "setVerbose", "withDefinedIn", "getWithDefinedIn", "setWithDefinedIn", "withoutReturnType", "getWithoutReturnType", "setWithoutReturnType", "withoutSuperTypes", "getWithoutSuperTypes", "setWithoutSuperTypes", "withoutTypeParameters", "getWithoutTypeParameters", "setWithoutTypeParameters", "appendDefinedIn", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "builder", "Ljava/lang/StringBuilder;", "appendTypeProjections", "typeProjections", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "arrow", "", "differsOnlyInNullability", "lower", "upper", "escape", "string", "gt", "lt", "overridesSomething", "callable", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "render", "declarationDescriptor", "renderAccessorModifiers", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "renderAdditionalModifiers", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "renderAndSortAnnotationArguments", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "renderAnnotation", "annotation", "target", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "renderAnnotations", "annotated", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "needBrackets", "renderClass", "klass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "renderClassKindPrefix", "renderClassifierName", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "renderConstant", "value", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "renderConstructor", "constructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "renderData", "isData", "renderDefaultType", "type", "renderError", "keyword", "renderFlexibleType", "renderFlexibleTypeWithBothBounds", "renderFqName", "pathSegments", "Lorg/jetbrains/kotlin/name/Name;", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "renderFunction", "function", "renderFunctionType", "renderInflexibleType", "renderInitializer", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "renderInner", "isInner", "renderKeyword", "renderLateInit", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "renderMemberKind", "callableMember", "renderMessage", "message", "renderModality", "modality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "renderModalityForCallable", "renderName", "name", "renderNormalizedType", "renderOverride", "renderPackageFragment", "fragment", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "renderPackageView", "packageView", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "renderPossiblyInnerType", "possiblyInnerType", "Lorg/jetbrains/kotlin/descriptors/PossiblyInnerType;", "renderProperty", "property", "renderReceiver", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "renderReceiverAfterName", "renderSpaceIfNeeded", "renderSuperTypes", "renderType", "renderTypeArguments", "typeArguments", "renderTypeConstructor", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "renderTypeConstructorAndArguments", "renderTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "topLevel", "renderTypeParameterList", "typeParameters", "renderTypeParameters", "withSpace", "renderTypeProjection", "typeProjection", "renderValVarPrefix", "renderValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "includeName", "renderValueParameters", "parameters", "", "synthesizedParameterNames", "renderVariable", "renderVisibility", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "renderWhereSuffix", "replacePrefixes", "lowerRendered", "lowerPrefix", "upperRendered", "upperPrefix", "foldedPrefix", "shouldRenderAsPrettyFunctionType", "shouldRenderParameterNames", "RenderDeclarationDescriptorVisitor"}, moduleName="kotlin-compiler")
public final class DescriptorRendererImpl
extends DescriptorRenderer
implements DescriptorRendererOptions {
    @NotNull
    private final DescriptorRendererOptionsImpl options;

    private final String renderKeyword(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$0[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<b>" + keyword + "</b>";
            }
        }
        return null;
    }

    private final String renderError(String keyword) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$1[this.getTextFormat().ordinal()]) {
            case 1: {
                return keyword;
            }
            case 2: {
                return "<font color=red><b>" + keyword + "</b></font>";
            }
        }
        return null;
    }

    private final String escape(String string) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$2[this.getTextFormat().ordinal()]) {
            case 1: {
                return string;
            }
            case 2: {
                return StringsKt.replace$default(StringsKt.replace$default(string, "<", "&lt;", false, 4), ">", "&gt;", false, 4);
            }
        }
        return null;
    }

    private final String lt() {
        return this.escape("<");
    }

    private final String gt() {
        return this.escape(">");
    }

    private final String arrow() {
        String string;
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$3[this.getTextFormat().ordinal()]) {
            case 1: {
                string = this.escape("->");
                break;
            }
            case 2: {
                string = "&rarr;";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String renderMessage(String message) {
        String string;
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$4[this.getTextFormat().ordinal()]) {
            case 1: {
                string = message;
                break;
            }
            case 2: {
                string = "<i>" + message + "</i>";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public String renderName(@NotNull Name name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return this.escape(RenderingUtilsKt.render(name));
    }

    private final void renderName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        Name name = descriptor2.getName();
        Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.getName()");
        builder.append(this.renderName(name));
    }

    private final void renderCompanionObjectName(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (this.getRenderCompanionObjectName()) {
            if (this.getStartFromName()) {
                builder.append("companion object");
            }
            this.renderSpaceIfNeeded(builder);
            DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
            if (containingDeclaration != null) {
                builder.append("of ");
                Name name = containingDeclaration.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "containingDeclaration.getName()");
                builder.append(this.renderName(name));
            }
        }
        if (this.getVerbose() || Intrinsics.areEqual(descriptor2.getName(), SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT) ^ true) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            Name name = descriptor2.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "descriptor.getName()");
            builder.append(this.renderName(name));
        }
    }

    @Override
    @NotNull
    public String renderFqName(@NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        List<Name> list = fqName2.pathSegments();
        Intrinsics.checkExpressionValueIsNotNull(list, "fqName.pathSegments()");
        return this.renderFqName(list);
    }

    private final String renderFqName(List<Name> pathSegments) {
        return this.escape(RenderingUtilsKt.renderFqName(pathSegments));
    }

    @Override
    @NotNull
    public String renderClassifierName(@NotNull ClassifierDescriptor klass) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        if (klass instanceof MissingDependencyErrorClass) {
            String string = ((MissingDependencyErrorClass)((Object)klass)).getFullFqName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "klass.fullFqName.asString()");
            return string;
        }
        if (ErrorUtils.isError(klass)) {
            return klass.getTypeConstructor().toString();
        }
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$5[this.getNameShortness().ordinal()]) {
            case 1: {
                ArrayList<Name> qualifiedNameElements = new ArrayList<Name>();
                DeclarationDescriptor current = klass;
                do {
                    DeclarationDescriptor declarationDescriptor = current;
                    if (declarationDescriptor == null) {
                        Intrinsics.throwNpe();
                    }
                    qualifiedNameElements.add(declarationDescriptor.getName());
                } while ((current = current.getContainingDeclaration()) instanceof ClassDescriptor);
                return this.renderFqName(CollectionsKt.asReversedMutable((List)qualifiedNameElements));
            }
            case 2: {
                FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(klass);
                Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "DescriptorUtils.getFqName(klass)");
                return this.renderFqName(fqNameUnsafe);
            }
            case 3: {
                return RenderingUtilsKt.qualifiedNameForSourceCode(klass);
            }
        }
        throw (Throwable)new IllegalArgumentException();
    }

    @Override
    @NotNull
    public String renderType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull(type2, "type");
        return this.renderNormalizedType(this.getTypeNormalizer().invoke(type2));
    }

    private final String renderNormalizedType(KotlinType type2) {
        if (type2 instanceof LazyType && this.getDebugMode()) {
            return type2.toString();
        }
        if (DynamicTypesKt.isDynamic(type2)) {
            return "dynamic";
        }
        if (FlexibleTypesKt.isFlexible(type2)) {
            if (this.getDebugMode()) {
                return this.renderFlexibleTypeWithBothBounds(FlexibleTypesKt.flexibility(type2).getLowerBound(), FlexibleTypesKt.flexibility(type2).getUpperBound());
            }
            if (this.getFlexibleTypesForCode()) {
                String prefix = Intrinsics.areEqual((Object)this.getNameShortness(), (Object)NameShortness.SHORT) ? "" : Flexibility.Companion.getFLEXIBLE_TYPE_CLASSIFIER().getPackageFqName().asString() + ".";
                return prefix + Flexibility.Companion.getFLEXIBLE_TYPE_CLASSIFIER().getRelativeClassName() + this.lt() + this.renderNormalizedType(FlexibleTypesKt.flexibility(type2).getLowerBound()) + ", " + this.renderNormalizedType(FlexibleTypesKt.flexibility(type2).getUpperBound()) + this.gt();
            }
            return this.renderFlexibleType(type2);
        }
        return this.renderInflexibleType(type2);
    }

    private final String renderFlexibleTypeWithBothBounds(KotlinType lower, KotlinType upper) {
        return this.renderFlexibleTypeWithBothBounds(this.renderNormalizedType(lower), this.renderNormalizedType(upper));
    }

    private final String renderFlexibleTypeWithBothBounds(String lower, String upper) {
        return "(" + lower + ".." + upper + ")";
    }

    private final String renderInflexibleType(KotlinType type2) {
        String customResult;
        Unit unit;
        boolean value$iv = !FlexibleTypesKt.isFlexible(type2);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "Flexible types not allowed here: " + this.renderNormalizedType(type2);
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        KotlinType $receiver$iv = type2;
        CustomFlexibleRendering customFlexibleRendering = $receiver$iv.getCapability(CustomFlexibleRendering.class);
        String string = customResult = customFlexibleRendering != null ? customFlexibleRendering.renderInflexible(type2, this) : null;
        if (customResult != null) {
            return customResult;
        }
        if (Intrinsics.areEqual(type2, TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE) || TypeUtils.isDontCarePlaceholder(type2)) {
            return "???";
        }
        if (ErrorUtils.isUninferredParameter(type2)) {
            if (this.getUninferredTypeParameterAsName()) {
                TypeConstructor typeConstructor2 = type2.getConstructor();
                if (typeConstructor2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.ErrorUtils.UninferredParameterTypeConstructor");
                }
                String string2 = ((ErrorUtils.UninferredParameterTypeConstructor)typeConstructor2).getTypeParameterDescriptor().getName().toString();
                Intrinsics.checkExpressionValueIsNotNull(string2, "(type.getConstructor() a\u2026or().getName().toString()");
                return this.renderError(string2);
            }
            return "???";
        }
        if (type2.isError()) {
            return this.renderDefaultType(type2);
        }
        if (this.shouldRenderAsPrettyFunctionType(type2)) {
            return this.renderFunctionType(type2);
        }
        return this.renderDefaultType(type2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldRenderAsPrettyFunctionType(KotlinType type2) {
        Object element$iv;
        TypeProjection it;
        if (!this.getPrettyFunctionTypes()) return false;
        if (!KotlinBuiltIns.isExactFunctionOrExtensionFunctionType(type2)) return false;
        Iterable $receiver$iv = type2.getArguments();
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (!(it = (TypeProjection)(element$iv = iterator2.next())).isStarProjection());
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final String renderFlexibleType(KotlinType type2) {
        void upperRendered;
        void lowerRendered;
        void $receiver$iv;
        KotlinType lower = FlexibleTypesKt.flexibility(type2).getLowerBound();
        KotlinType upper = FlexibleTypesKt.flexibility(type2).getUpperBound();
        KotlinType kotlinType = type2;
        Object object = $receiver$iv.getCapability(CustomFlexibleRendering.class);
        if (object == null || (object = object.renderBounds(FlexibleTypesKt.flexibility(type2), this)) == null) {
            object = new Pair<String, String>(this.renderInflexibleType(lower), this.renderInflexibleType(upper));
        }
        Pair<String, String> pair = object;
        String string = pair.component1();
        String string2 = pair.component2();
        pair = null;
        if (this.differsOnlyInNullability((String)lowerRendered, (String)upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, "(", false, 2)) {
                return "(" + (String)lowerRendered + ")!";
            }
            return (String)lowerRendered + "!";
        }
        String kotlinPrefix = Intrinsics.areEqual((Object)this.getNameShortness(), (Object)NameShortness.SHORT) ^ true ? "kotlin." : "";
        String mutablePrefix = "Mutable";
        String simpleCollection = this.replacePrefixes((String)lowerRendered, kotlinPrefix + mutablePrefix, (String)upperRendered, kotlinPrefix, kotlinPrefix + "(" + mutablePrefix + ")");
        if (simpleCollection != null) {
            return simpleCollection;
        }
        String mutableEntry = this.replacePrefixes((String)lowerRendered, kotlinPrefix + "MutableMap.MutableEntry", (String)upperRendered, kotlinPrefix + "Map.Entry", kotlinPrefix + "(Mutable)Map.(Mutable)Entry");
        if (mutableEntry != null) {
            return mutableEntry;
        }
        String array = this.replacePrefixes((String)lowerRendered, kotlinPrefix + this.escape("Array<"), (String)upperRendered, kotlinPrefix + this.escape("Array<out "), kotlinPrefix + this.escape("Array<(out) "));
        if (array != null) {
            return array;
        }
        return this.renderFlexibleTypeWithBothBounds((String)lowerRendered, (String)upperRendered);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderTypeArguments(@NotNull List<? extends TypeProjection> typeArguments) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(typeArguments, "typeArguments");
        if (typeArguments.isEmpty()) {
            return "";
        }
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        $receiver.append(this.lt());
        this.appendTypeProjections(typeArguments, $receiver);
        $receiver.append(this.gt());
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026t())\n        }.toString()");
        return string;
    }

    private final String renderDefaultType(KotlinType type2) {
        StringBuilder sb = new StringBuilder();
        this.renderAnnotations(type2, sb, true);
        if (type2.isError()) {
            sb.append(type2.getConstructor().toString());
            List<TypeProjection> list = type2.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list, "type.getArguments()");
            sb.append(this.renderTypeArguments(list));
        } else {
            sb.append(DescriptorRendererImpl.renderTypeConstructorAndArguments$default(this, type2, null, 2));
        }
        if (type2.isMarkedNullable()) {
            sb.append("?");
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String renderTypeConstructorAndArguments(KotlinType type2, TypeConstructor typeConstructor2) {
        void var3_3;
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
        if (possiblyInnerType == null) {
            $receiver.append(this.renderTypeConstructor(typeConstructor2));
            List<TypeProjection> list = type2.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list, "type.arguments");
            $receiver.append(this.renderTypeArguments(list));
        } else {
            $receiver.append(this.renderPossiblyInnerType(possiblyInnerType));
        }
        String string = ((StringBuilder)var3_3).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string.toString();
    }

    static /* bridge */ /* synthetic */ String renderTypeConstructorAndArguments$default(DescriptorRendererImpl descriptorRendererImpl, KotlinType kotlinType, TypeConstructor typeConstructor2, int n) {
        if ((n & 2) != 0) {
            TypeConstructor typeConstructor3 = kotlinType.getConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "type.constructor");
            typeConstructor2 = typeConstructor3;
        }
        return descriptorRendererImpl.renderTypeConstructorAndArguments(kotlinType, typeConstructor2);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderPossiblyInnerType(PossiblyInnerType possiblyInnerType) {
        void var2_2;
        StringBuilder $receiver;
        block3: {
            Object object;
            block2: {
                void $receiver$iv;
                StringBuilder $receiver$iv$iv = new StringBuilder();
                $receiver = $receiver$iv$iv;
                object = possiblyInnerType.getOuterType();
                if (object == null) break block2;
                PossiblyInnerType possiblyInnerType2 = object;
                PossiblyInnerType it = (PossiblyInnerType)$receiver$iv;
                $receiver.append(this.renderPossiblyInnerType(it));
                $receiver.append('.');
                Name name = possiblyInnerType.getClassDescriptor().getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "possiblyInnerType.classDescriptor.name");
                object = $receiver.append(this.renderName(name));
                if (object != null) break block3;
            }
            TypeConstructor typeConstructor2 = possiblyInnerType.getClassDescriptor().getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor2, "possiblyInnerType.classDescriptor.typeConstructor");
            object = $receiver.append(this.renderTypeConstructor(typeConstructor2));
        }
        $receiver.append(this.renderTypeArguments(possiblyInnerType.getArguments()));
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String renderTypeConstructor(@NotNull TypeConstructor typeConstructor2) {
        String string;
        ClassifierDescriptor cd;
        Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
        ClassifierDescriptor classifierDescriptor = cd = typeConstructor2.getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            Name name = cd.getName();
            Intrinsics.checkExpressionValueIsNotNull(name, "cd.getName()");
            string = this.renderName(name);
        } else {
            string = classifierDescriptor instanceof ClassDescriptor ? this.renderClassifierName(cd) : (Intrinsics.areEqual(classifierDescriptor, null) ? typeConstructor2.toString() : (String)((Object)PreconditionsKt.error("Unexpected classifier: " + cd.getClass())));
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderTypeProjection(@NotNull TypeProjection typeProjection) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(typeProjection, "typeProjection");
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        this.appendTypeProjections(CollectionsKt.listOf(typeProjection), $receiver);
        return ((StringBuilder)var2_2).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final void appendTypeProjections(List<? extends TypeProjection> typeProjections, StringBuilder builder) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv = typeProjections;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string;
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            void var13_10 = destination$iv$iv;
            if (it.isStarProjection()) {
                string = "*";
            } else {
                KotlinType kotlinType = it.getType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.getType()");
                String type2 = this.renderType(kotlinType);
                string = Intrinsics.areEqual((Object)it.getProjectionKind(), (Object)Variance.INVARIANT) ? type2 : (Object)((Object)it.getProjectionKind()) + " " + type2;
            }
            String string2 = string;
            var13_10.add(string2);
        }
        CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)builder, (CharSequence)", ", null, null, 0, null, null, 124);
    }

    /*
     * WARNING - void declaration
     */
    private final String renderFunctionType(KotlinType type2) {
        void var2_2;
        KotlinType receiverType;
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        boolean isNullable = type2.isMarkedNullable();
        if (isNullable) {
            $receiver.append("(");
        }
        if ((receiverType = KotlinBuiltIns.getReceiverType(type2)) != null) {
            boolean surroundReceiver;
            boolean bl = surroundReceiver = this.shouldRenderAsPrettyFunctionType(receiverType) && !receiverType.isMarkedNullable();
            if (surroundReceiver) {
                $receiver.append("(");
            }
            $receiver.append(this.renderNormalizedType(receiverType));
            if (surroundReceiver) {
                $receiver.append(")");
            }
            $receiver.append(".");
        }
        $receiver.append("(");
        List<TypeProjection> list = KotlinBuiltIns.getParameterTypeProjectionsFromFunctionType(type2);
        Intrinsics.checkExpressionValueIsNotNull(list, "KotlinBuiltIns.getParame\u2026onsFromFunctionType(type)");
        this.appendTypeProjections(list, $receiver);
        $receiver.append(") ").append(this.arrow()).append(" ");
        KotlinType kotlinType = KotlinBuiltIns.getReturnTypeFromFunctionType(type2);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "KotlinBuiltIns.getReturnTypeFromFunctionType(type)");
        $receiver.append(this.renderNormalizedType(kotlinType));
        if (isNullable) {
            $receiver.append(")?");
        }
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026)?\")\n        }.toString()");
        return string;
    }

    private final void appendDefinedIn(DeclarationDescriptor descriptor2, StringBuilder builder) {
        if (descriptor2 instanceof PackageFragmentDescriptor || descriptor2 instanceof PackageViewDescriptor) {
            return;
        }
        if (descriptor2 instanceof ModuleDescriptor) {
            builder.append(" is a module");
            return;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration != null && !(containingDeclaration instanceof ModuleDescriptor)) {
            String string;
            builder.append(" ").append(this.renderMessage("defined in")).append(" ");
            FqNameUnsafe fqName2 = DescriptorUtils.getFqName(containingDeclaration);
            if (fqName2.isRoot()) {
                string = "root package";
            } else {
                FqNameUnsafe fqNameUnsafe = fqName2;
                Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "fqName");
                string = this.renderFqName(fqNameUnsafe);
            }
            builder.append(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderAnnotations(Annotated annotated, StringBuilder builder, boolean needBrackets) {
        void $receiver$iv$iv;
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.ANNOTATIONS) ^ true) {
            return;
        }
        Set<FqName> excluded = annotated instanceof KotlinType ? this.getExcludedTypeAnnotationClasses() : this.getExcludedAnnotationClasses();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder $receiver = (StringBuilder)$receiver$iv$iv;
        List<AnnotationWithTarget> sortedAnnotations = annotated.getAnnotations().getAllAnnotations();
        for (AnnotationWithTarget annotationWithTarget : sortedAnnotations) {
            AnnotationDescriptor annotation2 = annotationWithTarget.component1();
            AnnotationUseSiteTarget target = annotationWithTarget.component2();
            ClassifierDescriptor classifierDescriptor = annotation2.getType().getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor annotationClass = (ClassDescriptor)classifierDescriptor;
            if (excluded.contains(DescriptorUtils.getFqNameSafe(annotationClass))) continue;
            $receiver.append(this.renderAnnotation(annotation2, target)).append(" ");
        }
        StringBuilder annotationsBuilder = (StringBuilder)$receiver$iv$iv;
        builder.append((CharSequence)annotationsBuilder);
    }

    static /* bridge */ /* synthetic */ void renderAnnotations$default(DescriptorRendererImpl descriptorRendererImpl, Annotated annotated, StringBuilder stringBuilder, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        descriptorRendererImpl.renderAnnotations(annotated, stringBuilder, bl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderAnnotation(@NotNull AnnotationDescriptor annotation2, @Nullable AnnotationUseSiteTarget target) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(annotation2, "annotation");
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        $receiver.append('@');
        if (target != null) {
            $receiver.append(target.getRenderName() + ":");
        }
        KotlinType kotlinType = annotation2.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "annotation.getType()");
        $receiver.append(this.renderType(kotlinType));
        if (this.getVerbose()) {
            CollectionsKt.joinTo$default((Iterable)this.renderAndSortAnnotationArguments(annotation2), (Appendable)$receiver, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", 0, null, null, 112);
        }
        String string = ((StringBuilder)var3_3).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026   }\n        }.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> renderAndSortAnnotationArguments(AnnotationDescriptor descriptor2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        String string;
        Collection collection;
        Collection destination$iv$iv2;
        ValueParameterDescriptor it;
        Object $receiver$iv$iv2;
        Iterable $receiver$iv2;
        List list;
        void destination$iv$iv3;
        Object element$iv$iv2;
        Iterable $receiver$iv$iv3;
        Map<ValueParameterDescriptor, ConstantValue<?>> allValueArguments2 = descriptor2.getAllValueArguments();
        ClassDescriptor classDescriptor = this.getRenderDefaultAnnotationArguments() ? TypeUtils.getClassDescriptor(descriptor2.getType()) : (ClassDescriptor)null;
        Object object = classDescriptor;
        if (object != null && (object = object.getUnsubstitutedPrimaryConstructor()) != null && (object = object.getValueParameters()) != null) {
            void $receiver$iv3;
            Iterable iterable = (Iterable)object;
            void var6_5 = $receiver$iv3;
            Collection collection2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv3) {
                ValueParameterDescriptor it2 = (ValueParameterDescriptor)element$iv$iv2;
                if (!it2.declaresDefaultValue()) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            list = (List)destination$iv$iv3;
        } else {
            list = CollectionsKt.emptyList();
        }
        List parameterDescriptorsWithDefaultValue = list;
        $receiver$iv$iv3 = parameterDescriptorsWithDefaultValue;
        destination$iv$iv3 = $receiver$iv2;
        Collection collection3 = new ArrayList();
        element$iv$iv2 = $receiver$iv$iv2.iterator();
        while (element$iv$iv2.hasNext()) {
            Object element$iv$iv3 = element$iv$iv2.next();
            it = (ValueParameterDescriptor)element$iv$iv3;
            if (!(!allValueArguments2.containsKey(it))) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
        element$iv$iv2 = $receiver$iv$iv2.iterator();
        while (element$iv$iv2.hasNext()) {
            Object item$iv$iv = element$iv$iv2.next();
            it = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv2;
            string = it.getName().asString() + " = ...";
            collection.add(string);
        }
        List defaultList = (List)destination$iv$iv2;
        $receiver$iv$iv2 = allValueArguments2;
        $receiver$iv = $receiver$iv.entrySet();
        Iterable $i$f$entrySet = $receiver$iv;
        element$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string2;
            void entry;
            Map.Entry $i$a$2 = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            String name = ((ValueParameterDescriptor)entry.getKey()).getName().asString();
            if (!parameterDescriptorsWithDefaultValue.contains(entry.getKey())) {
                ConstantValue constantValue = (ConstantValue)entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull(constantValue, "entry.value");
                string2 = this.renderConstant(constantValue);
            } else {
                string2 = "...";
            }
            String value = string2;
            string = name + " = " + value;
            collection.add(string);
        }
        List argumentList2 = (List)destination$iv$iv;
        return CollectionsKt.sorted(CollectionsKt.plus((Collection)defaultList, (Iterable)argumentList2));
    }

    /*
     * WARNING - void declaration
     */
    private final String renderConstant(ConstantValue<?> value) {
        String string;
        ConstantValue<?> constantValue = value;
        if (constantValue instanceof ArrayValue) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = (Iterable)((ArrayValue)value).getValue();
            Iterable iterable = $receiver$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ConstantValue constantValue2 = (ConstantValue)item$iv$iv;
                void var12_9 = destination$iv$iv;
                String string2 = this.renderConstant((ConstantValue<?>)it);
                var12_9.add(string2);
            }
            string = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", 0, null, null, 56);
        } else {
            string = constantValue instanceof AnnotationValue ? StringsKt.removePrefix(DescriptorRenderer.renderAnnotation$default(this, (AnnotationDescriptor)((AnnotationValue)value).getValue(), null, 2), (CharSequence)"@") : (constantValue instanceof KClassValue ? this.renderType(((KClassValue)value).getValue()) + "::class" : value.toString());
        }
        return string;
    }

    private final void renderVisibility(Visibility visibility, StringBuilder builder) {
        Visibility visibility2 = visibility;
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.VISIBILITY) ^ true) {
            return;
        }
        if (this.getNormalizedVisibilities()) {
            visibility2 = visibility2.normalize();
        }
        if (!this.getShowInternalKeyword() && Intrinsics.areEqual(visibility2, Visibilities.DEFAULT_VISIBILITY)) {
            return;
        }
        builder.append(this.renderKeyword(visibility2.getDisplayName())).append(" ");
    }

    /*
     * WARNING - void declaration
     */
    private final void renderModality(Modality modality, StringBuilder builder) {
        void $receiver$iv;
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.MODALITY) ^ true) {
            return;
        }
        Enum enum_ = modality;
        String keyword = StringsKt.toLowerCase($receiver$iv.name());
        builder.append(this.renderKeyword(keyword)).append(" ");
    }

    private final void renderInner(boolean isInner, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.INNER) ^ true) {
            return;
        }
        if (isInner) {
            builder.append(this.renderKeyword("inner")).append(" ");
        }
    }

    private final void renderData(boolean isData, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.DATA) ^ true || !isData) {
            return;
        }
        builder.append(this.renderKeyword("data")).append(" ");
    }

    private final void renderModalityForCallable(CallableMemberDescriptor callable, StringBuilder builder) {
        if (!DescriptorUtils.isTopLevelDeclaration(callable) || Intrinsics.areEqual((Object)callable.getModality(), (Object)Modality.FINAL) ^ true) {
            if (this.overridesSomething(callable) && Intrinsics.areEqual((Object)this.getOverrideRenderingPolicy(), (Object)OverrideRenderingPolicy.RENDER_OVERRIDE) && Intrinsics.areEqual((Object)callable.getModality(), (Object)Modality.OPEN)) {
                return;
            }
            Modality modality = callable.getModality();
            Intrinsics.checkExpressionValueIsNotNull((Object)modality, "callable.getModality()");
            this.renderModality(modality, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderOverride(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.OVERRIDE) ^ true) {
            return;
        }
        if (this.overridesSomething(callableMember) && Intrinsics.areEqual((Object)this.getOverrideRenderingPolicy(), (Object)OverrideRenderingPolicy.RENDER_OPEN) ^ true) {
            builder.append("override ");
            if (this.getVerbose()) {
                void $receiver$iv;
                Collection<? extends CallableMemberDescriptor> collection = callableMember.getOverriddenDescriptors();
                StringBuilder stringBuilder = builder.append("/*");
                int n = $receiver$iv.size();
                stringBuilder.append(n).append("*/ ");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderMemberKind(CallableMemberDescriptor callableMember, StringBuilder builder) {
        if (this.getModifiers().contains((Object)DescriptorRendererModifier.MEMBER_KIND) ^ true) {
            return;
        }
        if (this.getVerbose() && Intrinsics.areEqual((Object)callableMember.getKind(), (Object)CallableMemberDescriptor.Kind.DECLARATION) ^ true) {
            void $receiver$iv;
            Enum enum_ = callableMember.getKind();
            StringBuilder stringBuilder = builder.append("/*");
            String string = $receiver$iv.name();
            stringBuilder.append(StringsKt.toLowerCase(string)).append("*/ ");
        }
    }

    private final void renderLateInit(PropertyDescriptor propertyDescriptor, StringBuilder builder) {
        if (propertyDescriptor.isLateInit()) {
            builder.append("lateinit ");
        }
    }

    private final void renderAdditionalModifiers(FunctionDescriptor functionDescriptor, StringBuilder builder) {
        FunctionDescriptor it;
        Iterable $receiver$iv;
        if (functionDescriptor.isOperator()) {
            boolean bl;
            block9: {
                $receiver$iv = functionDescriptor.getOverriddenDescriptors();
                for (Object element$iv : $receiver$iv) {
                    it = (FunctionDescriptor)element$iv;
                    if (!it.isOperator()) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
            if (bl || this.getAlwaysRenderModifiers()) {
                builder.append("operator ");
            }
        }
        if (functionDescriptor.isInfix()) {
            boolean bl;
            block10: {
                $receiver$iv = functionDescriptor.getOverriddenDescriptors();
                for (Object element$iv : $receiver$iv) {
                    it = (FunctionDescriptor)element$iv;
                    if (!it.isInfix()) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
            if (bl || this.getAlwaysRenderModifiers()) {
                builder.append("infix ");
            }
        }
        if (functionDescriptor.isExternal()) {
            builder.append("external ");
        }
        if (functionDescriptor.isInline()) {
            builder.append("inline ");
        }
        if (functionDescriptor.isTailrec()) {
            builder.append("tailrec ");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull(declarationDescriptor, "declarationDescriptor");
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        declarationDescriptor.accept(new RenderDeclarationDescriptorVisitor(), $receiver);
        if (this.getWithDefinedIn()) {
            this.appendDefinedIn(declarationDescriptor, $receiver);
        }
        String string = ((StringBuilder)var2_2).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder {\n        \u2026   }\n        }.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void renderTypeParameter(TypeParameterDescriptor typeParameter, StringBuilder builder, boolean topLevel) {
        void $receiver$iv;
        String variance;
        if (topLevel) {
            builder.append(this.lt());
        }
        if (this.getVerbose()) {
            builder.append("/*").append(typeParameter.getIndex()).append("*/ ");
        }
        if (typeParameter.isReified()) {
            builder.append(this.renderKeyword("reified")).append(" ");
        }
        if (!StringsKt.isEmpty((CharSequence)(variance = typeParameter.getVariance().getLabel()))) {
            builder.append(this.renderKeyword(variance)).append(" ");
        }
        this.renderName(typeParameter, builder);
        Collection collection = typeParameter.getUpperBounds();
        int upperBoundsCount = $receiver$iv.size();
        if (upperBoundsCount > 1 && !topLevel || upperBoundsCount == 1) {
            KotlinType upperBound = typeParameter.getUpperBounds().iterator().next();
            if (!KotlinBuiltIns.isDefaultBound(upperBound)) {
                StringBuilder stringBuilder = builder.append(" : ");
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                stringBuilder.append(this.renderType(kotlinType));
            }
        } else if (topLevel) {
            boolean first = true;
            for (KotlinType upperBound : typeParameter.getUpperBounds()) {
                if (KotlinBuiltIns.isDefaultBound(upperBound)) continue;
                if (first) {
                    builder.append(" : ");
                } else {
                    builder.append(" & ");
                }
                KotlinType kotlinType = upperBound;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "upperBound");
                builder.append(this.renderType(kotlinType));
                first = false;
            }
        }
        if (topLevel) {
            builder.append(this.gt());
        }
    }

    private final void renderTypeParameters(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder, boolean withSpace) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        if (!typeParameters.isEmpty()) {
            builder.append(this.lt());
            this.renderTypeParameterList(builder, typeParameters);
            builder.append(this.gt());
            if (withSpace) {
                builder.append(" ");
            }
        }
    }

    private final void renderTypeParameterList(StringBuilder builder, List<? extends TypeParameterDescriptor> typeParameters) {
        Iterator<? extends TypeParameterDescriptor> iterator2 = typeParameters.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = iterator2.next();
            this.renderTypeParameter(typeParameterDescriptor, builder, false);
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
    }

    private final void renderFunction(FunctionDescriptor function, StringBuilder builder) {
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, function, builder, false, 4);
            Visibility visibility = function.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "function.getVisibility()");
            this.renderVisibility(visibility, builder);
            this.renderModalityForCallable(function, builder);
            this.renderAdditionalModifiers(function, builder);
            this.renderOverride(function, builder);
            this.renderMemberKind(function, builder);
            if (this.getVerbose() && function.isHiddenToOvercomeSignatureClash()) {
                builder.append("/*isHiddenToOvercomeSignatureClash*/ ");
            }
            builder.append(this.renderKeyword("fun")).append(" ");
            List<TypeParameterDescriptor> list = function.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "function.getTypeParameters()");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(function, builder);
        }
        this.renderName(function, builder);
        Collection collection = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection, "function.valueParameters");
        this.renderValueParameters(collection, function.hasSynthesizedParameterNames(), builder);
        this.renderReceiverAfterName(function, builder);
        KotlinType returnType2 = function.getReturnType();
        if (!(this.getWithoutReturnType() || !this.getUnitReturnType() && returnType2 != null && KotlinBuiltIns.isUnit(returnType2))) {
            builder.append(": ").append(returnType2 == null ? "[NULL]" : this.escape(this.renderType(returnType2)));
        }
        List<TypeParameterDescriptor> list = function.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "function.getTypeParameters()");
        this.renderWhereSuffix(list, builder);
    }

    private final void renderReceiverAfterName(CallableDescriptor callableDescriptor, StringBuilder builder) {
        if (!this.getReceiverAfterName()) {
            return;
        }
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            StringBuilder stringBuilder = builder.append(" on ");
            KotlinType kotlinType = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiver.getType()");
            stringBuilder.append(this.escape(this.renderType(kotlinType)));
        }
    }

    private final void renderReceiver(CallableDescriptor callableDescriptor, StringBuilder builder) {
        ReceiverParameterDescriptor receiver = callableDescriptor.getExtensionReceiverParameter();
        if (receiver != null) {
            KotlinType type2;
            KotlinType kotlinType = type2 = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
            String result2 = this.escape(this.renderType(kotlinType));
            KotlinType kotlinType2 = type2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "type");
            if (this.shouldRenderAsPrettyFunctionType(kotlinType2) && !TypeUtils.isNullableType(type2)) {
                result2 = "(" + result2 + ")";
            }
            builder.append(result2).append(".");
        }
    }

    private final void renderConstructor(ConstructorDescriptor constructor, StringBuilder builder) {
        DescriptorRendererImpl.renderAnnotations$default(this, constructor, builder, false, 4);
        Visibility visibility = constructor.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull(visibility, "constructor.getVisibility()");
        this.renderVisibility(visibility, builder);
        this.renderMemberKind(constructor, builder);
        builder.append(this.renderKeyword("constructor"));
        if (this.getSecondaryConstructorsAsPrimary()) {
            ClassDescriptor classDescriptor = constructor.getContainingDeclaration();
            builder.append(" ");
            DeclarationDescriptor declarationDescriptor = classDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "classDescriptor");
            this.renderName(declarationDescriptor, builder);
            List<TypeParameterDescriptor> list = classDescriptor.getDeclaredTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "classDescriptor.declaredTypeParameters");
            this.renderTypeParameters(list, builder, false);
        }
        Collection collection = constructor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(collection, "constructor.valueParameters");
        this.renderValueParameters(collection, constructor.hasSynthesizedParameterNames(), builder);
        if (this.getSecondaryConstructorsAsPrimary()) {
            List<TypeParameterDescriptor> list = constructor.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "constructor.getTypeParameters()");
            this.renderWhereSuffix(list, builder);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderWhereSuffix(List<? extends TypeParameterDescriptor> typeParameters, StringBuilder builder) {
        if (this.getWithoutTypeParameters()) {
            return;
        }
        ArrayList upperBoundStrings = new ArrayList(0);
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            void $receiver$iv;
            Iterable iterable = CollectionsKt.drop((Iterable)typeParameterDescriptor.getUpperBounds(), 1);
            for (Object item$iv : $receiver$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)item$iv;
                Collection collection = upperBoundStrings;
                StringBuilder stringBuilder = new StringBuilder();
                Name name = typeParameterDescriptor.getName();
                Intrinsics.checkExpressionValueIsNotNull(name, "typeParameter.getName()");
                StringBuilder stringBuilder2 = stringBuilder.append(this.renderName(name)).append(" : ");
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull(v3, "it");
                String string = stringBuilder2.append(this.escape(this.renderType((KotlinType)v3))).toString();
                collection.add(string);
            }
        }
        if (!upperBoundStrings.isEmpty()) {
            builder.append(" ").append(this.renderKeyword("where")).append(" ");
            CollectionsKt.joinTo$default((Iterable)upperBoundStrings, (Appendable)builder, (CharSequence)", ", null, null, 0, null, null, 124);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String renderValueParameters(@NotNull Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull(parameters2, "parameters");
        StringBuilder $receiver$iv$iv = new StringBuilder();
        StringBuilder $receiver = $receiver$iv$iv;
        this.renderValueParameters(parameters2, synthesizedParameterNames, $receiver);
        String string = ((StringBuilder)var3_3).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "StringBuilder { renderVa\u2026Names, this) }.toString()");
        return string;
    }

    private final void renderValueParameters(Collection<? extends ValueParameterDescriptor> parameters2, boolean synthesizedParameterNames, StringBuilder builder) {
        boolean includeNames = this.shouldRenderParameterNames(synthesizedParameterNames);
        Collection<? extends ValueParameterDescriptor> object2 = parameters2;
        int parameterCount = object2.size();
        this.getValueParametersHandler().appendBeforeValueParameters(parameterCount, builder);
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)parameters2)) {
            int index2 = indexedValue.component1();
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)indexedValue.component2();
            this.getValueParametersHandler().appendBeforeValueParameter(parameter, index2, parameterCount, builder);
            this.renderValueParameter(parameter, includeNames, builder, false);
            this.getValueParametersHandler().appendAfterValueParameter(parameter, index2, parameterCount, builder);
        }
        this.getValueParametersHandler().appendAfterValueParameters(parameterCount, builder);
    }

    private final boolean shouldRenderParameterNames(boolean synthesizedParameterNames) {
        switch (DescriptorRendererImpl$WhenMappings.$EnumSwitchMapping$6[this.getParameterNameRenderingPolicy().ordinal()]) {
            case 1: {
                return true;
            }
            case 2: {
                return !synthesizedParameterNames;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    private final void renderValueParameter(ValueParameterDescriptor valueParameter, boolean includeName, StringBuilder builder, boolean topLevel) {
        boolean withDefaultValue;
        if (topLevel) {
            builder.append(this.renderKeyword("value-parameter")).append(" ");
        }
        if (this.getVerbose()) {
            builder.append("/*").append(valueParameter.getIndex()).append("*/ ");
        }
        DescriptorRendererImpl.renderAnnotations$default(this, valueParameter, builder, false, 4);
        if (valueParameter.isCrossinline()) {
            builder.append("crossinline ");
        }
        if (valueParameter.isNoinline()) {
            builder.append("noinline ");
        }
        this.renderVariable(valueParameter, includeName, builder, topLevel);
        boolean bl = this.getRenderDefaultValues() && (this.getDebugMode() ? valueParameter.declaresDefaultValue() : DescriptorUtilsKt.hasDefaultValue(valueParameter)) ? true : (withDefaultValue = false);
        if (withDefaultValue) {
            builder.append(" = ...");
        }
    }

    private final void renderValVarPrefix(VariableDescriptor variable, StringBuilder builder) {
        builder.append(this.renderKeyword(variable.isVar() ? "var" : "val")).append(" ");
    }

    private final void renderVariable(VariableDescriptor variable, boolean includeName, StringBuilder builder, boolean topLevel) {
        KotlinType realType = variable.getType();
        VariableDescriptor variableDescriptor = variable;
        if (!(variableDescriptor instanceof ValueParameterDescriptor)) {
            variableDescriptor = null;
        }
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)variableDescriptor;
        KotlinType varargElementType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        KotlinType kotlinType = varargElementType;
        if (kotlinType == null) {
            KotlinType kotlinType2 = realType;
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "realType");
        }
        KotlinType typeToRender = kotlinType;
        if (varargElementType != null) {
            builder.append(this.renderKeyword("vararg")).append(" ");
        }
        if (topLevel && !this.getStartFromName()) {
            this.renderValVarPrefix(variable, builder);
        }
        if (includeName) {
            this.renderName(variable, builder);
            builder.append(": ");
        }
        builder.append(this.escape(this.renderType(typeToRender)));
        this.renderInitializer(variable, builder);
        if (this.getVerbose() && varargElementType != null) {
            StringBuilder stringBuilder = builder.append(" /*");
            KotlinType kotlinType3 = realType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "realType");
            stringBuilder.append(this.escape(this.renderType(kotlinType3))).append("*/");
        }
    }

    private final void renderProperty(PropertyDescriptor property, StringBuilder builder) {
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, property, builder, false, 4);
            Visibility visibility = property.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "property.getVisibility()");
            this.renderVisibility(visibility, builder);
            if (property.isConst()) {
                builder.append("const ");
            }
            this.renderModalityForCallable(property, builder);
            this.renderOverride(property, builder);
            this.renderLateInit(property, builder);
            this.renderMemberKind(property, builder);
            this.renderValVarPrefix(property, builder);
            List<TypeParameterDescriptor> list = property.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, "property.getTypeParameters()");
            this.renderTypeParameters(list, builder, true);
            this.renderReceiver(property, builder);
        }
        this.renderName(property, builder);
        StringBuilder stringBuilder = builder.append(": ");
        KotlinType kotlinType = property.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "property.getType()");
        stringBuilder.append(this.escape(this.renderType(kotlinType)));
        this.renderReceiverAfterName(property, builder);
        this.renderInitializer(property, builder);
        List<TypeParameterDescriptor> list = property.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "property.getTypeParameters()");
        this.renderWhereSuffix(list, builder);
    }

    private final void renderInitializer(VariableDescriptor variable, StringBuilder builder) {
        if (this.getIncludePropertyConstant()) {
            StringBuilder stringBuilder;
            ConstantValue<?> constantValue = variable.getCompileTimeInitializer();
            if (constantValue != null) {
                ConstantValue<?> $receiver$iv = constantValue;
                ConstantValue<?> constant = $receiver$iv;
                StringBuilder stringBuilder2 = builder.append(" = ");
                ConstantValue<?> constantValue2 = constant;
                Intrinsics.checkExpressionValueIsNotNull(constantValue2, "constant");
                stringBuilder = stringBuilder2.append(this.escape(this.renderConstant(constantValue2)));
            } else {
                stringBuilder = null;
            }
        }
    }

    private final void renderClass(ClassDescriptor klass, StringBuilder builder) {
        ConstructorDescriptor primaryConstructor2;
        List<TypeParameterDescriptor> typeParameters;
        boolean isEnumEntry = Intrinsics.areEqual((Object)klass.getKind(), (Object)ClassKind.ENUM_ENTRY);
        if (!this.getStartFromName()) {
            DescriptorRendererImpl.renderAnnotations$default(this, klass, builder, false, 4);
            if (!isEnumEntry) {
                Visibility visibility = klass.getVisibility();
                Intrinsics.checkExpressionValueIsNotNull(visibility, "klass.visibility");
                this.renderVisibility(visibility, builder);
            }
            if (!(Intrinsics.areEqual((Object)klass.getKind(), (Object)ClassKind.INTERFACE) && Intrinsics.areEqual((Object)klass.getModality(), (Object)Modality.ABSTRACT) || klass.getKind().isSingleton() && Intrinsics.areEqual((Object)klass.getModality(), (Object)Modality.FINAL))) {
                Modality modality = klass.getModality();
                Intrinsics.checkExpressionValueIsNotNull((Object)modality, "klass.modality");
                this.renderModality(modality, builder);
            }
            this.renderInner(klass.isInner(), builder);
            this.renderData(klass.isData(), builder);
            this.renderClassKindPrefix(klass, builder);
        }
        if (!DescriptorUtils.isCompanionObject(klass)) {
            if (!this.getStartFromName()) {
                this.renderSpaceIfNeeded(builder);
            }
            this.renderName(klass, builder);
        } else {
            this.renderCompanionObjectName(klass, builder);
        }
        if (isEnumEntry) {
            return;
        }
        List<TypeParameterDescriptor> list = typeParameters = klass.getDeclaredTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "typeParameters");
        this.renderTypeParameters(list, builder, false);
        if (this.getVerbose() && klass.isInner() && klass.getTypeConstructor().getParameters().size() > typeParameters.size()) {
            builder.append(" /*captured type parameters: ");
            List<TypeParameterDescriptor> constructorTypeParameters = klass.getTypeConstructor().getParameters();
            this.renderTypeParameterList(builder, constructorTypeParameters.subList(typeParameters.size(), constructorTypeParameters.size()));
            builder.append("*/");
        }
        if (!klass.getKind().isSingleton() && this.getClassWithPrimaryConstructor() && (primaryConstructor2 = klass.getUnsubstitutedPrimaryConstructor()) != null) {
            builder.append(" ");
            this.renderAnnotations(primaryConstructor2, builder, true);
            Visibility visibility = primaryConstructor2.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "primaryConstructor.visibility");
            this.renderVisibility(visibility, builder);
            builder.append("constructor");
            Collection collection = primaryConstructor2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(collection, "primaryConstructor.valueParameters");
            this.renderValueParameters(collection, primaryConstructor2.hasSynthesizedParameterNames(), builder);
        }
        this.renderSuperTypes(klass, builder);
        List<TypeParameterDescriptor> list2 = typeParameters;
        Intrinsics.checkExpressionValueIsNotNull(list2, "typeParameters");
        this.renderWhereSuffix(list2, builder);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderSuperTypes(ClassDescriptor klass, StringBuilder builder) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection<KotlinType> supertypes2;
        block7: {
            block6: {
                if (this.getWithoutSuperTypes()) {
                    return;
                }
                if (KotlinBuiltIns.isNothing(klass.getDefaultType())) {
                    return;
                }
                supertypes2 = klass.getTypeConstructor().getSupertypes();
                if (supertypes2.isEmpty()) break block6;
                Collection<KotlinType> collection = supertypes2;
                if ($receiver$iv.size() != 1 || !KotlinBuiltIns.isAnyOrNullableAny(supertypes2.iterator().next())) break block7;
            }
            return;
        }
        this.renderSpaceIfNeeded(builder);
        builder.append(": ");
        $receiver$iv = supertypes2;
        Iterable $i$f$size = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            void var13_10 = destination$iv$iv;
            void v0 = it;
            Intrinsics.checkExpressionValueIsNotNull(v0, "it");
            String string = this.renderType((KotlinType)v0);
            var13_10.add(string);
        }
        CollectionsKt.joinTo$default((Iterable)((List)destination$iv$iv), (Appendable)builder, (CharSequence)", ", null, null, 0, null, null, 124);
    }

    private final void renderClassKindPrefix(ClassDescriptor klass, StringBuilder builder) {
        builder.append(this.renderKeyword(DescriptorRenderer.Companion.getClassKindPrefix(klass)));
    }

    private final void renderPackageView(PackageViewDescriptor packageView, StringBuilder builder) {
        builder.append(this.renderKeyword("package")).append(" ");
        FqNameUnsafe fqNameUnsafe = packageView.getFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "packageView.fqName.toUnsafe()");
        builder.append(this.renderFqName(fqNameUnsafe));
        if (this.getDebugMode()) {
            builder.append(" in context of ");
            this.renderName(packageView.getModule(), builder);
        }
    }

    private final void renderPackageFragment(PackageFragmentDescriptor fragment, StringBuilder builder) {
        builder.append(this.renderKeyword("package-fragment")).append(" ");
        FqNameUnsafe fqNameUnsafe = fragment.getFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "fragment.fqName.toUnsafe()");
        builder.append(this.renderFqName(fqNameUnsafe));
        if (this.getDebugMode()) {
            builder.append(" in ");
            this.renderName(fragment.getContainingDeclaration(), builder);
        }
    }

    private final void renderAccessorModifiers(PropertyAccessorDescriptor descriptor2, StringBuilder builder) {
        if (descriptor2.isExternal()) {
            builder.append("external ");
        }
    }

    private final void renderSpaceIfNeeded(StringBuilder builder) {
        int length = CollectionsKt.length(builder);
        if (length == 0 || CollectionsKt.charAt(builder, length - 1) != ' ') {
            builder.append(' ');
        }
    }

    private final String replacePrefixes(String lowerRendered, String lowerPrefix, String upperRendered, String upperPrefix, String foldedPrefix) {
        if (StringsKt.startsWith$default(lowerRendered, lowerPrefix, false, 2) && StringsKt.startsWith$default(upperRendered, upperPrefix, false, 2)) {
            String lowerWithoutPrefix = StringsKt.substring(lowerRendered, CollectionsKt.length(lowerPrefix));
            String upperWithoutPrefix = StringsKt.substring(upperRendered, CollectionsKt.length(upperPrefix));
            String flexibleCollectionName = foldedPrefix + lowerWithoutPrefix;
            if (Intrinsics.areEqual(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName;
            }
            if (this.differsOnlyInNullability(lowerWithoutPrefix, upperWithoutPrefix)) {
                return flexibleCollectionName + "!";
            }
        }
        return null;
    }

    private final boolean differsOnlyInNullability(String lower, String upper) {
        return Intrinsics.areEqual(lower, StringsKt.replace$default(upper, "?", "", false, 4)) || StringsKt.endsWith$default(upper, "?", false, 2) && Intrinsics.areEqual(lower + "?", upper) || Intrinsics.areEqual("(" + lower + ")?", upper);
    }

    private final boolean overridesSomething(CallableMemberDescriptor callable) {
        return !callable.getOverriddenDescriptors().isEmpty();
    }

    @NotNull
    public final DescriptorRendererOptionsImpl getOptions() {
        return this.options;
    }

    public DescriptorRendererImpl(@NotNull DescriptorRendererOptionsImpl options) {
        Intrinsics.checkParameterIsNotNull(options, "options");
        this.options = options;
        PreconditionsKt.assert(this.options.isLocked());
    }

    @Override
    public boolean getAlwaysRenderModifiers() {
        return this.options.getAlwaysRenderModifiers();
    }

    @Override
    public void setAlwaysRenderModifiers(boolean bl) {
        this.options.setAlwaysRenderModifiers(bl);
    }

    @Override
    public boolean getClassWithPrimaryConstructor() {
        return this.options.getClassWithPrimaryConstructor();
    }

    @Override
    public void setClassWithPrimaryConstructor(boolean bl) {
        this.options.setClassWithPrimaryConstructor(bl);
    }

    @Override
    public boolean getDebugMode() {
        return this.options.getDebugMode();
    }

    @Override
    public void setDebugMode(boolean bl) {
        this.options.setDebugMode(bl);
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedAnnotationClasses() {
        return this.options.getExcludedAnnotationClasses();
    }

    @Override
    public void setExcludedAnnotationClasses(@NotNull Set<FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setExcludedAnnotationClasses(set);
    }

    @Override
    @NotNull
    public Set<FqName> getExcludedTypeAnnotationClasses() {
        return this.options.getExcludedTypeAnnotationClasses();
    }

    @Override
    public void setExcludedTypeAnnotationClasses(@NotNull Set<FqName> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setExcludedTypeAnnotationClasses(set);
    }

    @Override
    public boolean getFlexibleTypesForCode() {
        return this.options.getFlexibleTypesForCode();
    }

    @Override
    public void setFlexibleTypesForCode(boolean bl) {
        this.options.setFlexibleTypesForCode(bl);
    }

    @Override
    public boolean getIncludePropertyConstant() {
        return this.options.getIncludePropertyConstant();
    }

    @Override
    public void setIncludePropertyConstant(boolean bl) {
        this.options.setIncludePropertyConstant(bl);
    }

    @Override
    @NotNull
    public Set<DescriptorRendererModifier> getModifiers() {
        return this.options.getModifiers();
    }

    @Override
    public void setModifiers(@NotNull Set<? extends DescriptorRendererModifier> set) {
        Intrinsics.checkParameterIsNotNull(set, "<set-?>");
        this.options.setModifiers(set);
    }

    @Override
    @NotNull
    public NameShortness getNameShortness() {
        return this.options.getNameShortness();
    }

    @Override
    public void setNameShortness(@NotNull NameShortness nameShortness2) {
        Intrinsics.checkParameterIsNotNull((Object)nameShortness2, "<set-?>");
        this.options.setNameShortness(nameShortness2);
    }

    @Override
    public boolean getNormalizedVisibilities() {
        return this.options.getNormalizedVisibilities();
    }

    @Override
    public void setNormalizedVisibilities(boolean bl) {
        this.options.setNormalizedVisibilities(bl);
    }

    @Override
    @NotNull
    public OverrideRenderingPolicy getOverrideRenderingPolicy() {
        return this.options.getOverrideRenderingPolicy();
    }

    @Override
    public void setOverrideRenderingPolicy(@NotNull OverrideRenderingPolicy overrideRenderingPolicy2) {
        Intrinsics.checkParameterIsNotNull((Object)overrideRenderingPolicy2, "<set-?>");
        this.options.setOverrideRenderingPolicy(overrideRenderingPolicy2);
    }

    @Override
    @NotNull
    public ParameterNameRenderingPolicy getParameterNameRenderingPolicy() {
        return this.options.getParameterNameRenderingPolicy();
    }

    @Override
    public void setParameterNameRenderingPolicy(@NotNull ParameterNameRenderingPolicy parameterNameRenderingPolicy2) {
        Intrinsics.checkParameterIsNotNull((Object)parameterNameRenderingPolicy2, "<set-?>");
        this.options.setParameterNameRenderingPolicy(parameterNameRenderingPolicy2);
    }

    @Override
    public boolean getPrettyFunctionTypes() {
        return this.options.getPrettyFunctionTypes();
    }

    @Override
    public void setPrettyFunctionTypes(boolean bl) {
        this.options.setPrettyFunctionTypes(bl);
    }

    @Override
    public boolean getReceiverAfterName() {
        return this.options.getReceiverAfterName();
    }

    @Override
    public void setReceiverAfterName(boolean bl) {
        this.options.setReceiverAfterName(bl);
    }

    @Override
    public boolean getRenderAccessors() {
        return this.options.getRenderAccessors();
    }

    @Override
    public void setRenderAccessors(boolean bl) {
        this.options.setRenderAccessors(bl);
    }

    @Override
    public boolean getRenderCompanionObjectName() {
        return this.options.getRenderCompanionObjectName();
    }

    @Override
    public void setRenderCompanionObjectName(boolean bl) {
        this.options.setRenderCompanionObjectName(bl);
    }

    @Override
    public boolean getRenderDefaultAnnotationArguments() {
        return this.options.getRenderDefaultAnnotationArguments();
    }

    @Override
    public void setRenderDefaultAnnotationArguments(boolean bl) {
        this.options.setRenderDefaultAnnotationArguments(bl);
    }

    @Override
    public boolean getRenderDefaultValues() {
        return this.options.getRenderDefaultValues();
    }

    @Override
    public void setRenderDefaultValues(boolean bl) {
        this.options.setRenderDefaultValues(bl);
    }

    @Override
    public boolean getSecondaryConstructorsAsPrimary() {
        return this.options.getSecondaryConstructorsAsPrimary();
    }

    @Override
    public void setSecondaryConstructorsAsPrimary(boolean bl) {
        this.options.setSecondaryConstructorsAsPrimary(bl);
    }

    @Override
    public boolean getShowInternalKeyword() {
        return this.options.getShowInternalKeyword();
    }

    @Override
    public void setShowInternalKeyword(boolean bl) {
        this.options.setShowInternalKeyword(bl);
    }

    @Override
    public boolean getStartFromName() {
        return this.options.getStartFromName();
    }

    @Override
    public void setStartFromName(boolean bl) {
        this.options.setStartFromName(bl);
    }

    @Override
    @NotNull
    public RenderingFormat getTextFormat() {
        return this.options.getTextFormat();
    }

    @Override
    public void setTextFormat(@NotNull RenderingFormat renderingFormat) {
        Intrinsics.checkParameterIsNotNull((Object)renderingFormat, "<set-?>");
        this.options.setTextFormat(renderingFormat);
    }

    @Override
    @NotNull
    public Function1<KotlinType, KotlinType> getTypeNormalizer() {
        return this.options.getTypeNormalizer();
    }

    @Override
    public void setTypeNormalizer(@NotNull Function1<? super KotlinType, ? extends KotlinType> function1) {
        Intrinsics.checkParameterIsNotNull(function1, "<set-?>");
        this.options.setTypeNormalizer(function1);
    }

    @Override
    public boolean getUninferredTypeParameterAsName() {
        return this.options.getUninferredTypeParameterAsName();
    }

    @Override
    public void setUninferredTypeParameterAsName(boolean bl) {
        this.options.setUninferredTypeParameterAsName(bl);
    }

    @Override
    public boolean getUnitReturnType() {
        return this.options.getUnitReturnType();
    }

    @Override
    public void setUnitReturnType(boolean bl) {
        this.options.setUnitReturnType(bl);
    }

    @Override
    @NotNull
    public DescriptorRenderer.ValueParametersHandler getValueParametersHandler() {
        return this.options.getValueParametersHandler();
    }

    @Override
    public void setValueParametersHandler(@NotNull DescriptorRenderer.ValueParametersHandler valueParametersHandler2) {
        Intrinsics.checkParameterIsNotNull(valueParametersHandler2, "<set-?>");
        this.options.setValueParametersHandler(valueParametersHandler2);
    }

    @Override
    public boolean getVerbose() {
        return this.options.getVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        this.options.setVerbose(bl);
    }

    @Override
    public boolean getWithDefinedIn() {
        return this.options.getWithDefinedIn();
    }

    @Override
    public void setWithDefinedIn(boolean bl) {
        this.options.setWithDefinedIn(bl);
    }

    @Override
    public boolean getWithoutReturnType() {
        return this.options.getWithoutReturnType();
    }

    @Override
    public void setWithoutReturnType(boolean bl) {
        this.options.setWithoutReturnType(bl);
    }

    @Override
    public boolean getWithoutSuperTypes() {
        return this.options.getWithoutSuperTypes();
    }

    @Override
    public void setWithoutSuperTypes(boolean bl) {
        this.options.setWithoutSuperTypes(bl);
    }

    @Override
    public boolean getWithoutTypeParameters() {
        return this.options.getWithoutTypeParameters();
    }

    @Override
    public void setWithoutTypeParameters(boolean bl) {
        this.options.setWithoutTypeParameters(bl);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"k\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005!\u0011I\u0001\u0007\u00013\u001dI!!C\u0001\u0019\u0003%\u0011\u0011\"\u0001M\u00021\u0003\t+!U\u0002\u0002\u0011\t)C\u0002B\u0006\t\u00065\t\u0001$A\r\u0004\u0011\ri\u0011\u0001g\u0002\u001a\u0007!!Q\"\u0001M\u0002K1!1\u0002#\u0003\u000e\u0003a\t\u0011d\u0001\u0005\u0006\u001b\u0005AZ!G\u0002\t\t5\t\u00014A\u0013\r\t-Aa!D\u0001\u0019\u0003e\u0019\u0001bA\u0007\u00021\u001bI2\u0001\u0003\u0003\u000e\u0003a\rQ\u0005\u0004\u0003\f\u0011\u001di\u0011\u0001G\u0001\u001a\u0007!\u0019Q\"\u0001M\b3\rAA!D\u0001\u0019\u0004\u0015bAa\u0003\u0005\t\u001b\u0005A\u0012!G\u0002\t\u00075\t\u0001\u0014C\r\u0004\u0011\u0011i\u0011\u0001g\u0001&\u0019\u0011Y\u0001\"C\u0007\u00021\u0005I2\u0001C\u0002\u000e\u0003aM\u0011d\u0001\u0005\u0005\u001b\u0005A\u001a!\n\u0007\u0005\u0017!QQ\"\u0001\r\u00023\rA1!D\u0001\u0019\u0016e\u0019\u0001\u0002B\u0007\u00021\u0007)C\u0002B\u0006\t\u00175\t\u0001$A\r\u0004\u0011\ri\u0011\u0001g\u0006\u001a\u0007!!Q\"\u0001M\u0002K1!1\u0002\u0003\u0007\u000e\u0003a\t\u0011d\u0001\u0005\u0004\u001b\u0005AJ\"G\u0002\t\t5\t\u00014A\u0013\r\t-AQ\"D\u0001\u0019\u0003e\u0019\u0001bA\u0007\u000217I2\u0001\u0003\b\u000e\u0003a\rQ\u0005\u0004\u0003\f\u0011;i\u0011\u0001G\u0001\u001a\u0007!yQ\"\u0001M\u00103\rAA!D\u0001\u0019\u0004\u0015bAa\u0003\u0005\u0011\u001b\u0005A\u0012!G\u0002\t\u00075\t\u0001\u0014E\r\u0004\u0011\u0011i\u0011\u0001g\u0001&\u0019\u0011Y\u0001\"E\u0007\u00021\u0005I2\u0001C\u0002\u000e\u0003a\r\u0012d\u0001\u0005\u0005\u001b\u0005A\u001a!\n\u0007\u0005\u0017!\u0011R\"\u0001\r\u00023\rA1!D\u0001\u0019&e\u0019\u0001\u0002B\u0007\u00021\u0007\u0001"}, strings={"Lorg/jetbrains/kotlin/renderer/DescriptorRendererImpl$RenderDeclarationDescriptorVisitor;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorVisitor;", "", "Ljava/lang/StringBuilder;", "(Lorg/jetbrains/kotlin/renderer/DescriptorRendererImpl;)V", "visitClassDescriptor", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "builder", "visitConstructorDescriptor", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "visitFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "visitModuleDeclaration", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "visitPackageFragmentDescriptor", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "visitPackageViewDescriptor", "Lorg/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "visitPropertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "visitPropertyGetterDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "visitPropertySetterDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "visitReceiverParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "data", "visitScriptDescriptor", "scriptDescriptor", "Lorg/jetbrains/kotlin/descriptors/ScriptDescriptor;", "visitTypeParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "visitValueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "visitVariableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;"}, moduleName="kotlin-compiler")
    private final class RenderDeclarationDescriptorVisitor
    implements DeclarationDescriptorVisitor<Unit, StringBuilder> {
        @Override
        public void visitValueParameterDescriptor(@NotNull ValueParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderValueParameter(descriptor2, true, builder, true);
        }

        @Override
        public void visitVariableDescriptor(@NotNull VariableDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderVariable(descriptor2, true, builder, true);
        }

        @Override
        public void visitPropertyDescriptor(@NotNull PropertyDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderProperty(descriptor2, builder);
        }

        @Override
        public void visitPropertyGetterDescriptor(@NotNull PropertyGetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                builder.append("getter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.getCorrespondingProperty()");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitPropertySetterDescriptor(@NotNull PropertySetterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            if (DescriptorRendererImpl.this.getRenderAccessors()) {
                DescriptorRendererImpl.this.renderAccessorModifiers(descriptor2, builder);
                builder.append("setter for ");
                PropertyDescriptor propertyDescriptor = descriptor2.getCorrespondingProperty();
                Intrinsics.checkExpressionValueIsNotNull(propertyDescriptor, "descriptor.getCorrespondingProperty()");
                DescriptorRendererImpl.this.renderProperty(propertyDescriptor, builder);
            } else {
                this.visitFunctionDescriptor((FunctionDescriptor)descriptor2, builder);
            }
        }

        @Override
        public void visitFunctionDescriptor(@NotNull FunctionDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderFunction(descriptor2, builder);
        }

        @Override
        public void visitReceiverParameterDescriptor(@NotNull ReceiverParameterDescriptor descriptor2, @NotNull StringBuilder data) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(data, "data");
            throw (Throwable)new UnsupportedOperationException("Don't render receiver parameters");
        }

        @Override
        public void visitConstructorDescriptor(@NotNull ConstructorDescriptor constructorDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(constructorDescriptor, "constructorDescriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderConstructor(constructorDescriptor, builder);
        }

        @Override
        public void visitTypeParameterDescriptor(@NotNull TypeParameterDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderTypeParameter(descriptor2, builder, true);
        }

        @Override
        public void visitPackageFragmentDescriptor(@NotNull PackageFragmentDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderPackageFragment(descriptor2, builder);
        }

        @Override
        public void visitPackageViewDescriptor(@NotNull PackageViewDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderPackageView(descriptor2, builder);
        }

        @Override
        public void visitModuleDeclaration(@NotNull ModuleDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderName(descriptor2, builder);
        }

        @Override
        public void visitScriptDescriptor(@NotNull ScriptDescriptor scriptDescriptor, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(scriptDescriptor, "scriptDescriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            this.visitClassDescriptor((ClassDescriptor)scriptDescriptor, builder);
        }

        @Override
        public void visitClassDescriptor(@NotNull ClassDescriptor descriptor2, @NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
            Intrinsics.checkParameterIsNotNull(builder, "builder");
            DescriptorRendererImpl.this.renderClass(descriptor2, builder);
        }
    }
}

