/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker$WhenMappings;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0005G\u0006a\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQe\u0004E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u0006KE!\u0011\u0001c\u0003\u000e\u0003a\u0011Q#\u0001\r\u00063\u0013A)!D\u0001\u0019\u0007A\u001b\t!'\u0003\t\b5\t\u0001\u0004\u0002)\u0004\u0003\u0015\nB!\u0001\u0005\u0007\u001b\u0005A\"!F\u0001\u0019\u000be%\u0001RA\u0007\u00021\r\u00016\u0011AM\u0005\u0011\u001bi\u0011\u0001G\u0004Q\u0007\u0005)\u0013\u0003B\u0001\t\u00105\t\u0001\u0004C\u000b\u00021\u0015IJ\u0001#\u0002\u000e\u0003a\u0019\u0001k!\u0001\u001a\n!5Q\"\u0001\r\b!\u000e\tQu\u0003\u0003\u0002\u0011#i\u0011\u0001\u0007\u0002\u0016\u0003a)\u0011\u0014\u0002E\u0004\u001b\u0005A\u0012\u0002UB\u0001"}, strings={"Lorg/jetbrains/kotlin/resolve/AnnotationUseSiteTargetChecker;", "", "()V", "check", "", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkDeclaration", "checkIfMutableProperty", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIfProperty", "", "checkReceiverAnnotations", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;"}, moduleName="kotlin-compiler")
public final class AnnotationUseSiteTargetChecker {
    public static final AnnotationUseSiteTargetChecker INSTANCE;
    public static final AnnotationUseSiteTargetChecker INSTANCE$;

    public final void check(@NotNull KtAnnotated annotated, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(annotated, "annotated");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.checkDeclaration(trace, annotated, descriptor2);
        if (annotated instanceof KtFunction) {
            for (KtParameter parameter : ((KtFunction)annotated).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                if ((VariableDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter) == null) {
                    continue;
                }
                KtAnnotated ktAnnotated = parameter;
                Intrinsics.checkExpressionValueIsNotNull(ktAnnotated, "parameter");
                DeclarationDescriptor declarationDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "parameterDescriptor");
                this.checkDeclaration(trace, ktAnnotated, declarationDescriptor);
            }
        }
        if (descriptor2 instanceof CallableDescriptor) {
            this.checkReceiverAnnotations(trace, (CallableDescriptor)descriptor2);
        }
    }

    private final void checkReceiverAnnotations(BindingTrace $receiver, CallableDescriptor descriptor2) {
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return;
        }
        ReceiverParameterDescriptor extensionReceiver2 = receiverParameterDescriptor;
        block6: for (AnnotationWithTarget annotationWithTarget : extensionReceiver2.getType().getAnnotations().getUseSiteTargetedAnnotations()) {
            AnnotationUseSiteTarget target;
            if (annotationWithTarget.getTarget() == null) {
                continue;
            }
            Function0<KtAnnotationEntry> annotationEntry$ = new Function0<KtAnnotationEntry>(annotationWithTarget){
                final /* synthetic */ AnnotationWithTarget $annotationWithTarget;

                @Nullable
                public final KtAnnotationEntry invoke() {
                    return DescriptorToSourceUtils.getSourceFromAnnotation(this.$annotationWithTarget.getAnnotation());
                }
                {
                    this.$annotationWithTarget = annotationWithTarget;
                    super(0);
                }
            };
            switch (AnnotationUseSiteTargetChecker$WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    Unit unit;
                    KtAnnotationEntry it;
                    Object $receiver$iv;
                    if (annotationEntry$.invoke() != null) {
                        it = (KtAnnotationEntry)$receiver$iv;
                        $receiver.report(Errors.INAPPLICABLE_TARGET_ON_PROPERTY.on(it, target.getRenderName()));
                        unit = Unit.INSTANCE;
                        continue block6;
                    }
                    unit = null;
                    break;
                }
                case 7: {
                    Unit unit;
                    KtAnnotationEntry it;
                    Object $receiver$iv;
                    if (annotationEntry$.invoke() != null) {
                        it = (KtAnnotationEntry)$receiver$iv;
                        $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on(it));
                        unit = Unit.INSTANCE;
                        continue block6;
                    }
                    unit = null;
                    break;
                }
                case 8: {
                    throw (Throwable)new IllegalArgumentException("@file annotations are not allowed here");
                }
            }
        }
    }

    private final void checkDeclaration(BindingTrace $receiver, KtAnnotated annotated, DeclarationDescriptor descriptor2) {
        block10: for (KtAnnotationEntry annotation2 : annotated.getAnnotationEntries()) {
            Object object = annotation2.getUseSiteTarget();
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null) {
                continue;
            }
            Object target = object;
            switch (AnnotationUseSiteTargetChecker$WhenMappings.$EnumSwitchMapping$1[((Enum)target).ordinal()]) {
                case 1: {
                    KtAnnotationEntry ktAnnotationEntry = annotation2;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "annotation");
                    this.checkIfProperty($receiver, annotated, ktAnnotationEntry);
                    break;
                }
                case 2: {
                    KtAnnotationEntry ktAnnotationEntry = annotation2;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "annotation");
                    this.checkIfProperty($receiver, annotated, ktAnnotationEntry);
                    break;
                }
                case 3: {
                    KtAnnotationEntry ktAnnotationEntry = annotation2;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "annotation");
                    this.checkIfProperty($receiver, annotated, ktAnnotationEntry);
                    break;
                }
                case 4: {
                    KtAnnotationEntry ktAnnotationEntry = annotation2;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "annotation");
                    this.checkIfMutableProperty($receiver, annotated, ktAnnotationEntry);
                    break;
                }
                case 5: {
                    DeclarationDescriptor containingDeclaration;
                    if (!(annotated instanceof KtParameter)) {
                        $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation2));
                        break;
                    }
                    VariableDescriptor variableDescriptor = (VariableDescriptor)$receiver.getBindingContext().get(BindingContext.VALUE_PARAMETER, annotated);
                    DeclarationDescriptor declarationDescriptor = containingDeclaration = variableDescriptor != null ? variableDescriptor.getContainingDeclaration() : null;
                    if (!(containingDeclaration instanceof ConstructorDescriptor) || !((ConstructorDescriptor)containingDeclaration).isPrimary()) {
                        $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation2));
                        break;
                    }
                    if (((KtParameter)annotated).hasValOrVar()) continue block10;
                    $receiver.report(Errors.REDUNDANT_ANNOTATION_TARGET.on(annotation2, ((AnnotationUseSiteTarget)((Object)target)).getRenderName()));
                    break;
                }
                case 6: {
                    KtAnnotationEntry ktAnnotationEntry = annotation2;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "annotation");
                    this.checkIfMutableProperty($receiver, annotated, ktAnnotationEntry);
                    break;
                }
                case 7: {
                    throw (Throwable)new IllegalArgumentException("@file annotations are not allowed here");
                }
                case 8: {
                    $receiver.report(Errors.INAPPLICABLE_RECEIVER_TARGET.on(annotation2));
                }
            }
        }
    }

    private final void checkIfMutableProperty(BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isMutable;
        if (!this.checkIfProperty($receiver, annotated, annotation2)) {
            return;
        }
        boolean bl = annotated instanceof KtProperty ? ((KtProperty)annotated).isVar() : (isMutable = annotated instanceof KtParameter ? ((KtParameter)annotated).isMutable() : false);
        if (!isMutable) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_IMMUTABLE.on(annotation2));
        }
    }

    private final boolean checkIfProperty(BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        Object target;
        boolean isProperty;
        boolean bl = annotated instanceof KtProperty ? !((KtProperty)annotated).isLocal() : (isProperty = annotated instanceof KtParameter ? ((KtParameter)annotated).hasValOrVar() : false);
        Object object = annotation2.getUseSiteTarget();
        if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null || (object = ((AnnotationUseSiteTarget)((Object)object)).getRenderName()) == null) {
            object = target = "unknown target";
        }
        if (!isProperty) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_ON_PROPERTY.on(annotation2, (String)target));
        }
        return isProperty;
    }

    private AnnotationUseSiteTargetChecker() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new AnnotationUseSiteTargetChecker();
    }
}

