/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.storage;

import com.intellij.openapi.util.ModificationTracker;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"3\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001#\u0003\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0019!\u0002\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011\u001d!1\u0002\u0004\u0001\u001a\u0003a\u0005\u0011$\u0001\r\u0002C\u000b\t6!\u0001E\u0002K\u0011!1\u0002C\u0002\u000e\u0003a\u001dQ\u0005\u0003\u0003\f\u0011\u0011i\u0011\u0001'\u0003\u001a\u0007!)Q\"\u0001M\u0006K\u0011!\u0011\u0001\u0003\u0004\u000e\u0003a5Q\u0005\u0002\u0003\f\u0011\u001di\u0011\u0001g\u0004*\u000f\u0011\t\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/storage/ExceptionTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "Lorg/jetbrains/kotlin/storage/LockBasedStorageManager$ExceptionHandlingStrategy;", "()V", "cancelledTracker", "Ljava/util/concurrent/atomic/AtomicLong;", "getModificationCount", "", "handleException", "Ljava/lang/RuntimeException;", "throwable", "", "incCounter", "", "toString", ""}, moduleName="kotlin-compiler")
public class ExceptionTracker
implements ModificationTracker,
LockBasedStorageManager.ExceptionHandlingStrategy {
    private final AtomicLong cancelledTracker = new AtomicLong();

    @Override
    @NotNull
    public RuntimeException handleException(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull(throwable, "throwable");
        this.incCounter();
        throw (Throwable)ExceptionUtilsKt.rethrow(throwable);
    }

    private final void incCounter() {
        this.cancelledTracker.getAndIncrement();
    }

    @Override
    public long getModificationCount() {
        return this.cancelledTracker.get();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.getModificationCount();
    }
}

