/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.Objects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBinaryContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.util.HgUtil;

public class HgContentRevision
implements ContentRevision {
    private final Project myProject;
    @NotNull
    private final HgFile myHgFile;
    @NotNull
    private final HgRevisionNumber myRevisionNumber;
    private FilePath filePath;

    protected HgContentRevision(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber revisionNumber) {
        if (hgFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFile", "org/zmlx/hg4idea/HgContentRevision", "<init>"));
        }
        if (revisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionNumber", "org/zmlx/hg4idea/HgContentRevision", "<init>"));
        }
        this.myProject = project;
        this.myHgFile = hgFile;
        this.myRevisionNumber = revisionNumber;
    }

    @NotNull
    public static HgContentRevision create(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber revisionNumber) {
        if (hgFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFile", "org/zmlx/hg4idea/HgContentRevision", "create"));
        }
        if (revisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionNumber", "org/zmlx/hg4idea/HgContentRevision", "create"));
        }
        HgContentRevision hgContentRevision = !hgFile.toFilePath().getFileType().isBinary() ? new HgContentRevision(project, hgFile, revisionNumber) : new HgBinaryContentRevision(project, hgFile, revisionNumber);
        if (hgContentRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgContentRevision", "create"));
        }
        return hgContentRevision;
    }

    @Nullable
    public String getContent() throws VcsException {
        if (this.myRevisionNumber.isWorkingVersion()) {
            return VcsUtil.getFileContent((String)this.myHgFile.getFile().getPath());
        }
        HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myHgFile);
        return CharsetToolkit.bytesToString((byte[])HgUtil.loadContent(this.myProject, this.myRevisionNumber, fileToCat), (Charset)this.getFile().getCharset());
    }

    public byte[] getContentAsBytes() {
        if (this.myRevisionNumber.isWorkingVersion()) {
            return VcsUtil.getFileByteContent((File)this.myHgFile.getFile());
        }
        HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myHgFile);
        return HgUtil.loadContent(this.myProject, this.myRevisionNumber, fileToCat);
    }

    @NotNull
    public FilePath getFile() {
        if (this.filePath == null) {
            this.filePath = this.myHgFile.toFilePath();
        }
        FilePath filePath = this.filePath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public HgRevisionNumber getRevisionNumber() {
        HgRevisionNumber hgRevisionNumber = this.myRevisionNumber;
        if (hgRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgContentRevision", "getRevisionNumber"));
        }
        return hgRevisionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgContentRevision revision = (HgContentRevision)o;
        if (!this.myHgFile.equals(revision.myHgFile)) {
            return false;
        }
        return this.myRevisionNumber.equals(revision.myRevisionNumber);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myHgFile, this.myRevisionNumber});
    }
}

