/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Arrays;
import java.util.Collections;
import org.zmlx.hg4idea.command.HgAddCommand;
import org.zmlx.hg4idea.execution.HgCommandExecutor;

public class HgCopyCommand {
    private final Project myProject;

    public HgCopyCommand(Project project) {
        this.myProject = project;
    }

    public void execute(VirtualFile source, VirtualFile target) {
        VirtualFile sourceRepo = VcsUtil.getVcsRootFor((Project)this.myProject, (VirtualFile)source);
        VirtualFile targetRepo = VcsUtil.getVcsRootFor((Project)this.myProject, (VirtualFile)target);
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject, VcsFileUtil.relativeOrFullPath((VirtualFile)sourceRepo, (VirtualFile)source));
        if (sourceRepo != null && targetRepo != null && sourceRepo.equals(targetRepo)) {
            executor.execute(sourceRepo, "copy", Arrays.asList("--after", VcsFileUtil.relativeOrFullPath((VirtualFile)sourceRepo, (VirtualFile)source), VcsFileUtil.relativeOrFullPath((VirtualFile)targetRepo, (VirtualFile)target)), null);
        } else if (targetRepo != null) {
            new HgAddCommand(this.myProject).execute(Collections.singleton(target));
        }
    }
}

