/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005AA!\u0002\u0001\u0006\u0003!-Q!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\r\u0001e\t\u0001\u0014AQ\u0011\u0013\rA\u0011!D\u0001\u0019\u0004%\u0019\u0001BA\u0007\u00021\u000bIQ\u0001C\u0002\u000e\u0007a\u001d\u0011&\u0001\r\u0005#\u000e\t\u0001\u0012B\u0013\u0005\t-Aa!D\u0001\u0019\u000e\u0015RAA\u0003\u0005\b\u001b\u0005AZ!G\u0003\t\u00105\u0019\u0001tA\u0015\u00021\u0011)c\u0002\u0002\u0006\t\u00115\t\u0001\u0014C\r\u0006\u0011\u001fi1\u0001g\u0002*\u0003a!\u0011d\u0001\u0005\n\u001b\u0005A\u001a!\n\u0003\u0005\u0015!MQ\"\u0001\r\u000bK\u0011!1\u0002#\u0006\u000e\u0003aYQE\u0003\u0003\f\u0011/i\u0011\u0001'\u0004\u001a\u000b!=Qb\u0001M\u0004S\u0005AB!K\u0004\u0005\u0003\"A!!D\u0001\u0019\u0006E\u001b\u0011!\u0002\u0001*\u000f\u0011\tE\u0004C\u0003\u000e\u0003a-\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/impl/CodeBlockMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "startPosition", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;Lorg/intellij/markdown/parser/LookaheadText$Position;)V", "realInterestingOffset", "", "allowsSubBlocks", "", "calcNextInterestingOffset", "pos", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset"}, moduleName="intellij-markdown")
public final class CodeBlockMarkerBlock
extends MarkerBlockImpl {
    private int realInterestingOffset;
    private final ProductionHolder productionHolder;

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        LookaheadText.Position position;
        MarkdownConstraints nextConstraints;
        block9: {
            block8: {
                Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
                Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
                if (pos.getOffset() < this.realInterestingOffset) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                if (pos.getOffsetInCurrentLine() != -1) {
                    return MarkerBlock.ProcessingResult.Companion.getCANCEL();
                }
                PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
                LookaheadText.Position position2 = MarkdownParserUtil.INSTANCE.findNonEmptyLineWithSameConstraints(this.getConstraints(), pos);
                if (position2 == null) {
                    return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
                }
                LookaheadText.Position nonemptyPos = position2;
                nextConstraints = MarkdownConstraints.Companion.fromBase(nonemptyPos, this.getConstraints());
                LookaheadText.Position shifted = nonemptyPos.nextPosition(1 + nextConstraints.getCharsEaten(nonemptyPos.getCurrentLine()));
                position = shifted;
                if (position == null) break block8;
                Integer n = shifted.charsToNonWhitespace();
                if ((position = position.nextPosition(n != null ? ((Number)n).intValue() : 0)) != null) break block9;
            }
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonWhitespace = position;
        if (!MarkdownParserUtil.INSTANCE.hasCodeBlockIndent(nonWhitespace, nextConstraints)) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(pos, this.getConstraints());
        IntRange nodeRange = new IntRange(pos.getOffset() + 1 + nextLineConstraints.getCharsEaten(pos.getCurrentLine()), pos.getNextLineOrEofOffset());
        if (((Number)nodeRange.getEndInclusive()).intValue() - ((Number)nodeRange.getStart()).intValue() > 0) {
            this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(nodeRange, MarkdownTokenTypes.Companion.getCODE_LINE())));
        }
        this.realInterestingOffset = pos.getNextLineOrEofOffset();
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.Companion.getCODE_BLOCK();
    }

    public CodeBlockMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder productionHolder, @NotNull LookaheadText.Position startPosition) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)startPosition, (String)"startPosition");
        super(myConstraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.productionHolder.addProduction(CollectionsKt.listOf((Object)new SequentialParser.Node(new IntRange(startPosition.getOffset(), startPosition.getNextLineOrEofOffset()), MarkdownTokenTypes.Companion.getCODE_LINE())));
        this.realInterestingOffset = -1;
    }
}

