/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.PreconditionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\t\f\u0015\tAQA\u0003\u0002\u0011\u0011)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001\u0001\u0007\u00013\u0005A\n!i\u000e\n\u0007!\tQ\"\u0001M\u0002\u0013\u0015A!!D\u0002\u0019\u0006%\n\u0001dA\u0005\u000f\u0011\u000fiA\"\u0003\u0003\n\u0007a%\u0011&\u0001\r\u0006\u0013\tI\u0011\u0001g\u0001\n\u0005%\t\u00014\u0002\r\u0005#\u000e\t\u0001BB\u0013\u0005\t-Ay!D\u0001\u0019\f\u0015RAA\u0003\u0005\t\u001b\u0005A\n\"G\u0003\t\u00135\u0019\u0001\u0014B\u0015\u00021\u0015)c\u0002\u0002\u0006\t\u00145\t\u0001DC\r\u0006\u0011%i1\u0001'\u0003*\u0003a)\u0011d\u0001E\u000b\u001b\u0005A\u001a!\n\u0003\u0005\u0015!YQ\"\u0001M\fK\u0011!1\u0002\u0003\u0007\u000e\u0003aeQE\u0003\u0003\f\u00115i\u0011\u0001g\u0003\u001a\u000b!IQb\u0001M\u0005S\u0005AR!K\u000b\u0005\u0007\"A9!\u0004\u0007\n\t%\u0019\u0001\u0014B\u0015\u00021\u0015I!!C\u0001\u0019\u0004%\u0011\u0011\"\u0001M\u00061\u0011\t6\u0001B\u0003\u0001\u001b\t!i\u0001C\u0004"}, strings={"Lorg/intellij/markdown/parser/markerblocks/impl/ParagraphMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "marker", "Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "Lorg/intellij/markdown/parser/ProductionHolder;", "interruptsParagraph", "Lkotlin/Function2;", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder$Marker;Lkotlin/jvm/functions/Function2;)V", "getInterruptsParagraph", "()Lkotlin/jvm/functions/Function2;", "allowsSubBlocks", "calcNextInterestingOffset", "", "pos", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset"}, moduleName="intellij-markdown")
public final class ParagraphMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    private final Function2<LookaheadText.Position, MarkdownConstraints, Boolean> interruptsParagraph;

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return true;
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        if (pos.getOffsetInCurrentLine() != -1) {
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        PreconditionsKt.assert((pos.getChar() == '\n' ? 1 : 0) != 0);
        if (MarkdownParserUtil.INSTANCE.calcNumberOfConsequentEols(pos, this.getConstraints()) >= 2) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(pos, this.getConstraints());
        if (!nextLineConstraints.upstreamWith(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position posToCheck = pos.nextPosition(1 + nextLineConstraints.getCharsEaten(pos.getCurrentLine()));
        if (posToCheck == null || ((Boolean)this.interruptsParagraph.invoke((Object)posToCheck, (Object)nextLineConstraints)).booleanValue()) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return MarkdownElementTypes.Companion.getPARAGRAPH();
    }

    @NotNull
    public final Function2<LookaheadText.Position, MarkdownConstraints, Boolean> getInterruptsParagraph() {
        return this.interruptsParagraph;
    }

    public ParagraphMarkerBlock(@NotNull MarkdownConstraints constraints, @NotNull ProductionHolder.Marker marker, @NotNull Function2<? super LookaheadText.Position, ? super MarkdownConstraints, Boolean> interruptsParagraph2) {
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        Intrinsics.checkParameterIsNotNull(interruptsParagraph2, (String)"interruptsParagraph");
        super(constraints, marker);
        this.interruptsParagraph = interruptsParagraph2;
    }
}

