/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.IntRange;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\r\u0001A\r\u0011$\u0001M\u0001;\u0003\r\u0011UA)\u0004\u0003!\t\u0001"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserUtil;", "", "()V", "Companion"}, moduleName="intellij-markdown")
public final class SequentialParserUtil {
    private static final int PUNCTUATION_MASK = 1643118592;
    public static final Companion Companion = org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil$Companion.INSTANCE;

    static {
        PUNCTUATION_MASK = 1 << 20 | 1 << 21 | 1 << 22 | 1 << 23 | 1 << 24 | 1 << 29 | 1 << 30;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!!Q!\u0001C\u0002\u000b\u0005Aq\"B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t!\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Aaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K9A9!\u0004\u0003\n\u0005%\t\u0001\u0014\u0002\r\u00053\rAQ!D\u0001\u0019\fe\u0019\u0001BB\u0007\u00021\u0013)S\u0002#\u0004\u000e\t%\u0011\u0011\"\u0001M\u00051\u0011Ib\u0001C\u0004\u000e\t%\u0011\u0011\"\u0001\r\u00031\u001f)S\u0002\u0003\u0005\u000e\u0003aE\u0011$\u0002\u0005\n\u001b\rA\u001a\"K\u0001\u0019\fe\u0019\u0001BC\u0007\u00021\t)S\u0002#\u0006\u000e\u0003aE\u0011$\u0002\u0005\n\u001b\rA\u001a\"K\u0001\u0019\fe\u0019\u0001BC\u0007\u00021\t)S\u0002C\u0006\u000e\t%\u0011\u0011\"\u0001\r\u00031\u001fIb\u0001c\u0006\u000e\t%\u0011\u0011\"\u0001M\u00051\u0011I;\u0002B!I\u0003!\rQ\"\u0001\r\u0003#\u000e)Q!\u0001G\u0001\u001b\t!)\u0001C\u0002"}, strings={"Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserUtil$Companion;", "", "()V", "PUNCTUATION_MASK", "", "getPUNCTUATION_MASK", "()I", "filterBlockquotes", "", "Lkotlin/IntRange;", "tokensCache", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "textRange", "indicesToTextRanges", "indices", "", "isPunctuation", "", "info", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "lookup", "isWhitespace", "textRangesToIndices", "ranges"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final int getPUNCTUATION_MASK() {
            return PUNCTUATION_MASK;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Integer> textRangesToIndices(@NotNull Collection<IntRange> ranges) {
            Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
            ArrayList<Integer> result = new ArrayList<Integer>();
            block0: for (IntRange range : ranges) {
                int n;
                int n2 = ((Number)range.getStart()).intValue();
                if (n2 > (n = ((Number)range.getEndInclusive()).intValue() - 1)) continue;
                while (true) {
                    void i;
                    result.add((int)i);
                    if (i == n) continue block0;
                    ++i;
                }
            }
            return CollectionsKt.sorted((Iterable)result);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<IntRange> indicesToTextRanges(@NotNull List<Integer> indices) {
            Intrinsics.checkParameterIsNotNull(indices, (String)"indices");
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            int starting = 0;
            IntRange intRange = CollectionsKt.getIndices((Collection)indices);
            int n = intRange.getFirst();
            int n2 = intRange.getLast();
            if (n <= n2) {
                while (true) {
                    void i;
                    if (i + true == indices.size() || ((Number)indices.get((int)i)).intValue() + 1 != ((Number)indices.get((int)(i + true))).intValue()) {
                        result.add(new IntRange(((Number)indices.get(starting)).intValue(), ((Number)indices.get((int)i)).intValue() + 1));
                        starting = i + true;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            return result;
        }

        public final boolean isWhitespace(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            char c = info.charLookup(lookup);
            return c == (char)0 || Character.isSpaceChar(c) || Character.isWhitespace(c);
        }

        public final boolean isPunctuation(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
            char c = info.charLookup(lookup);
            return (this.getPUNCTUATION_MASK() >> Character.getType(c) & 1) != 0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<IntRange> filterBlockquotes(@NotNull TokensCache tokensCache, @NotNull IntRange textRange) {
            Intrinsics.checkParameterIsNotNull((Object)tokensCache, (String)"tokensCache");
            Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
            ArrayList<IntRange> result = new ArrayList<IntRange>();
            int lastStart = ((Number)textRange.getStart()).intValue();
            int R = ((Number)textRange.getEndInclusive()).intValue();
            int n = lastStart;
            int n2 = R - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    if (Intrinsics.areEqual((Object)tokensCache.new TokensCache.Iterator((int)i).getType(), (Object)MarkdownTokenTypes.Companion.getBLOCK_QUOTE())) {
                        if (lastStart < i) {
                            result.add(new IntRange(lastStart, (int)i));
                        }
                        lastStart = i + true;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if (lastStart < R) {
                result.add(new IntRange(lastStart, R));
            }
            return result;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

