/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin.header;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.AbiVersionUtil;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.BinaryVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KotlinClassHeader {
    @NotNull
    private final Kind kind;
    @NotNull
    private final BinaryVersion version;
    @Nullable
    private final String[] annotationData;
    @Nullable
    private final String[] strings;
    @Nullable
    private final String syntheticClassKind;
    @Nullable
    private final String[] filePartClassNames;
    @Nullable
    private final String multifileClassName;
    private final boolean isInterfaceDefaultImpls;
    private final boolean isLocalClass;

    public final boolean isCompatibleAbiVersion() {
        return AbiVersionUtil.isAbiVersionCompatible(this.version);
    }

    @NotNull
    public String toString() {
        return (Object)((Object)this.kind) + " " + (this.isLocalClass ? "(local) " : "") + (this.syntheticClassKind != null ? this.syntheticClassKind + " " : "") + ("version=" + this.version);
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public final BinaryVersion getVersion() {
        return this.version;
    }

    @Nullable
    public final String[] getAnnotationData() {
        return this.annotationData;
    }

    @Nullable
    public final String[] getStrings() {
        return this.strings;
    }

    @Nullable
    public final String getSyntheticClassKind() {
        return this.syntheticClassKind;
    }

    @Nullable
    public final String[] getFilePartClassNames() {
        return this.filePartClassNames;
    }

    @Nullable
    public final String getMultifileClassName() {
        return this.multifileClassName;
    }

    public final boolean isInterfaceDefaultImpls() {
        return this.isInterfaceDefaultImpls;
    }

    public final boolean isLocalClass() {
        return this.isLocalClass;
    }

    public KotlinClassHeader(@NotNull Kind kind, @NotNull BinaryVersion version, @Nullable String[] annotationData, @Nullable String[] strings, @Nullable String syntheticClassKind, @Nullable String[] filePartClassNames, @Nullable String multifileClassName, boolean isInterfaceDefaultImpls, boolean isLocalClass) {
        Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
        Intrinsics.checkParameterIsNotNull(version, "version");
        this.kind = kind;
        this.version = version;
        this.annotationData = annotationData;
        this.strings = strings;
        this.syntheticClassKind = syntheticClassKind;
        this.filePartClassNames = filePartClassNames;
        this.multifileClassName = multifileClassName;
        this.isInterfaceDefaultImpls = isInterfaceDefaultImpls;
        this.isLocalClass = isLocalClass;
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind CLASS;
        public static final /* enum */ Kind FILE_FACADE;
        public static final /* enum */ Kind MULTIFILE_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS_PART;
        public static final /* enum */ Kind SYNTHETIC_CLASS;
        private static final /* synthetic */ Kind[] $VALUES;

        static {
            Kind[] kindArray = new Kind[5];
            Kind[] kindArray2 = kindArray;
            kindArray[0] = CLASS = new Kind();
            kindArray[1] = FILE_FACADE = new Kind();
            kindArray[2] = MULTIFILE_CLASS = new Kind();
            kindArray[3] = MULTIFILE_CLASS_PART = new Kind();
            kindArray[4] = SYNTHETIC_CLASS = new Kind();
            $VALUES = kindArray;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }
    }
}

