/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Iterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.OperatorChecks;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class OperatorChecks {
    public static final OperatorChecks INSTANCE;
    public static final OperatorChecks INSTANCE$;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canBeOperator(@NotNull FunctionDescriptor functionDescriptor) {
        boolean bl;
        FunctionDescriptor $receiver;
        Name name;
        block25: {
            ReceiverParameterDescriptor receiverParameterDescriptor;
            block24: {
                Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
                name = functionDescriptor.getName();
                $receiver = functionDescriptor;
                if (!INSTANCE.isMemberOrExtension(functionDescriptor)) {
                    return false;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getGET(), name)) {
                    if ($receiver.getValueParameters().size() < 1) return false;
                    return true;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getSET(), name)) {
                    boolean bl2;
                    ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.lastOrNull($receiver.getValueParameters());
                    if (valueParameterDescriptor != null) {
                        void $receiver$iv;
                        ValueParameterDescriptor valueParameterDescriptor2 = valueParameterDescriptor;
                        ValueParameterDescriptor it2 = (ValueParameterDescriptor)$receiver$iv;
                        bl2 = !DescriptorUtilsKt.hasDefaultValue(it2) && it2.getVarargElementType() == null;
                    } else {
                        bl2 = false;
                    }
                    boolean lastIsOk = bl2;
                    if ($receiver.getValueParameters().size() < 2) return false;
                    if (!lastIsOk) return false;
                    return true;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getGET_VALUE(), name)) {
                    if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                    if ($receiver.getValueParameters().size() < 2) return false;
                    if (!INSTANCE.isKProperty($receiver.getValueParameters().get(1))) return false;
                    return true;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getSET_VALUE(), name)) {
                    if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                    if ($receiver.getValueParameters().size() < 3) return false;
                    if (!INSTANCE.isKProperty($receiver.getValueParameters().get(1))) return false;
                    return true;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getINVOKE(), name)) {
                    bl = INSTANCE.isMemberOrExtension($receiver);
                    return bl;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getCONTAINS(), name)) {
                    if (!INSTANCE.getSingleValueParameter($receiver)) return false;
                    if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                    if (!INSTANCE.getReturnsBoolean($receiver)) return false;
                    return true;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getITERATOR(), name)) {
                    bl = INSTANCE.getNoValueParameters($receiver);
                    return bl;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getNEXT(), name)) {
                    bl = INSTANCE.getNoValueParameters($receiver);
                    return bl;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getHAS_NEXT(), name)) {
                    if (!INSTANCE.getNoValueParameters($receiver)) return false;
                    if (!INSTANCE.getReturnsBoolean($receiver)) return false;
                    return true;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getRANGE_TO(), name)) {
                    if (!INSTANCE.getSingleValueParameter($receiver)) return false;
                    if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                    return true;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getEQUALS(), name)) {
                    Object element$iv;
                    FunctionDescriptor it;
                    canBeOperator.1.1 isAny$ = canBeOperator.1.1.INSTANCE;
                    if (!INSTANCE.isMember($receiver)) return false;
                    Iterable $receiver$iv = $receiver.getOverriddenDescriptors();
                    Iterator it2 = $receiver$iv.iterator();
                    do {
                        if (!it2.hasNext()) return false;
                    } while (!canBeOperator.1.1.INSTANCE.invoke((it = (FunctionDescriptor)(element$iv = it2.next())).getContainingDeclaration()));
                    return true;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getCOMPARE_TO(), name)) {
                    if (!INSTANCE.getReturnsInt($receiver)) return false;
                    if (!INSTANCE.getSingleValueParameter($receiver)) return false;
                    if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                    return true;
                }
                if (OperatorNameConventions.INSTANCE.getBINARY_OPERATION_NAMES$kotlin_core().contains(name)) {
                    if (!INSTANCE.getSingleValueParameter($receiver)) return false;
                    if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
                    return true;
                }
                if (OperatorNameConventions.INSTANCE.getSIMPLE_UNARY_OPERATION_NAMES$kotlin_core().contains(name)) {
                    bl = INSTANCE.getNoValueParameters($receiver);
                    return bl;
                }
                if (Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getINC(), name)) break block24;
                if (!Intrinsics.areEqual(OperatorNameConventions.INSTANCE.getDEC(), name)) break block25;
            }
            if ((receiverParameterDescriptor = $receiver.getDispatchReceiverParameter()) == null) {
                receiverParameterDescriptor = $receiver.getExtensionReceiverParameter();
            }
            ReceiverParameterDescriptor receiver = receiverParameterDescriptor;
            if (!INSTANCE.isMemberOrExtension($receiver)) return false;
            if (receiver == null) return false;
            KotlinType kotlinType = $receiver.getReturnType();
            if (kotlinType == null) return false;
            KotlinType $receiver$iv = kotlinType;
            KotlinType it = $receiver$iv;
            KotlinType kotlinType2 = receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "receiver.type");
            boolean bl3 = TypeUtilsKt.isSubtypeOf(it, kotlinType2);
            if (!bl3) return false;
            return true;
        }
        if (OperatorNameConventions.INSTANCE.getASSIGNMENT_OPERATIONS$kotlin_core().contains(name)) {
            if (!INSTANCE.getReturnsUnit($receiver)) return false;
            if (!INSTANCE.getSingleValueParameter($receiver)) return false;
            if (!INSTANCE.getNoDefaultsAndVarargs($receiver)) return false;
            return true;
        }
        if (!StringsKt.matches((CharSequence)name.asString(), OperatorNameConventions.INSTANCE.getCOMPONENT_REGEX())) return false;
        bl = INSTANCE.getNoValueParameters($receiver);
        return bl;
    }

    private final boolean isKProperty(ValueParameterDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule($receiver));
        if (kotlinType != null) {
            KotlinType kotlinType2 = TypeUtilsKt.makeNotNullable($receiver.getType());
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "type.makeNotNullable()");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, kotlinType2);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isMember(FunctionDescriptor $receiver) {
        return $receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    private final boolean isMemberOrExtension(FunctionDescriptor $receiver) {
        return DescriptorUtilsKt.isExtension($receiver) || $receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    private final boolean getNoValueParameters(FunctionDescriptor $receiver) {
        return $receiver.getValueParameters().isEmpty();
    }

    private final boolean getSingleValueParameter(FunctionDescriptor $receiver) {
        return $receiver.getValueParameters().size() == 1;
    }

    private final boolean getReturnsBoolean(FunctionDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver$iv = kotlinType;
            KotlinType it = $receiver$iv;
            bl = KotlinBuiltIns.isBoolean(it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean getReturnsInt(FunctionDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver$iv = kotlinType;
            KotlinType it = $receiver$iv;
            bl = Intrinsics.areEqual(DescriptorUtilsKt.getBuiltIns($receiver).getIntType(), it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean getReturnsUnit(FunctionDescriptor $receiver) {
        boolean bl;
        KotlinType kotlinType = $receiver.getReturnType();
        if (kotlinType != null) {
            KotlinType $receiver$iv = kotlinType;
            KotlinType it = $receiver$iv;
            bl = Intrinsics.areEqual(DescriptorUtilsKt.getBuiltIns($receiver).getUnitType(), it);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean getNoDefaultsAndVarargs(FunctionDescriptor $receiver) {
        boolean bl;
        block1: {
            Iterable $receiver$iv = $receiver.getValueParameters();
            for (Object element$iv : $receiver$iv) {
                ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                if (!DescriptorUtilsKt.hasDefaultValue(it) && it.getVarargElementType() == null) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private OperatorChecks() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new OperatorChecks();
    }
}

