/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import org.gradle.internal.BiAction;
import org.gradle.internal.BiActions;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelCreatorFactory;
import org.gradle.model.internal.core.ModelCreators;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ModelStructSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedModelInitializer<T>
implements BiAction<MutableModelNode, Object> {
    private final ModelStructSchema<T> modelSchema;
    private final ModelRuleDescriptor descriptor;
    private final ModelSchemaStore schemaStore;
    private final ModelCreatorFactory modelCreatorFactory;

    public ManagedModelInitializer(ModelRuleDescriptor descriptor, ModelStructSchema<T> modelSchema, ModelSchemaStore schemaStore, ModelCreatorFactory modelCreatorFactory) {
        this.descriptor = descriptor;
        this.schemaStore = schemaStore;
        this.modelCreatorFactory = modelCreatorFactory;
        this.modelSchema = modelSchema;
    }

    public void execute(MutableModelNode modelNode, Object object) {
        for (ModelProperty property : this.modelSchema.getProperties().values()) {
            this.addPropertyLink(modelNode, property);
        }
    }

    private <P> void addPropertyLink(MutableModelNode modelNode, ModelProperty<P> property) {
        ModelType<P> propertyType = property.getType();
        ModelSchema<P> propertySchema = this.schemaStore.getSchema(propertyType);
        if (propertySchema.getKind().isManaged()) {
            if (!property.isWritable()) {
                ModelCreator creator = this.modelCreatorFactory.creator(this.descriptor, modelNode.getPath().child(property.getName()), propertySchema);
                modelNode.addLink(creator);
            } else {
                UnmanagedModelProjection<P> projection = new UnmanagedModelProjection<P>(propertyType, true, true);
                ModelCreator creator = ModelCreators.of(modelNode.getPath().child(property.getName()), BiActions.doNothing()).withProjection(projection).descriptor(this.descriptor).build();
                modelNode.addReference(creator);
            }
        } else {
            UnmanagedModelProjection<P> projection = new UnmanagedModelProjection<P>(propertyType, true, true);
            ModelCreator creator = ModelCreators.of(modelNode.getPath().child(property.getName()), BiActions.doNothing()).withProjection(projection).descriptor(this.descriptor).build();
            modelNode.addLink(creator);
        }
    }
}

