/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelProperty<T> {
    private final String name;
    private final ModelType<T> type;
    private final boolean writable;
    private final Set<ModelType<?>> declaredBy;
    private final boolean unmanaged;

    private ModelProperty(ModelType<T> type, String name, boolean writable, Set<ModelType<?>> declaredBy, boolean unmanaged) {
        this.name = name;
        this.type = type;
        this.writable = writable;
        this.declaredBy = ImmutableSet.copyOf(declaredBy);
        this.unmanaged = unmanaged;
    }

    public static <T> ModelProperty<T> of(ModelType<T> type, String name, boolean writable, Set<ModelType<?>> declaredBy, boolean unmanaged) {
        return new ModelProperty<T>(type, name, writable, declaredBy, unmanaged);
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnmanaged() {
        return this.unmanaged;
    }

    public ModelType<T> getType() {
        return this.type;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public Set<ModelType<?>> getDeclaredBy() {
        return this.declaredBy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelProperty that = (ModelProperty)o;
        return this.name.equals(that.name) && this.type.equals(that.type) && this.writable == that.writable;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + Boolean.valueOf(this.writable).hashCode();
        return result;
    }
}

