/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveStrategy
implements ModelSchemaExtractionStrategy {
    private static final Map<ModelType<?>, Class<?>> BOXED_REPLACEMENTS = ImmutableMap.builder().put(ModelType.of(Boolean.TYPE), Boolean.class).put(ModelType.of(Character.TYPE), Character.class).put(ModelType.of(Float.TYPE), Double.class).put(ModelType.of(Integer.TYPE), Integer.class).put(ModelType.of(Long.TYPE), Long.class).put(ModelType.of(Short.TYPE), Integer.class).put(ModelType.of(Double.TYPE), Double.class).build();

    @Override
    public <T> ModelSchemaExtractionResult<T> extract(ModelSchemaExtractionContext<T> extractionContext, ModelSchemaCache cache) {
        Class<?> replacementType;
        ModelType<T> type = extractionContext.getType();
        if (type.getRawClass().isPrimitive() && (replacementType = BOXED_REPLACEMENTS.get(type)) != null) {
            throw new InvalidManagedModelElementTypeException(extractionContext, String.format("type is not supported, please use %s instead", replacementType.getName()));
        }
        return null;
    }

    @Override
    public Iterable<String> getSupportedManagedTypes() {
        return Collections.emptySet();
    }
}

