/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import groovy.lang.GroovyObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Nullable;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.MethodDescription;
import org.gradle.internal.reflect.MethodSignatureEquivalence;
import org.gradle.model.Managed;
import org.gradle.model.ModelMap;
import org.gradle.model.Unmanaged;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.ModelCollectionSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelStructSchema;
import org.gradle.model.internal.manage.schema.cache.ModelSchemaCache;
import org.gradle.model.internal.manage.schema.extract.InvalidManagedModelElementTypeException;
import org.gradle.model.internal.manage.schema.extract.ManagedProxyClassGenerator;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionStrategy;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructStrategy
implements ModelSchemaExtractionStrategy {
    private static final NoOpModelElementState NO_OP_MODEL_ELEMENT_STATE = new NoOpModelElementState();
    private final Set<Equivalence.Wrapper<Method>> ignoredMethods;
    private final Factory<String> supportedTypeDescriptions;
    private final MethodSignatureEquivalence equivalence = new MethodSignatureEquivalence();
    private final ManagedProxyClassGenerator classGenerator = new ManagedProxyClassGenerator();
    private final ManagedProxyFactory proxyFactory = new ManagedProxyFactory();

    public StructStrategy(Factory<String> supportedTypeDescriptions) {
        this.supportedTypeDescriptions = supportedTypeDescriptions;
        Iterable ignoredMethods = Iterables.concat(Arrays.asList(Object.class.getMethods()), Arrays.asList(GroovyObject.class.getMethods()));
        this.ignoredMethods = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)ignoredMethods, (Function)new Function<Method, Equivalence.Wrapper<Method>>(){

            public Equivalence.Wrapper<Method> apply(@Nullable Method input) {
                return StructStrategy.this.equivalence.wrap((Object)input);
            }
        }));
    }

    @Override
    public Iterable<String> getSupportedManagedTypes() {
        return Collections.singleton("interfaces and abstract classes annotated with " + Managed.class.getName());
    }

    public <R> ModelSchemaExtractionResult<R> extract(final ModelSchemaExtractionContext<R> extractionContext, final ModelSchemaCache cache) {
        ModelType<R> type = extractionContext.getType();
        Class<R> clazz = type.getRawClass();
        if (clazz.isAnnotationPresent(Managed.class)) {
            this.validateType(type, extractionContext);
            Iterable<Method> methods = Arrays.asList(clazz.getMethods());
            if (!clazz.isInterface()) {
                methods = this.filterIgnoredMethods(methods);
            }
            ImmutableListMultimap methodsByName = Multimaps.index(methods, (Function)new Function<Method, String>(){

                public String apply(Method method) {
                    return method.getName();
                }
            });
            this.ensureNoOverloadedMethods(extractionContext, (ImmutableListMultimap<String, Method>)methodsByName);
            LinkedList properties = Lists.newLinkedList();
            ArrayList handled = Lists.newArrayListWithCapacity((int)clazz.getMethods().length);
            ReturnTypeSpecializationOrdering returnTypeSpecializationOrdering = new ReturnTypeSpecializationOrdering();
            for (String methodName : methodsByName.keySet()) {
                boolean isWritable;
                if (!methodName.startsWith("get") || methodName.equals("get")) continue;
                ImmutableList getterMethods = methodsByName.get((Object)methodName);
                Method sampleMethod = (Method)returnTypeSpecializationOrdering.max((Iterable)getterMethods);
                boolean abstractGetter = Modifier.isAbstract(sampleMethod.getModifiers());
                if (sampleMethod.getParameterTypes().length != 0) {
                    throw this.invalidMethod(extractionContext, "getter methods cannot take parameters", sampleMethod);
                }
                Character getterPropertyNameFirstChar = Character.valueOf(methodName.charAt(3));
                if (!Character.isUpperCase(getterPropertyNameFirstChar.charValue())) {
                    throw this.invalidMethod(extractionContext, "the 4th character of the getter method name must be an uppercase character", sampleMethod);
                }
                ModelType returnType = ModelType.returnType(sampleMethod);
                String propertyNameCapitalized = methodName.substring(3);
                String propertyName = StringUtils.uncapitalize((String)propertyNameCapitalized);
                String setterName = "set" + propertyNameCapitalized;
                ImmutableList setterMethods = methodsByName.get((Object)setterName);
                boolean bl = isWritable = !setterMethods.isEmpty();
                if (isWritable) {
                    Method setter = (Method)setterMethods.get(0);
                    if (!abstractGetter) {
                        throw this.invalidMethod(extractionContext, "setters are not allowed for non-abstract getters", setter);
                    }
                    this.validateSetter(extractionContext, returnType, setter);
                    handled.addAll(setterMethods);
                }
                if (abstractGetter) {
                    ImmutableSet declaringClasses = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)getterMethods, (Function)new Function<Method, ModelType<?>>(){

                        public ModelType<?> apply(Method input) {
                            return ModelType.of(input.getDeclaringClass());
                        }
                    }));
                    boolean unmanaged = Iterables.any((Iterable)getterMethods, (Predicate)new Predicate<Method>(){

                        public boolean apply(Method input) {
                            return input.getAnnotation(Unmanaged.class) != null;
                        }
                    });
                    properties.add(ModelProperty.of(returnType, propertyName, isWritable, declaringClasses, unmanaged));
                }
                handled.addAll(getterMethods);
            }
            Iterable notHandled = Iterables.filter((Iterable)methodsByName.values(), (Predicate)Predicates.not((Predicate)Predicates.in((Collection)handled)));
            if (!Iterables.isEmpty((Iterable)notHandled)) {
                throw this.invalidMethods(extractionContext, "only paired getter/setter methods are supported", notHandled);
            }
            Class<R> concreteClass = type.getConcreteClass();
            Class<R> implClass = this.classGenerator.generate(concreteClass);
            final ModelStructSchema<R> schema = ModelSchema.struct(type, properties, implClass);
            extractionContext.addValidator(new Action<ModelSchemaExtractionContext<R>>(){

                public void execute(ModelSchemaExtractionContext<R> validatorModelSchemaExtractionContext) {
                    StructStrategy.this.ensureCanBeInstantiated(extractionContext, schema);
                }
            });
            Iterable propertyDependencies = Iterables.transform((Iterable)properties, (Function)new Function<ModelProperty<?>, ModelSchemaExtractionContext<?>>(){

                public ModelSchemaExtractionContext<?> apply(ModelProperty<?> property) {
                    return StructStrategy.this.toPropertyExtractionContext(extractionContext, property, cache);
                }
            });
            return new ModelSchemaExtractionResult<R>(schema, propertyDependencies);
        }
        return null;
    }

    private <R> void ensureCanBeInstantiated(ModelSchemaExtractionContext<R> extractionContext, ModelStructSchema<R> schema) {
        try {
            this.proxyFactory.createProxy(NO_OP_MODEL_ELEMENT_STATE, schema);
        }
        catch (Throwable e) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "instance creation failed", e);
        }
    }

    private Iterable<Method> filterIgnoredMethods(Iterable<Method> methods) {
        return Iterables.filter(methods, (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                return !method.isSynthetic() && !StructStrategy.this.ignoredMethods.contains(StructStrategy.this.equivalence.wrap((Object)method));
            }
        });
    }

    private <R> void ensureNoOverloadedMethods(ModelSchemaExtractionContext<R> extractionContext, ImmutableListMultimap<String, Method> methodsByName) {
        ImmutableSet methodNames = methodsByName.keySet();
        for (String methodName : methodNames) {
            List deduped;
            ImmutableList methods = methodsByName.get((Object)methodName);
            if (methods.size() <= 1 || (deduped = CollectionUtils.dedup((Iterable)methods, (Equivalence)this.equivalence)).size() <= 1) continue;
            throw this.invalidMethods(extractionContext, "overloaded methods are not supported", deduped);
        }
    }

    private <R, P> ModelSchemaExtractionContext<P> toPropertyExtractionContext(final ModelSchemaExtractionContext<R> parentContext, final ModelProperty<P> property, final ModelSchemaCache modelSchemaCache) {
        return parentContext.child(property.getType(), this.propertyDescription(parentContext, property), new Action<ModelSchemaExtractionContext<P>>(){

            public void execute(ModelSchemaExtractionContext<P> propertyExtractionContext) {
                ModelCollectionSchema propertyCollectionSchema;
                ModelSchema propertySchema = modelSchemaCache.get(property.getType());
                if (property.getName().equals("name") && Named.class.isAssignableFrom(parentContext.getType().getRawClass())) {
                    if (property.isWritable()) {
                        throw new InvalidManagedModelElementTypeException(parentContext, String.format("@Managed types implementing %s must not declare a setter for the name property", Named.class.getName()));
                    }
                    return;
                }
                if (propertySchema.getKind().isAllowedPropertyTypeOfManagedType() && property.isUnmanaged()) {
                    throw new InvalidManagedModelElementTypeException(parentContext, String.format("property '%s' is marked as @Unmanaged, but is of @Managed type '%s'. Please remove the @Managed annotation.%n%s", property.getName(), property.getType(), StructStrategy.this.supportedTypeDescriptions.create()));
                }
                if (!propertySchema.getKind().isAllowedPropertyTypeOfManagedType() && !property.isUnmanaged()) {
                    throw new InvalidManagedModelElementTypeException(parentContext, String.format("type %s cannot be used for property '%s' as it is an unmanaged type (please annotate the getter with @org.gradle.model.Unmanaged if you want this property to be unmanaged).%n%s", property.getType(), property.getName(), StructStrategy.this.supportedTypeDescriptions.create()));
                }
                if (!property.isWritable()) {
                    if (property.isUnmanaged()) {
                        throw new InvalidManagedModelElementTypeException(parentContext, String.format("unmanaged property '%s' cannot be read only, unmanaged properties must have setters", property.getName()));
                    }
                    if (!propertySchema.getKind().isManaged()) {
                        throw new InvalidManagedModelElementTypeException(parentContext, String.format("read only property '%s' has non managed type %s, only managed types can be used", property.getName(), property.getType()));
                    }
                }
                if (propertySchema.getKind() == ModelSchema.Kind.COLLECTION && (propertyCollectionSchema = (ModelCollectionSchema)propertySchema).isMap() && property.isWritable()) {
                    throw new InvalidManagedModelElementTypeException(parentContext, String.format("property '%s' cannot have a setter (%s properties must be read only).", property.getName(), ModelMap.class.getName()));
                }
            }
        });
    }

    private String propertyDescription(ModelSchemaExtractionContext<?> parentContext, ModelProperty<?> property) {
        if (property.getDeclaredBy().size() == 1 && property.getDeclaredBy().contains(parentContext.getType())) {
            return String.format("property '%s'", property.getName());
        }
        ImmutableSortedSet declaredBy = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(property.getDeclaredBy(), (Function)Functions.toStringFunction()));
        return String.format("property '%s' declared by %s", property.getName(), Joiner.on((String)", ").join((Iterable)declaredBy));
    }

    private void validateSetter(ModelSchemaExtractionContext<?> extractionContext, ModelType<?> propertyType, Method setter) {
        if (!Modifier.isAbstract(setter.getModifiers())) {
            throw this.invalidMethod(extractionContext, "non-abstract setters are not allowed", setter);
        }
        if (!setter.getReturnType().equals(Void.TYPE)) {
            throw this.invalidMethod(extractionContext, "setter method must have void return type", setter);
        }
        Type[] setterParameterTypes = setter.getGenericParameterTypes();
        if (setterParameterTypes.length != 1) {
            throw this.invalidMethod(extractionContext, "setter method must have exactly one parameter", setter);
        }
        ModelType setterType = ModelType.paramType(setter, 0);
        if (!setterType.equals(propertyType)) {
            String message = "setter method param must be of exactly the same type as the getter returns (expected: " + propertyType + ", found: " + setterType + ")";
            throw this.invalidMethod(extractionContext, message, setter);
        }
    }

    private void validateType(ModelType<?> type, ModelSchemaExtractionContext<?> extractionContext) {
        Class<?> typeClass = type.getConcreteClass();
        if (!typeClass.isInterface() && !Modifier.isAbstract(typeClass.getModifiers())) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "must be defined as an interface or an abstract class.");
        }
        if (typeClass.getTypeParameters().length > 0) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "cannot be a parameterized type.");
        }
        Constructor<?> customConstructor = this.findCustomConstructor(typeClass);
        if (customConstructor != null) {
            throw this.invalidMethod(extractionContext, "custom constructors are not allowed", customConstructor);
        }
        this.ensureNoInstanceScopedFields(extractionContext, typeClass);
        this.ensureNoProtectedOrPrivateMethods(extractionContext, typeClass);
    }

    private void ensureNoProtectedOrPrivateMethods(ModelSchemaExtractionContext<?> extractionContext, Class<?> typeClass) {
        Iterable protectedAndPrivateMethods;
        Class<?> superClass = typeClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.ensureNoProtectedOrPrivateMethods(extractionContext, superClass);
        }
        if (!Iterables.isEmpty((Iterable)(protectedAndPrivateMethods = Iterables.filter(Arrays.asList(typeClass.getDeclaredMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(Method method) {
                int modifiers = method.getModifiers();
                return !method.isSynthetic() && (Modifier.isProtected(modifiers) || Modifier.isPrivate(modifiers));
            }
        })))) {
            throw this.invalidMethods(extractionContext, "protected and private methods are not allowed", protectedAndPrivateMethods);
        }
    }

    private void ensureNoInstanceScopedFields(ModelSchemaExtractionContext<?> extractionContext, Class<?> typeClass) {
        List<Field> declaredFields;
        Iterable instanceScopedFields;
        ImmutableSortedSet sortedDescriptions;
        Class<?> superClass = typeClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.ensureNoInstanceScopedFields(extractionContext, superClass);
        }
        if (!(sortedDescriptions = ImmutableSortedSet.copyOf((Iterable)Iterables.transform((Iterable)(instanceScopedFields = Iterables.filter(declaredFields = Arrays.asList(typeClass.getDeclaredFields()), (Predicate)new Predicate<Field>(){

            public boolean apply(Field field) {
                return !Modifier.isStatic(field.getModifiers()) && !field.getName().equals("metaClass");
            }
        })), (Function)new Function<Field, String>(){

            public String apply(Field field) {
                return field.toString();
            }
        }))).isEmpty()) {
            throw new InvalidManagedModelElementTypeException(extractionContext, "instance scoped fields are not allowed (found fields: " + Joiner.on((String)", ").join((Iterable)sortedDescriptions) + ").");
        }
    }

    private Constructor<?> findCustomConstructor(Class<?> typeClass) {
        Constructor<?> customSuperConstructor;
        Class<?> superClass = typeClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class) && (customSuperConstructor = this.findCustomConstructor(typeClass.getSuperclass())) != null) {
            return customSuperConstructor;
        }
        Constructor<?>[] constructors = typeClass.getConstructors();
        if (constructors.length == 0 || constructors.length == 1 && constructors[0].getParameterTypes().length == 0) {
            return null;
        }
        for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterTypes().length <= 0) continue;
            return constructor;
        }
        throw new RuntimeException(String.format("Expected a constructor taking at least one argument in %s but no such constructors were found", typeClass.getName()));
    }

    private InvalidManagedModelElementTypeException invalidMethod(ModelSchemaExtractionContext<?> extractionContext, String message, Method method) {
        return this.invalidMethod(extractionContext, message, MethodDescription.of((Method)method));
    }

    private InvalidManagedModelElementTypeException invalidMethod(ModelSchemaExtractionContext<?> extractionContext, String message, Constructor<?> constructor) {
        return this.invalidMethod(extractionContext, message, MethodDescription.of(constructor));
    }

    private InvalidManagedModelElementTypeException invalidMethod(ModelSchemaExtractionContext<?> extractionContext, String message, MethodDescription methodDescription) {
        return new InvalidManagedModelElementTypeException(extractionContext, message + " (invalid method: " + methodDescription.toString() + ").");
    }

    private InvalidManagedModelElementTypeException invalidMethods(ModelSchemaExtractionContext<?> extractionContext, String message, Iterable<Method> methods) {
        ImmutableSortedSet descriptions = ImmutableSortedSet.copyOf((Iterable)Iterables.transform(methods, (Function)new Function<Method, String>(){

            public String apply(Method method) {
                return MethodDescription.of((Method)method).toString();
            }
        }));
        return new InvalidManagedModelElementTypeException(extractionContext, message + " (invalid methods: " + Joiner.on((String)", ").join((Iterable)descriptions) + ").");
    }

    private static class NoOpModelElementState
    implements ModelElementState {
        private NoOpModelElementState() {
        }

        public MutableModelNode getBackingNode() {
            return null;
        }

        public String getDisplayName() {
            return null;
        }

        public Object get(String name) {
            return null;
        }

        public void set(String name, Object value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReturnTypeSpecializationOrdering
    extends Ordering<Method> {
        private ReturnTypeSpecializationOrdering() {
        }

        public int compare(Method left, Method right) {
            Class<?> rightType;
            Class<?> leftType = left.getReturnType();
            if (leftType.equals(rightType = right.getReturnType())) {
                return 0;
            }
            if (leftType.isAssignableFrom(rightType)) {
                return -1;
            }
            if (rightType.isAssignableFrom(leftType)) {
                return 1;
            }
            throw new UnsupportedOperationException(String.format("Cannot compare two types that aren't part of an inheritance hierarchy: %s, %s", leftType, rightType));
        }
    }
}

