/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.actions.MergeOperations;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighter;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighterImpl;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.DiffMarkup;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.processing.TextCompareProcessor;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesDiffCalculator
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.ChangesDiffCalculator");
    private final BaseMarkup myOldMarkup = new BaseMarkup(FragmentSide.SIDE1, (Disposable)this);
    private final ChangesCollector myNewMarkup = new ChangesCollector(this);
    private final TextCompareProcessor myCompareProcessor = new TextCompareProcessor(ComparisonPolicy.DEFAULT);

    public Collection<TextRange> calculateDiff(@NotNull Document beforeDocument, @NotNull Document currentDocument) {
        List lineFragments;
        if (beforeDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeDocument", "com/intellij/application/options/ChangesDiffCalculator", "calculateDiff"));
        }
        if (currentDocument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDocument", "com/intellij/application/options/ChangesDiffCalculator", "calculateDiff"));
        }
        this.myNewMarkup.ranges.clear();
        this.myOldMarkup.document = beforeDocument;
        this.myNewMarkup.document = currentDocument;
        try {
            lineFragments = this.myCompareProcessor.process(beforeDocument.getText(), currentDocument.getText());
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info((Throwable)e);
            return Collections.emptyList();
        }
        FragmentHighlighterImpl fragmentHighlighter = new FragmentHighlighterImpl(this.myOldMarkup, this.myNewMarkup);
        Iterator iterator = lineFragments.iterator();
        while (iterator.hasNext()) {
            LineFragment fragment = (LineFragment)iterator.next();
            fragmentHighlighter.setIsLast(!iterator.hasNext());
            fragment.highlight((FragmentHighlighter)fragmentHighlighter);
        }
        return new ArrayList<TextRange>(this.myNewMarkup.ranges);
    }

    public void dispose() {
    }

    private static class ChangesCollector
    extends BaseMarkup {
        private static final Set<TextDiffTypeEnum> INTERESTED_DIFF_TYPES = EnumSet.of(TextDiffTypeEnum.INSERT, TextDiffTypeEnum.DELETED, TextDiffTypeEnum.CHANGED);
        public final List<TextRange> ranges;

        ChangesCollector(@NotNull Disposable parentDisposable) {
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/application/options/ChangesDiffCalculator$ChangesCollector", "<init>"));
            }
            super(FragmentSide.SIDE2, parentDisposable);
            this.ranges = new ArrayList<TextRange>();
        }

        @Override
        public void highlightText(@NotNull Fragment fragment, GutterIconRenderer gutterIconRenderer) {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/application/options/ChangesDiffCalculator$ChangesCollector", "highlightText"));
            }
            TextRange currentRange = fragment.getRange(FragmentSide.SIDE2);
            if (INTERESTED_DIFF_TYPES.contains(fragment.getType())) {
                this.ranges.add(currentRange);
            }
        }
    }

    private static class BaseMarkup
    extends DiffMarkup {
        public Document document;
        private final FragmentSide mySide;

        BaseMarkup(@NotNull FragmentSide side, @NotNull Disposable parentDisposable) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/application/options/ChangesDiffCalculator$BaseMarkup", "<init>"));
            }
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/application/options/ChangesDiffCalculator$BaseMarkup", "<init>"));
            }
            super(null, parentDisposable);
            this.mySide = side;
        }

        @Override
        public FragmentSide getSide() {
            return this.mySide;
        }

        @Override
        public DiffContent getContent() {
            return null;
        }

        @Override
        public EditorEx getEditor() {
            return null;
        }

        @Override
        @Nullable
        public Document getDocument() {
            return this.document;
        }

        @Override
        public void addLineMarker(int line, TextDiffType type, SeparatorPlacement separatorPlacement) {
        }

        @Override
        public void addAction(MergeOperations.Operation operation, int lineStartOffset) {
        }

        @Override
        public void highlightText(@NotNull Fragment fragment, GutterIconRenderer gutterIconRenderer) {
            if (fragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/application/options/ChangesDiffCalculator$BaseMarkup", "highlightText"));
            }
        }

        @Override
        public FileEditor getFileEditor() {
            return null;
        }
    }
}

