/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.CompletionBundle;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.SkipAutopopupInStrings;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.filters.classes.AnnotationTypeFilter;
import com.intellij.psi.filters.element.ExcludeDeclaredFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassNameCompletionContributor
extends CompletionContributor {
    public static final PsiJavaElementPattern.Capture<PsiElement> AFTER_NEW = (PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"new"});
    private static final PsiJavaElementPattern.Capture<PsiElement> IN_TYPE_PARAMETER = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"extends", "super", "&"})).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceList.class).withParent(PsiTypeParameter.class));
    private static final ElementPattern<PsiElement> IN_EXTENDS_IMPLEMENTS = PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiElement(PsiReferenceList.class).withParent((ElementPattern)PsiJavaPatterns.psiClass()));

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet _result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaClassNameCompletionContributor", "fillCompletionVariants"));
        }
        if (_result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/codeInsight/completion/JavaClassNameCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.getCompletionType() == CompletionType.CLASS_NAME || parameters.isExtendedCompletion() && JavaClassNameCompletionContributor.mayContainClassName(parameters)) {
            JavaClassNameCompletionContributor.addAllClasses(parameters, _result);
        }
    }

    static void addAllClasses(CompletionParameters parameters, CompletionResultSet _result) {
        CompletionResultSet result2 = _result.withPrefixMatcher(CompletionUtil.findReferenceOrAlphanumericPrefix(parameters));
        JavaClassNameCompletionContributor.addAllClasses(parameters, parameters.getInvocationCount() <= 1, result2.getPrefixMatcher(), (Consumer<LookupElement>)_result);
    }

    private static boolean mayContainClassName(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        PsiFile file2 = position.getContainingFile();
        if (file2 instanceof PsiPlainTextFile || file2.getFileType() instanceof CustomSyntaxTableFileType) {
            return true;
        }
        if (SkipAutopopupInStrings.isInStringLiteral((PsiElement)position)) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)position, PsiComment.class, (boolean)false) != null;
    }

    public static void addAllClasses(@NotNull CompletionParameters parameters, final boolean filterByScope, final @NotNull PrefixMatcher matcher, final @NotNull Consumer<LookupElement> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaClassNameCompletionContributor", "addAllClasses"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/codeInsight/completion/JavaClassNameCompletionContributor", "addAllClasses"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/codeInsight/completion/JavaClassNameCompletionContributor", "addAllClasses"));
        }
        final PsiElement insertedElement = parameters.getPosition();
        final ExcludeDeclaredFilter filter = IN_EXTENDS_IMPLEMENTS.accepts((Object)insertedElement) ? new ExcludeDeclaredFilter(new ClassFilter(PsiClass.class)) : (IN_TYPE_PARAMETER.accepts((Object)insertedElement) ? new ExcludeDeclaredFilter(new ClassFilter(PsiTypeParameter.class)) : (JavaCompletionContributor.ANNOTATION_NAME.accepts((Object)insertedElement) ? new AnnotationTypeFilter() : TrueFilter.INSTANCE));
        final boolean inJavaContext = parameters.getPosition() instanceof PsiIdentifier;
        final boolean afterNew = AFTER_NEW.accepts((Object)insertedElement);
        if (afterNew) {
            PsiExpression expr = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)insertedElement, PsiExpression.class, (boolean)true);
            for (ExpectedTypeInfo info : ExpectedTypesProvider.getExpectedTypes(expr, true)) {
                PsiClass defClass;
                PsiType defaultType;
                PsiType type = info.getType();
                PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
                if (psiClass != null && psiClass.getName() != null) {
                    consumer.consume((Object)JavaClassNameCompletionContributor.createClassLookupItem(psiClass, inJavaContext));
                }
                if ((defaultType = info.getDefaultType()).equals(type) || (defClass = PsiUtil.resolveClassInType((PsiType)defaultType)) == null || defClass.getName() == null) continue;
                consumer.consume((Object)JavaClassNameCompletionContributor.createClassLookupItem(defClass, true));
            }
        }
        final boolean pkgContext = JavaCompletionUtil.inSomePackage(insertedElement);
        AllClassesGetter.processJavaClasses(parameters, matcher, filterByScope, new Consumer<PsiClass>(){

            public void consume(PsiClass psiClass) {
                this.processClass(psiClass, null, "");
            }

            private void processClass(PsiClass psiClass, @Nullable Set<PsiClass> visited, String prefix) {
                block7: {
                    PsiClass[] innerClasses;
                    block6: {
                        boolean isInnerClass = StringUtil.isNotEmpty((String)prefix);
                        if (isInnerClass && this.isProcessedIndependently(psiClass)) {
                            return;
                        }
                        if (!filter.isAcceptable((Object)psiClass, insertedElement)) break block6;
                        if (!inJavaContext) {
                            JavaPsiClassReferenceElement element = AllClassesGetter.createLookupItem(psiClass, AllClassesGetter.TRY_SHORTENING);
                            element.setLookupString(prefix + element.getLookupString());
                            consumer.consume((Object)element);
                        } else {
                            for (JavaPsiClassReferenceElement element : JavaClassNameCompletionContributor.createClassLookupItems(psiClass, afterNew, JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER, new Condition<PsiClass>(){

                                public boolean value(PsiClass psiClass) {
                                    return filter.isAcceptable((Object)psiClass, insertedElement) && AllClassesGetter.isAcceptableInContext(insertedElement, psiClass, filterByScope, pkgContext);
                                }
                            })) {
                                element.setLookupString(prefix + element.getLookupString());
                                consumer.consume((Object)element);
                            }
                        }
                        break block7;
                    }
                    String name = psiClass.getName();
                    if (name == null || (innerClasses = psiClass.getInnerClasses()).length <= 0) break block7;
                    if (visited == null) {
                        visited = ContainerUtil.newHashSet();
                    }
                    for (PsiClass innerClass : innerClasses) {
                        if (!visited.add(innerClass)) continue;
                        this.processClass(innerClass, visited, prefix + name + ".");
                    }
                }
            }

            private boolean isProcessedIndependently(PsiClass psiClass) {
                String innerName = psiClass.getName();
                return innerName != null && matcher.prefixMatches(innerName);
            }
        });
    }

    static LookupElement highlightIfNeeded(JavaPsiClassReferenceElement element, CompletionParameters parameters) {
        return JavaCompletionUtil.highlightIfNeeded(null, (LookupElement)element, element.getObject(), parameters.getPosition());
    }

    public static JavaPsiClassReferenceElement createClassLookupItem(PsiClass psiClass, boolean inJavaContext) {
        return AllClassesGetter.createLookupItem(psiClass, inJavaContext ? JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER : AllClassesGetter.TRY_SHORTENING);
    }

    public static List<JavaPsiClassReferenceElement> createClassLookupItems(PsiClass psiClass, boolean withInners, InsertHandler<JavaPsiClassReferenceElement> insertHandler, Condition<PsiClass> condition) {
        SmartList result2 = new SmartList();
        if (condition.value((Object)psiClass)) {
            result2.add(AllClassesGetter.createLookupItem(psiClass, insertHandler));
        }
        String name = psiClass.getName();
        if (withInners && name != null) {
            for (PsiClass inner : psiClass.getInnerClasses()) {
                if (!inner.hasModifierProperty("static")) continue;
                for (JavaPsiClassReferenceElement lookupInner : JavaClassNameCompletionContributor.createClassLookupItems(inner, true, insertHandler, condition)) {
                    String forced = lookupInner.getForcedPresentableName();
                    String qualifiedName = name + "." + (forced != null ? forced : inner.getName());
                    lookupInner.setForcedPresentableName(qualifiedName);
                    lookupInner.setLookupString(qualifiedName);
                    result2.add(lookupInner);
                }
            }
        }
        return result2;
    }

    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/completion/JavaClassNameCompletionContributor", "handleEmptyLookup"));
        }
        if (!(parameters.getOriginalFile() instanceof PsiJavaFile)) {
            return null;
        }
        if (JavaClassNameCompletionContributor.shouldShowSecondSmartCompletionHint(parameters)) {
            return LangBundle.message("completion.no.suggestions", new Object[0]) + "; " + StringUtil.decapitalize((String)CompletionBundle.message("completion.class.name.hint.2", JavaClassNameCompletionContributor.getActionShortcut((String)"CodeCompletion")));
        }
        return null;
    }

    private static boolean shouldShowSecondSmartCompletionHint(CompletionParameters parameters) {
        return parameters.getCompletionType() == CompletionType.BASIC && parameters.getInvocationCount() == 2 && parameters.getOriginalFile().getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }
}

