/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibleLineMarkersPassFactory
extends VisibleHighlightingPassFactory
implements TextEditorHighlightingPassFactory {
    public VisibleLineMarkersPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        super(project);
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, 10);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("VisibleLineMarkersPassFactory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/VisibleLineMarkersPassFactory", "getComponentName"));
        }
        return "VisibleLineMarkersPassFactory";
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/VisibleLineMarkersPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/VisibleLineMarkersPassFactory", "createHighlightingPass"));
        }
        TextRange textRange = VisibleLineMarkersPassFactory.calculateRangeToProcess(editor);
        if (textRange == null) {
            return null;
        }
        return new LineMarkersPass(file2.getProject(), file2, editor, editor.getDocument(), textRange);
    }
}

