/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import org.jetbrains.annotations.NotNull;

public class SuperMethodReturnFix
implements IntentionAction {
    private final PsiType mySuperMethodType;
    private final PsiMethod mySuperMethod;

    public SuperMethodReturnFix(@NotNull PsiMethod superMethod, @NotNull PsiType superMethodType) {
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix", "<init>"));
        }
        if (superMethodType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodType", "com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix", "<init>"));
        }
        this.mySuperMethodType = superMethodType;
        this.mySuperMethod = superMethod;
    }

    @NotNull
    public String getText() {
        String name = PsiFormatUtil.formatMethod((PsiMethod)this.mySuperMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
        String string = QuickFixBundle.message("fix.super.method.return.type.text", name, JavaHighlightUtil.formatType(this.mySuperMethodType));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.super.method.return.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix", "isAvailable"));
        }
        return this.mySuperMethod.isValid() && this.mySuperMethod.getManager().isInProject((PsiElement)this.mySuperMethod) && this.mySuperMethodType.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/SuperMethodReturnFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.mySuperMethod.getContainingFile())) {
            return;
        }
        ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(project, this.mySuperMethod, false, null, this.mySuperMethod.getName(), this.mySuperMethodType, ParameterInfoImpl.fromMethod(this.mySuperMethod));
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor2.run();
        } else {
            processor2.run();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

