/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.ide.TypePresentationService;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableArrayTypeFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final PsiArrayType myTargetType;
    private final String myName;
    private final String myFamilyName;

    public VariableArrayTypeFix(@NotNull PsiArrayInitializerExpression initializer, @NotNull PsiType componentType) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "<init>"));
        }
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "<init>"));
        }
        super((PsiElement)VariableArrayTypeFix.getInitializer(initializer));
        PsiArrayType arrayType = new PsiArrayType(componentType);
        PsiArrayInitializerExpression arrayInitializer = initializer;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
            arrayType = new PsiArrayType((PsiType)arrayType);
        }
        this.myTargetType = arrayType;
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(arrayInitializer);
        PsiVariable myVariable = VariableArrayTypeFix.getVariableLocal(arrayInitializer);
        String string = myVariable == null ? null : (this.myName = this.myTargetType.equals((Object)myVariable.getType()) && myNewExpression != null ? QuickFixBundle.message("change.new.operator.type.text", VariableArrayTypeFix.getNewText((PsiElement)myNewExpression, arrayInitializer), this.myTargetType.getCanonicalText(), "") : QuickFixBundle.message("fix.variable.type.text", VariableArrayTypeFix.formatType(myVariable), myVariable.getName(), this.myTargetType.getCanonicalText()));
        this.myFamilyName = myVariable == null ? null : (this.myTargetType.equals((Object)myVariable.getType()) && myNewExpression != null ? QuickFixBundle.message("change.new.operator.type.family", new Object[0]) : QuickFixBundle.message("fix.variable.type.family", new Object[0]));
    }

    private static String formatType(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "formatType"));
        }
        FindUsagesProvider provider = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(variable.getLanguage());
        String type = provider.getType((PsiElement)variable);
        if (StringUtil.isNotEmpty((String)type)) {
            return type;
        }
        return TypePresentationService.getService().getTypePresentableName(variable.getClass());
    }

    private static PsiArrayInitializerExpression getInitializer(PsiArrayInitializerExpression initializer) {
        PsiArrayInitializerExpression arrayInitializer = initializer;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
        }
        return arrayInitializer;
    }

    private static PsiVariable getVariableLocal(@NotNull PsiArrayInitializerExpression initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "getVariableLocal"));
        }
        PsiVariable variableLocal = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof PsiVariable) {
            variableLocal = (PsiVariable)parent;
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpressionLocal = (PsiNewExpression)parent;
            PsiElement newParent = newExpressionLocal.getParent();
            if (newParent instanceof PsiAssignmentExpression) {
                variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)newParent);
            } else if (newParent instanceof PsiVariable) {
                variableLocal = (PsiVariable)newParent;
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)parent);
        }
        return variableLocal;
    }

    private static PsiNewExpression getNewExpressionLocal(@NotNull PsiArrayInitializerExpression initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "getNewExpressionLocal"));
        }
        PsiNewExpression newExpressionLocal = null;
        PsiElement parent = initializer.getParent();
        if (!(parent instanceof PsiVariable) && parent instanceof PsiNewExpression) {
            newExpressionLocal = (PsiNewExpression)parent;
        }
        return newExpressionLocal;
    }

    @Nullable
    private static PsiVariable getFromAssignment(PsiAssignmentExpression assignment) {
        PsiExpression reference = assignment.getLExpression();
        PsiElement referencedElement = reference instanceof PsiReferenceExpression ? ((PsiReferenceExpression)reference).resolve() : null;
        return referencedElement != null && referencedElement instanceof PsiVariable ? (PsiVariable)referencedElement : null;
    }

    private static String getNewText(PsiElement myNewExpression, PsiArrayInitializerExpression myInitializer) {
        String newText = myNewExpression.getText();
        int initializerIdx = newText.indexOf(myInitializer.getText());
        if (initializerIdx != -1) {
            return newText.substring(0, initializerIdx).trim();
        }
        return newText;
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "isAvailable"));
        }
        PsiArrayInitializerExpression myInitializer = (PsiArrayInitializerExpression)startElement;
        PsiVariable myVariable = VariableArrayTypeFix.getVariableLocal(myInitializer);
        return myVariable != null && myVariable.isValid() && myVariable.getManager().isInProject((PsiElement)myVariable) && this.myTargetType.isValid() && myInitializer.isValid();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/VariableArrayTypeFix", "invoke"));
        }
        PsiArrayInitializerExpression myInitializer = (PsiArrayInitializerExpression)startElement;
        PsiVariable myVariable = VariableArrayTypeFix.getVariableLocal(myInitializer);
        if (myVariable == null) {
            return;
        }
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(myInitializer);
        if (!FileModificationService.getInstance().prepareFileForWrite(myVariable.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)file2.getProject()).getElementFactory();
        if (!this.myTargetType.equals((Object)myVariable.getType())) {
            myVariable.normalizeDeclaration();
            myVariable.getTypeElement().replace((PsiElement)factory.createTypeElement((PsiType)this.myTargetType));
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)myVariable);
            if (!myVariable.getContainingFile().equals(file2)) {
                UndoUtil.markPsiFileForUndo((PsiFile)myVariable.getContainingFile());
            }
        }
        if (myNewExpression != null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            String text = "new " + this.myTargetType.getCanonicalText() + "{}";
            PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText(text, myNewExpression.getParent());
            PsiElement[] children2 = newExpression.getChildren();
            children2[children2.length - 1].replace((PsiElement)myInitializer);
            myNewExpression.replace((PsiElement)newExpression);
        }
    }
}

