/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.FoldingData;
import com.intellij.codeInsight.editorActions.FoldingTransferableData;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyPasteFoldingProcessor
extends CopyPastePostProcessor<FoldingTransferableData> {
    @Override
    @NotNull
    public List<FoldingTransferableData> collectTransferableData(PsiFile file2, Editor editor, int[] startOffsets, int[] endOffsets) {
        FoldRegion[] regions;
        ArrayList<FoldingData> list = new ArrayList<FoldingData>();
        for (FoldRegion region : regions = editor.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid()) continue;
            for (int j = 0; j < startOffsets.length; ++j) {
                if (startOffsets[j] > region.getStartOffset() || region.getEndOffset() > endOffsets[j]) continue;
                list.add(new FoldingData(region.getStartOffset() - startOffsets[j], region.getEndOffset() - startOffsets[j], region.isExpanded()));
            }
        }
        List<FoldingTransferableData> list2 = Collections.singletonList(new FoldingTransferableData(list.toArray(new FoldingData[list.size()])));
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/CopyPasteFoldingProcessor", "collectTransferableData"));
        }
        return list2;
    }

    @Override
    @NotNull
    public List<FoldingTransferableData> extractTransferableData(Transferable content) {
        FoldingTransferableData foldingData = null;
        try {
            DataFlavor flavor = FoldingData.getDataFlavor();
            if (flavor != null) {
                foldingData = (FoldingTransferableData)content.getTransferData(flavor);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (foldingData != null) {
            List<FoldingTransferableData> list = Collections.singletonList(foldingData.clone());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/CopyPasteFoldingProcessor", "extractTransferableData"));
            }
            return list;
        }
        List<FoldingTransferableData> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/editorActions/CopyPasteFoldingProcessor", "extractTransferableData"));
        }
        return list;
    }

    @Override
    public void processTransferableData(Project project, final Editor editor, final RangeMarker bounds, int caretOffset, Ref<Boolean> indented, List<FoldingTransferableData> values) {
        assert (values.size() == 1);
        final FoldingTransferableData value = values.get(0);
        if (value.getData().length == 0) {
            return;
        }
        final CodeFoldingManagerImpl foldingManager = (CodeFoldingManagerImpl)CodeFoldingManager.getInstance(project);
        foldingManager.updateFoldRegions(editor, true);
        Runnable operation = new Runnable(){

            @Override
            public void run() {
                for (FoldingData data : value.getData()) {
                    FoldRegion region = foldingManager.findFoldRegion(editor, data.startOffset + bounds.getStartOffset(), data.endOffset + bounds.getStartOffset());
                    if (region == null) continue;
                    region.setExpanded(data.isExpanded);
                }
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(operation);
    }
}

