/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.impl.ElementLookupRenderer;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaElementLookupRenderer
implements ElementLookupRenderer {
    @Override
    public boolean handlesItem(Object element) {
        return element instanceof BeanPropertyElement;
    }

    public void renderElement(LookupItem item, Object element, LookupElementPresentation presentation) {
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon((LookupElement)item, presentation.isReal()));
        presentation.setItemText(PsiUtilCore.getName((PsiElement)((PsiElement)element)));
        presentation.setStrikeout(JavaElementLookupRenderer.isToStrikeout((LookupElement)item));
        presentation.setTailText((String)item.getAttribute(LookupItem.TAIL_TEXT_ATTR), item.getAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR) != null);
        PsiType type = ((BeanPropertyElement)((Object)element)).getPropertyType();
        presentation.setTypeText(type == null ? null : type.getPresentableText());
    }

    public static boolean isToStrikeout(LookupElement item) {
        List<PsiMethod> allMethods = JavaCompletionUtil.getAllMethods(item);
        if (allMethods != null) {
            for (PsiMethod method : allMethods) {
                if (!method.isValid()) {
                    return false;
                }
                if (JavaElementLookupRenderer.isDeprecated((PsiElement)method)) continue;
                return false;
            }
            return true;
        }
        return JavaElementLookupRenderer.isDeprecated(item.getPsiElement());
    }

    private static boolean isDeprecated(@Nullable PsiElement element) {
        return element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated();
    }
}

