/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class MethodDownHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        int[] offsets;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/navigation/MethodDownHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/MethodDownHandler", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/MethodDownHandler", "invoke"));
        }
        LookupManager.getInstance(project).hideActiveLookup();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int caretOffset = editor.getCaretModel().getOffset();
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (int offset : offsets = MethodUpDownUtil.getNavigationOffsets(file2, caretOffset)) {
            int line;
            if (offset <= caretOffset || (line = editor.offsetToLogicalPosition((int)offset).line) <= caretLine) continue;
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().removeSelection();
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
            IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            break;
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

