/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.SelectInEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithTernaryOperatorFix
implements LocalQuickFix {
    private final String myText;

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.replace.ternary.quickfix", (Object[])new Object[]{this.myText});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "getName"));
        }
        return string;
    }

    public ReplaceWithTernaryOperatorFix(@NotNull PsiExpression expressionToAssert) {
        if (expressionToAssert == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionToAssert", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "<init>"));
        }
        this.myText = expressionToAssert.getText();
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"inspection.surround.if.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement parent;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        while ((parent = element.getParent()) instanceof PsiReferenceExpression || parent instanceof PsiMethodCallExpression) {
            element = parent;
        }
        if (!(element instanceof PsiExpression)) {
            return;
        }
        PsiExpression expression = (PsiExpression)element;
        PsiFile file2 = expression.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiConditionalExpression conditionalExpression = ReplaceWithTernaryOperatorFix.replaceWthConditionalExpression(project, this.myText + "!=null", expression, ReplaceWithTernaryOperatorFix.suggestDefaultValue(expression));
        PsiExpression elseExpression = conditionalExpression.getElseExpression();
        if (elseExpression != null) {
            ((Navigatable)elseExpression).navigate(true);
            SelectInEditorManager.getInstance((Project)project).selectInEditor(file2.getVirtualFile(), elseExpression.getTextRange().getStartOffset(), elseExpression.getTextRange().getEndOffset(), false, true);
        }
    }

    @NotNull
    private static PsiConditionalExpression replaceWthConditionalExpression(@NotNull Project project, @NotNull String condition, @NotNull PsiExpression expression, @NotNull String defaultValue) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiElement parent = expression.getParent();
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)factory.createExpressionFromText(condition + " ? " + expression.getText() + " : " + defaultValue, parent);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiConditionalExpression psiConditionalExpression = (PsiConditionalExpression)expression.replace(codeStyleManager.reformat((PsiElement)conditionalExpression));
        if (psiConditionalExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "replaceWthConditionalExpression"));
        }
        return psiConditionalExpression;
    }

    public static boolean isAvailable(@NotNull PsiExpression qualifier, @NotNull PsiExpression expression) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "isAvailable"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "isAvailable"));
        }
        if (!qualifier.isValid() || qualifier.getText() == null) {
            return false;
        }
        return !(expression.getParent() instanceof PsiExpressionStatement) && !PsiUtil.isAccessedForWriting((PsiExpression)expression);
    }

    private static String suggestDefaultValue(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/ReplaceWithTernaryOperatorFix", "suggestDefaultValue"));
        }
        PsiType type = expression.getType();
        return PsiTypesUtil.getDefaultValueOfType((PsiType)type);
    }
}

