/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.DFSTree;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;

public final class RichControlFlow {
    public final ControlFlowGraph controlFlow;
    public final DFSTree dfsTree;

    public RichControlFlow(ControlFlowGraph controlFlow, DFSTree dfsTree) {
        this.controlFlow = controlFlow;
        this.dfsTree = dfsTree;
    }

    public boolean reducible() {
        if (this.dfsTree.back.isEmpty()) {
            return true;
        }
        int size = this.controlFlow.transitions.length;
        boolean[] loopEnters = this.dfsTree.loopEnters;
        TIntHashSet[] cycleIncomings = new TIntHashSet[size];
        TIntArrayList[] nonCycleIncomings = new TIntArrayList[size];
        int[] collapsedTo = new int[size];
        int[] queue = new int[size];
        for (int i = 0; i < size; ++i) {
            if (loopEnters[i]) {
                cycleIncomings[i] = new TIntHashSet();
            }
            nonCycleIncomings[i] = new TIntArrayList();
            collapsedTo[i] = i;
        }
        for (ControlFlowGraph.Edge edge : this.dfsTree.back) {
            cycleIncomings[edge.to].add(edge.from);
        }
        for (ControlFlowGraph.Edge edge : this.dfsTree.nonBack) {
            nonCycleIncomings[edge.to].add(edge.from);
        }
        for (int w = size - 1; w >= 0; --w) {
            int top = 0;
            TIntHashSet p = cycleIncomings[w];
            if (p == null) continue;
            TIntIterator iter = p.iterator();
            while (iter.hasNext()) {
                queue[top++] = iter.next();
            }
            while (top > 0) {
                int x = queue[--top];
                TIntArrayList incoming = nonCycleIncomings[x];
                for (int i = 0; i < incoming.size(); ++i) {
                    int y1 = collapsedTo[incoming.getQuick(i)];
                    if (!this.dfsTree.isDescendant(y1, w)) {
                        return false;
                    }
                    if (y1 == w || !p.add(y1)) continue;
                    queue[top++] = y1;
                }
            }
            iter = p.iterator();
            while (iter.hasNext()) {
                collapsedTo[iter.next()] = w;
            }
        }
        return true;
    }
}

