/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.varScopeCanBeNarrowed.BaseConvertToLocalQuickFix;
import com.intellij.codeInspection.varScopeCanBeNarrowed.ParameterCanBeLocalInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.NotNullFunction;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterCanBeLocalInspection
extends ParameterCanBeLocalInspectionBase {
    @Override
    protected ConvertParameterToLocalQuickFix createFix() {
        return new ConvertParameterToLocalQuickFix();
    }

    public static class ConvertParameterToLocalQuickFix
    extends BaseConvertToLocalQuickFix<PsiParameter> {
        @Override
        protected PsiParameter getVariable(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "getVariable"));
            }
            return (PsiParameter)descriptor.getPsiElement().getParent();
        }

        @Override
        protected PsiElement applyChanges(final @NotNull Project project, final @NotNull String localName, final @Nullable PsiExpression initializer, final @NotNull PsiParameter parameter, final @NotNull Collection<PsiReference> references, boolean delete, final @NotNull NotNullFunction<PsiDeclarationStatement, PsiElement> action) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            if (localName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            if (references == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "applyChanges"));
            }
            PsiElement scope = parameter.getDeclarationScope();
            if (scope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiParameter[] parameters = method.getParameterList().getParameters();
                ArrayList<ParameterInfoImpl> info = new ArrayList<ParameterInfoImpl>();
                for (int i = 0; i < parameters.length; ++i) {
                    PsiParameter psiParameter = parameters[i];
                    if (psiParameter == parameter) continue;
                    info.add(new ParameterInfoImpl(i, psiParameter.getName(), psiParameter.getType()));
                }
                ParameterInfoImpl[] newParams = info.toArray(new ParameterInfoImpl[info.size()]);
                String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
                ChangeSignatureProcessor cp = new ChangeSignatureProcessor(project, method, false, visibilityModifier, method.getName(), method.getReturnType(), newParams){

                    @Override
                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        if (usages == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix$1", "performRefactoring"));
                        }
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                        PsiElement newDeclaration = ConvertParameterToLocalQuickFix.this.moveDeclaration(elementFactory, localName, parameter, initializer, (NotNullFunction<PsiDeclarationStatement, PsiElement>)action, references);
                        super.performRefactoring(usages);
                        BaseConvertToLocalQuickFix.positionCaretToDeclaration(project, newDeclaration.getContainingFile(), newDeclaration);
                    }
                };
                cp.run();
            }
            return null;
        }

        @Override
        @NotNull
        protected String suggestLocalName(@NotNull Project project, @NotNull PsiParameter parameter, @NotNull PsiCodeBlock scope) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "suggestLocalName"));
            }
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "suggestLocalName"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "suggestLocalName"));
            }
            String string = parameter.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/varScopeCanBeNarrowed/ParameterCanBeLocalInspection$ConvertParameterToLocalQuickFix", "suggestLocalName"));
            }
            return string;
        }
    }
}

