/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classFilesIndex.chainsSearch;

import com.intellij.compiler.classFilesIndex.chainsSearch.ChainCompletionStringUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.MethodChainsSearchUtil;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.classFilesIndex.chainsSearch.context.ContextRelevantStaticMethod;
import com.intellij.compiler.classFilesIndex.impl.MethodIncompleteSignature;
import com.intellij.compiler.classFilesIndex.impl.MethodsUsageIndexReader;
import com.intellij.compiler.classFilesIndex.impl.UsageIndexValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedRelevantStaticMethodSearcher {
    private final HashMap<MethodIncompleteSignature, PsiMethod> myCachedResolveResults = new HashMap();
    private final MethodsUsageIndexReader myIndexReader;
    private final ChainCompletionContext myCompletionContext;

    public CachedRelevantStaticMethodSearcher(ChainCompletionContext completionContext) {
        this.myIndexReader = MethodsUsageIndexReader.getInstance(completionContext.getProject());
        this.myCompletionContext = completionContext;
    }

    @NotNull
    public List<ContextRelevantStaticMethod> getRelevantStaticMethods(String resultQualifiedClassName, int minOccurrence) {
        if (resultQualifiedClassName == null || ChainCompletionStringUtil.isPrimitiveOrArrayOfPrimitives(resultQualifiedClassName) || this.myCompletionContext.getTarget().getClassQName().equals(resultQualifiedClassName)) {
            List<ContextRelevantStaticMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/CachedRelevantStaticMethodSearcher", "getRelevantStaticMethods"));
            }
            return list;
        }
        TreeSet<UsageIndexValue> indexValues = this.myIndexReader.getMethods(resultQualifiedClassName);
        if (!indexValues.isEmpty()) {
            int occurrences = 0;
            ArrayList<ContextRelevantStaticMethod> relevantMethods = new ArrayList<ContextRelevantStaticMethod>();
            for (UsageIndexValue indexValue : CachedRelevantStaticMethodSearcher.extractStaticMethods(indexValues)) {
                PsiMethod method;
                MethodIncompleteSignature methodInvocation = indexValue.getMethodIncompleteSignature();
                if (this.myCachedResolveResults.containsKey(methodInvocation)) {
                    method = this.myCachedResolveResults.get(methodInvocation);
                } else {
                    PsiMethod[] methods = this.myCompletionContext.resolveNotDeprecated(methodInvocation);
                    method = MethodChainsSearchUtil.getMethodWithMinNotPrimitiveParameters(methods, Collections.singleton(this.myCompletionContext.getTarget().getClassQName()));
                    this.myCachedResolveResults.put(methodInvocation, method);
                    if (method == null) {
                        List<ContextRelevantStaticMethod> list = Collections.emptyList();
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/CachedRelevantStaticMethodSearcher", "getRelevantStaticMethods"));
                        }
                        return list;
                    }
                }
                if (method == null) {
                    List<ContextRelevantStaticMethod> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/CachedRelevantStaticMethodSearcher", "getRelevantStaticMethods"));
                    }
                    return list;
                }
                if (!method.hasModifierProperty("public") || !CachedRelevantStaticMethodSearcher.isMethodValid(method, this.myCompletionContext, resultQualifiedClassName)) continue;
                occurrences += indexValue.getOccurrences();
                if (this.myCompletionContext.getResolveScope().contains(method.getContainingFile().getVirtualFile())) {
                    relevantMethods.add(new ContextRelevantStaticMethod(method, null));
                }
                if (occurrences < minOccurrence) continue;
                ArrayList<ContextRelevantStaticMethod> arrayList = relevantMethods;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/CachedRelevantStaticMethodSearcher", "getRelevantStaticMethods"));
                }
                return arrayList;
            }
        }
        List<ContextRelevantStaticMethod> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/classFilesIndex/chainsSearch/CachedRelevantStaticMethodSearcher", "getRelevantStaticMethods"));
        }
        return list;
    }

    private static List<UsageIndexValue> extractStaticMethods(TreeSet<UsageIndexValue> indexValues) {
        SmartList relevantStaticMethods = new SmartList();
        for (UsageIndexValue indexValue : indexValues) {
            if (!indexValue.getMethodIncompleteSignature().isStatic()) continue;
            relevantStaticMethods.add(indexValue);
        }
        return relevantStaticMethods;
    }

    private static boolean isMethodValid(@Nullable PsiMethod method, ChainCompletionContext completionContext, String targetTypeShortName) {
        if (method == null) {
            return false;
        }
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            PsiType type = parameter.getType();
            String shortClassName = CachedRelevantStaticMethodSearcher.typeAsShortString(type);
            if (targetTypeShortName.equals(shortClassName)) {
                return false;
            }
            if (ChainCompletionStringUtil.isShortNamePrimitiveOrArrayOfPrimitives(shortClassName) || completionContext.contains(type.getCanonicalText())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String typeAsShortString(PsiType type) {
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).getClassName();
        }
        if (type instanceof PsiPrimitiveType) {
            return type.getCanonicalText();
        }
        if (type instanceof PsiArrayType) {
            String componentTypeAsString = CachedRelevantStaticMethodSearcher.typeAsShortString(((PsiArrayType)type).getComponentType());
            if (componentTypeAsString == null) {
                return null;
            }
            return String.format("%s[]", componentTypeAsString);
        }
        return null;
    }
}

