/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.CompilerContentIterator;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.ExportableUserDataHolderBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OneProjectItemCompileScope
extends ExportableUserDataHolderBase
implements CompileScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.OneProjectItemCompileScope");
    private final Project myProject;
    private final VirtualFile myFile;
    private final String myUrl;

    public OneProjectItemCompileScope(Project project, VirtualFile file2) {
        this.myProject = project;
        this.myFile = file2;
        String url = file2.getUrl();
        this.myUrl = file2.isDirectory() ? url + "/" : url;
    }

    @NotNull
    public VirtualFile[] getFiles(FileType fileType, boolean inSourceOnly) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(1);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompilerContentIterator iterator = new CompilerContentIterator(fileType, (FileIndex)projectFileIndex, inSourceOnly, files);
        if (this.myFile.isDirectory()) {
            projectFileIndex.iterateContentUnderDirectory(this.myFile, (ContentIterator)iterator);
        } else {
            iterator.processFile(this.myFile);
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(files);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/OneProjectItemCompileScope", "getFiles"));
        }
        return virtualFileArray;
    }

    public boolean belongs(String url) {
        if (this.myFile.isDirectory()) {
            return FileUtil.startsWith((String)url, (String)this.myUrl);
        }
        return FileUtil.pathsEqual((String)url, (String)this.myUrl);
    }

    @NotNull
    public Module[] getAffectedModules() {
        Module module = ModuleUtil.findModuleForFile((VirtualFile)this.myFile, (Project)this.myProject);
        if (module == null) {
            LOG.error("Module is null for file " + this.myFile.getPresentableUrl());
            if (Module.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/OneProjectItemCompileScope", "getAffectedModules"));
            }
            return Module.EMPTY_ARRAY;
        }
        Module[] moduleArray = new Module[]{module};
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/OneProjectItemCompileScope", "getAffectedModules"));
        }
        return moduleArray;
    }
}

