/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StorageVirtualFileTracker;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RoamingTypeDisabled;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"7\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\tQ!\u0001E\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0011)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\r)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u001f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\t\u0001\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001\u0003\u0004\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\tA\"A\u0003\u0002\t\t!1\u0002\u0004\u0001\u0011Xe\t\u0001\u0014A\u000f\u0003X1fS&)\r\n\u0007!\tQ\"\u0001M\u0002\u0013\u0015!\u0011\u0001\u0003\u0002\u000e\u00051\u0005\u0001TA\u0005\u0006\t\u0005A1!\u0004\u0002\r\u0002a\u001d\u0011\"\u0002\u0003\u0002\u0011\u0011i!\u0001$\u0001\u0019\nE\u001b\u0011\u0001C\u0003&\u0017!\u0001R\"\u0001\r\t3\rA\t#D\u0001\u0019\u0004e\u0019\u0001\"E\u0007\u00021\u0007)\u0003\u0002\u0002\u0006\t$5\t\u0001DE\r\u0004\u0011Ki\u0011\u0001G\n&\u0011\u0011Q\u0001rE\u0007\u00021II2\u0001#\n\u000e\u0003a\u0019Re\u0001\u0005\u0015\u001b\u0005A\"#J\u0004\t*5\t\u00014A\r\u0004\u0011Ui\u0011\u0001g\u0001&;\u0011Q\u00012F\u0007\u000213Ir\u0001\u0003\f\u000e\u000b%\u0019A\u0011A\u0005\u000213Aj#G\u0002\t/5\t\u00014A\r\u0004\u0011_i\u0011\u0001\u0007\r\u001a\u0011\u0011\u0005\u0001\u0012G\u0007\u0006\u0013\r!\t!C\u0001\u00193a5R%\u0004\u0003\u000b\u0011gi\u0011\u0001\u0007\n\u001a\u0007!QR\"\u0001M\u001b3\u0011A)#\u0004\u0002\r\u0002a\u0019Re\u0002\u0005\u001c\u001b\u0005A\u001a!G\u0002\t85\t\u00014A\u0013\t\t-AA$D\u0001\u0019\u0004e\u0019\u0001\"F\u0007\u00021\u0007)S\u0002#\u000f\u000e\t%\u0011\u0011\"\u0001M\u001b1uIb\u0001c\u000f\u000e\t%\u0011\u0011\"\u0001M\u00021u)S\u0004#\u000f\u000e\u001b%)\u0011\u0002B\u0005\u0003\u0013\u0005A*\u0004G\u000f\n\u000b%!\u0011BA\u0005\u00021kAR\u0004\u0007\u0010\u001a\r!uR\u0002B\u0005\u0003\u0013\u0005A\u001a\u0001G\u000f\u001a\r!yR\u0002B\u0005\u0003\u0013\u0005A\u001a\u0001G\u000f&\t!}RB\u0001G\u00011\u000b)\u0013\u0002\u0002\u0006\t@5\u0011A\u0012\u0001M\u00033\rA\u0001%D\u0001\u0019\u0004\u0015\u0002\u0002\u0012I\u0007\u0003\u0019\u0003AJ\"G\u0002\tC5\t\u00014I\r\u0004\u0011\tj\u0011\u0001g\u0001\u001a\u0007!\u0015S\"\u0001\r$KE!!\u0002c\u0012\u000e\u00051\u0005\u00014A\r\u0004\u0011\u0005j\u0011\u0001g\u0011\u001a\u0007!\u0011S\"\u0001M\u00023\rA)%D\u0001\u0019G\u0015r\u0002\u0002J\u0007\u000213I2\u0001C\f\u000e\u0003a\r\u0011\u0004\u0002\u0003\u0002\u0011_i\u0011\u0001\u0007\r\u001a\u0011\u0011\t\u0001BF\u0007\u0006\u0013\r!\t!C\u0001\u0019\u001aa5\u0012\u0004\u0003C\u0002\u0011ciQ!C\u0002\u0005\u0002%\t\u0001$\u0007M\u0017K\u001dAI%D\u0001\u0019\u001ae\u0019\u0001\"J\u0007\u00021\u0017*S\u0001b\u0002\tM5\u0011A\u0012\u0001M\u0005K!!!\u0002#\u0014\u000e\u0003a\r\u0011d\u0001\u0005!\u001b\u0005A\u001a!J\t\u0005\u0017!9S\"\u0001\r\u00133\rAy%D\u0001\u0019\u0004e\u0019\u0001\u0002K\u0007\u00021\u0007IB\u0001#\u0015\u000e\u00051\u0005\u0001$K\u0013\f\u0011'j\u0011\u0001\u0007\n\u001a\u0007!)R\"\u0001M\u00023\rA!&D\u0001\u0019\u0004\u0015\u001a\u0001RK\u0007\u00021-J3\u0002B\"\t\u0011\ri!\u0001$\u0001\u0019\bE\u001bA!\u0002\u0001\u000e\u0005\u0011-\u0001BB\u0015\b\t\u0005c\u0002RB\u0007\u00021\u001d\t6!A\u0003\u0001S)!!\n\u0003E\b\u001b\u0005A\u0002\u0002\b\u0016R\u0007\ri!\u0001b\u0004\t\u0012%RA!\u0011\u0005\t\u00135!\u0011BA\u0005\u00021)A\u001a\"U\u0002\u0002\u000b\u0001I\u0003\u0002B!\t\u0011\ti!\u0001$\u0001\u0019\u0006E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002C\u0001\u000e\u0003a\r\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00165\t\u0001dC)\u0004\u0003\u0015\u0001\u0011&\u0004\u0003B\u0011!]QbB\u0005\u0003\u0013\u0005A\u001a!\u0003\u0002\n\u0003ae\u0001\u0004D)\u0004\u0003\u0015\u0001\u0011F\u0004\u0003D9!iQB\u0001G\u000117\t6aB\u0003\u0001\u001b\t!a\u0002#\b\u0012\u0005\u0011y\u0001rD\u0015\t\t\u0005C\u0001\u0002B\u0007\u0003\u0019\u0003AJ!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lcom/intellij/configurationStore/StateStorageManagerImpl;", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "rootTagName", "", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "virtualFileTracker", "Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "(Ljava/lang/String;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/components/ComponentManager;Lcom/intellij/configurationStore/StorageVirtualFileTracker;)V", "getComponentManager", "()Lcom/intellij/openapi/components/ComponentManager;", "isUseVfsListener", "Lcom/intellij/util/ThreeState;", "isUseXmlProlog", "", "()Z", "macros", "", "Lcom/intellij/configurationStore/StateStorageManagerImpl$Macro;", "storageLock", "Ljava/util/concurrent/locks/ReentrantLock;", "storages", "Lgnu/trove/THashMap;", "Lcom/intellij/openapi/components/StateStorage;", "streamProvider", "Lcom/intellij/configurationStore/StreamProvider;", "getStreamProvider", "()Lcom/intellij/configurationStore/StreamProvider;", "setStreamProvider", "(Lcom/intellij/configurationStore/StreamProvider;)V", "addMacro", "key", "expansion", "beforeElementLoaded", "", "element", "Lorg/jdom/Element;", "beforeElementSaved", "clearStorages", "collapseMacros", "path", "createStateStorage", "storageClass", "Ljava/lang/Class;", "collapsedPath", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "stateSplitter", "Lcom/intellij/openapi/components/StateSplitter;", "dataLoadedFromProvider", "storage", "Lcom/intellij/configurationStore/FileBasedStorage;", "expandMacro", "macro", "expandMacros", "getCachedFileStorages", "", "fileSpecs", "Lkotlin/Pair;", "changed", "deleted", "getMacroSubstitutor", "fileSpec", "getOldStorage", "component", "", "componentName", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getOldStorageSpec", "getOrCreateStorage", "getStateStorage", "storageSpec", "Lcom/intellij/openapi/components/Storage;", "getVirtualFileTracker", "normalizeFileSpec", "pathRenamed", "oldPath", "newPath", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "rename", "newName", "startExternalization", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager$ExternalizationSession;", "Companion", "Macro", "MyDirectoryStorage", "MyFileStorage"}, moduleName="configuration-store-impl")
public class StateStorageManagerImpl
implements StateStorageManager {
    private final List<Macro> macros;
    private final ReentrantLock storageLock;
    private final THashMap<String, StateStorage> storages;
    @Nullable
    private StreamProvider streamProvider;
    private ThreeState isUseVfsListener;
    private final String rootTagName;
    private final TrackingPathMacroSubstitutor pathMacroSubstitutor;
    @Nullable
    private final ComponentManager componentManager;
    private final StorageVirtualFileTracker virtualFileTracker;
    private static final Pattern MACRO_PATTERN;
    public static final Companion Companion;

    @Nullable
    public final StreamProvider getStreamProvider() {
        return this.streamProvider;
    }

    public final void setStreamProvider(@Nullable StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    protected boolean isUseXmlProlog() {
        return true;
    }

    @Override
    @Nullable
    public final TrackingPathMacroSubstitutor getMacroSubstitutor() {
        return this.pathMacroSubstitutor;
    }

    @Nullable
    public final StorageVirtualFileTracker getVirtualFileTracker() {
        return this.virtualFileTracker;
    }

    public final boolean addMacro(@NotNull String key, @NotNull String expansion) {
        String value;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)expansion, (String)"expansion");
        PreconditionsKt.assert((!StringsKt.isEmpty((CharSequence)key) ? 1 : 0) != 0);
        if (StringsKt.contains$default((CharSequence)expansion, (CharSequence)"\\", (boolean)false, (int)2)) {
            String message = "Macro " + key + " set to system-dependent expansion " + expansion;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw (Throwable)new IllegalArgumentException(message);
            }
            ComponentStoreImplKt.getLOG().warn(message);
            String string = FileUtilRt.toSystemIndependentName((String)expansion);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtilRt.toSystemIndependentName(expansion)");
            value = string;
        } else {
            value = expansion;
        }
        for (Macro macro : this.macros) {
            if (!key.equals(macro.getKey())) continue;
            macro.setValue(value);
            return false;
        }
        this.macros.add(new Macro(key, value));
        return true;
    }

    public void pathRenamed(@NotNull String oldPath, @NotNull String newPath, @Nullable VFileEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)oldPath, (String)"oldPath");
        Intrinsics.checkParameterIsNotNull((Object)newPath, (String)"newPath");
        for (Macro macro : this.macros) {
            if (!oldPath.equals(macro.getValue())) continue;
            macro.setValue(newPath);
        }
    }

    @Override
    @NotNull
    public final StateStorage getStateStorage(@NotNull Storage storageSpec) {
        Intrinsics.checkParameterIsNotNull((Object)storageSpec, (String)"storageSpec");
        Class clazz = JvmClassMappingKt.getJavaClass((KClass)Reflection.getOrCreateKotlinClass((Class)storageSpec.storageClass()));
        if (clazz == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out com.intellij.openapi.components.StateStorage>");
        }
        return this.getOrCreateStorage(storageSpec.file(), storageSpec.roamingType(), clazz, JvmClassMappingKt.getJavaClass((KClass)Reflection.getOrCreateKotlinClass((Class)storageSpec.stateSplitter())));
    }

    @NotNull
    protected String normalizeFileSpec(@NotNull String fileSpec) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        String path = FileUtilRt.toSystemIndependentName((String)fileSpec);
        if (StringsKt.endsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2)) {
            string = StringsKt.substring((String)path, (int)0, (int)(path.length() - 1));
        } else {
            String string2 = path;
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final StateStorage getOrCreateStorage(@NotNull String collapsedPath, @NotNull RoamingType roamingType, @NotNull Class<? extends StateStorage> storageClass, @NotNull Class<? extends StateSplitter> stateSplitter) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)collapsedPath, (String)"collapsedPath");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(storageClass, (String)"storageClass");
        Intrinsics.checkParameterIsNotNull(stateSplitter, (String)"stateSplitter");
        String normalizedCollapsedPath = this.normalizeFileSpec(collapsedPath);
        String key = Intrinsics.areEqual(storageClass, StateStorage.class) ? normalizedCollapsedPath : storageClass.getName();
        Lock lock = this.storageLock;
        $receiver$iv.lock();
        try {
            StateStorage storage2 = (StateStorage)this.storages.get((Object)key);
            if (storage2 == null) {
                storage2 = this.createStateStorage(storageClass, normalizedCollapsedPath, roamingType, stateSplitter);
                this.storages.put((Object)key, (Object)storage2);
            }
            StateStorage stateStorage = storage2;
            return stateStorage;
        }
        finally {
            $receiver$iv.unlock();
        }
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StateStorage getOrCreateStorage$default(StateStorageManagerImpl stateStorageManagerImpl, String string, RoamingType roamingType, Class clazz, Class clazz2, int n) {
        if ((n & 2) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 4) != 0) {
            clazz = StateStorage.class;
        }
        if ((n & 8) != 0) {
            clazz2 = StateSplitterEx.class;
        }
        return stateStorageManagerImpl.getOrCreateStorage(string, roamingType, clazz, clazz2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pair<Collection<FileBasedStorage>, Collection<FileBasedStorage>> getCachedFileStorages(@NotNull Collection<String> changed, @NotNull Collection<String> deleted) {
        Pair pair;
        Intrinsics.checkParameterIsNotNull(changed, (String)"changed");
        Intrinsics.checkParameterIsNotNull(deleted, (String)"deleted");
        Lock $receiver$iv = this.storageLock;
        $receiver$iv.lock();
        try {
            pair = new Pair(this.getCachedFileStorages(changed), this.getCachedFileStorages(deleted));
        }
        finally {
            $receiver$iv.unlock();
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<FileBasedStorage> getCachedFileStorages(@NotNull Collection<String> fileSpecs) {
        Intrinsics.checkParameterIsNotNull(fileSpecs, (String)"fileSpecs");
        if (fileSpecs.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Lock $receiver$iv = this.storageLock;
        $receiver$iv.lock();
        try {
            List result2 = null;
            for (String fileSpec : fileSpecs) {
                StateStorage storage2 = (StateStorage)this.storages.get((Object)this.normalizeFileSpec(fileSpec));
                if (!(storage2 instanceof FileBasedStorage)) continue;
                if (result2 == null) {
                    result2 = (List)new SmartList();
                }
                result2.add(storage2);
            }
            List list = result2;
            Collection collection = list != null ? (Collection)list : (Collection)CollectionsKt.emptyList();
            return collection;
        }
        finally {
            $receiver$iv.unlock();
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected StateStorage createStateStorage(@NotNull Class<? extends StateStorage> storageClass, @NotNull String collapsedPath, @NotNull RoamingType roamingType, @NotNull Class<? extends StateSplitter> stateSplitter) {
        block14: {
            Intrinsics.checkParameterIsNotNull(storageClass, (String)"storageClass");
            Intrinsics.checkParameterIsNotNull((Object)collapsedPath, (String)"collapsedPath");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            Intrinsics.checkParameterIsNotNull(stateSplitter, (String)"stateSplitter");
            if (Intrinsics.areEqual(storageClass, StateStorage.class) ^ true) {
                v0 = storageClass.getConstructors()[0];
                if (v0 == null) {
                    Intrinsics.throwNpe();
                }
                constructor = v0;
                constructor.setAccessible(true);
                v1 = new Object[2];
                v2 = this.componentManager;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                v1[0] = v2;
                v1[1] = this;
                v3 = constructor.newInstance(v1);
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.StateStorage");
                }
                return (StateStorage)v3;
            }
            if (!Intrinsics.areEqual((Object)this.isUseVfsListener, (Object)ThreeState.UNSURE)) break block14;
            if (this.streamProvider == null) ** GOTO lbl-1000
            v4 = this.streamProvider;
            if (v4 == null) {
                Intrinsics.throwNpe();
            }
            if (!v4.getEnabled()) lbl-1000:
            // 2 sources

            {
                v5 = true;
            } else {
                v5 = false;
            }
            v6 = ThreeState.fromBoolean((boolean)v5);
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"ThreeState.fromBoolean(s\u2026streamProvider!!.enabled)");
            this.isUseVfsListener = v6;
        }
        filePath = this.expandMacros(collapsedPath);
        if (Intrinsics.areEqual(stateSplitter, StateSplitter.class) ^ true && Intrinsics.areEqual(stateSplitter, StateSplitterEx.class) ^ true) {
            storage = new MyDirectoryStorage(this, new File(filePath), (StateSplitter)ReflectionUtil.newInstance(stateSplitter));
            v7 = this.virtualFileTracker;
            if (v7 != null) {
                v7.put(filePath, storage);
                v8 = Unit.INSTANCE;
            } else {
                v8 = null;
            }
            return storage;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && StringsKt.lastIndexOf$default((CharSequence)PathUtilRt.getFileName((String)filePath), (char)'.', (int)0, (boolean)false, (int)6) < 0) {
            throw (Throwable)new IllegalArgumentException("Extension is missing for storage file: " + filePath);
        }
        effectiveRoamingType = Intrinsics.areEqual((Object)roamingType, (Object)RoamingType.DEFAULT) != false && Intrinsics.areEqual((Object)collapsedPath, (Object)"$WORKSPACE_FILE$") != false ? RoamingType.DISABLED : roamingType;
        storage = new MyFileStorage(this, new File(filePath), collapsedPath, this.rootTagName, effectiveRoamingType, this.getMacroSubstitutor(collapsedPath), this.streamProvider);
        if (Intrinsics.areEqual((Object)this.isUseVfsListener, (Object)ThreeState.YES)) {
            v9 = this.virtualFileTracker;
            if (v9 != null) {
                v9.put(filePath, storage);
                v10 = Unit.INSTANCE;
            } else {
                v10 = null;
            }
        }
        return storage;
    }

    protected void beforeElementSaved(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    protected void beforeElementLoaded(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    protected void dataLoadedFromProvider(@NotNull FileBasedStorage storage2, @Nullable Element element) {
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rename(@NotNull String path, @NotNull String newName) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        Lock $receiver$iv = this.storageLock;
        $receiver$iv.lock();
        try {
            StateStorage stateStorage = StateStorageManagerImpl.getOrCreateStorage$default(this, this.collapseMacros(path), RoamingType.DEFAULT, null, null, 12);
            if (stateStorage == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.FileBasedStorage");
            }
            FileBasedStorage storage2 = (FileBasedStorage)stateStorage;
            VirtualFile file2 = storage2.getVirtualFile();
            try {
                if (file2 != null) {
                    file2.rename((Object)storage2, newName);
                } else if (Intrinsics.areEqual((Object)storage2.getFile().getName(), (Object)newName) ^ true) {
                    String expandedPath = this.expandMacros(path);
                    String parentPath = PathUtilRt.getParentPath((String)expandedPath);
                    storage2.setFile(null, new File(parentPath, newName));
                    this.pathRenamed(expandedPath, parentPath + "/" + newName, null);
                }
            }
            catch (IOException e) {
                ComponentStoreImplKt.getLOG().debug((Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $receiver$iv.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearStorages() {
        Lock $receiver$iv = this.storageLock;
        $receiver$iv.lock();
        try {
            try {
                if (this.virtualFileTracker != null) {
                    this.storages.forEachEntry(new TObjectObjectProcedure<K, V>(this){
                        final /* synthetic */ StateStorageManagerImpl this$0;

                        public final boolean execute(String collapsedPath, StateStorage storage2) {
                            StorageVirtualFileTracker storageVirtualFileTracker = StateStorageManagerImpl.access$getVirtualFileTracker$p(this.this$0);
                            String string = collapsedPath;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"collapsedPath");
                            storageVirtualFileTracker.remove(this.this$0.expandMacros(string));
                            return true;
                        }
                        {
                            this.this$0 = stateStorageManagerImpl;
                        }
                    });
                }
            }
            finally {
                this.storages.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $receiver$iv.unlock();
        }
    }

    @Nullable
    protected TrackingPathMacroSubstitutor getMacroSubstitutor(@NotNull String fileSpec) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        return this.pathMacroSubstitutor;
    }

    @Override
    @NotNull
    public String expandMacros(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Matcher matcher = StateStorageManagerImpl.Companion.getMACRO_PATTERN().matcher(path);
        block0: while (matcher.find()) {
            String m = matcher.group(1);
            for (Macro macro : this.macros) {
                if (!Intrinsics.areEqual((Object)macro.getKey(), (Object)m)) continue;
                continue block0;
            }
            throw (Throwable)new IllegalArgumentException("Unknown macro: " + m + " in storage file spec: " + path);
        }
        String expanded = path;
        for (Macro macro : this.macros) {
            String key = macro.component1();
            String value = macro.component2();
            Intrinsics.checkExpressionValueIsNotNull((Object)StringUtil.replace((String)expanded, (String)key, (String)value), (String)"StringUtil.replace(expanded, key, value)");
        }
        return expanded;
    }

    @NotNull
    public final String expandMacro(@NotNull String macro) {
        Intrinsics.checkParameterIsNotNull((Object)macro, (String)"macro");
        for (Macro macro2 : this.macros) {
            String key = macro2.component1();
            String value = macro2.component2();
            if (!Intrinsics.areEqual((Object)key, (Object)macro)) continue;
            return value;
        }
        throw (Throwable)new IllegalArgumentException("Unknown macro " + macro);
    }

    @NotNull
    public final String collapseMacros(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String result2 = path;
        for (Macro macro : this.macros) {
            String key = macro.component1();
            String value = macro.component2();
            Intrinsics.checkExpressionValueIsNotNull((Object)StringUtil.replace((String)result2, (String)value, (String)key), (String)"StringUtil.replace(result, value, key)");
        }
        return this.normalizeFileSpec(result2);
    }

    @Override
    @NotNull
    public final StateStorageManager.ExternalizationSession startExternalization() {
        return new StateStorageManager.ExternalizationSession(this){
            private final LinkedHashMap<StateStorage, StateStorage.ExternalizationSession> sessions;
            final /* synthetic */ StateStorageManagerImpl this$0;

            public void setState(@NotNull Storage[] storageSpecs, @NotNull Object component, @NotNull String componentName, @NotNull Object state) {
                Intrinsics.checkParameterIsNotNull((Object)storageSpecs, (String)"storageSpecs");
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Object object = component;
                if (!(object instanceof StateStorageChooserEx)) {
                    object = null;
                }
                StateStorageChooserEx stateStorageChooser = (StateStorageChooserEx)object;
                for (int i = 0; i < storageSpecs.length; ++i) {
                    Unit unit;
                    StateStorageChooserEx.Resolution resolution;
                    Storage storageSpec = storageSpecs[i];
                    if (stateStorageChooser == null) {
                        resolution = StateStorageChooserEx.Resolution.DO;
                    } else {
                        StateStorageChooserEx.Resolution resolution2 = stateStorageChooser.getResolution(storageSpec, StateStorageOperation.WRITE);
                        resolution = resolution2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)resolution2, (String)"stateStorageChooser.getR\u2026teStorageOperation.WRITE)");
                    }
                    StateStorageChooserEx.Resolution resolution3 = resolution;
                    if (Intrinsics.areEqual((Object)resolution3, (Object)StateStorageChooserEx.Resolution.SKIP)) continue;
                    StateStorage.ExternalizationSession externalizationSession = this.getExternalizationSession(this.this$0.getStateStorage(storageSpec));
                    if (externalizationSession != null) {
                        externalizationSession.setState(component, componentName, storageSpec.deprecated() || Intrinsics.areEqual((Object)resolution3, (Object)StateStorageChooserEx.Resolution.CLEAR) ? new Element("empty") : state);
                        unit = Unit.INSTANCE;
                        continue;
                    }
                    unit = null;
                }
            }

            /*
             * WARNING - void declaration
             */
            public void setStateInOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull Object state) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                StateStorage stateStorage = this.this$0.getOldStorage(component, componentName, StateStorageOperation.WRITE);
                if (stateStorage != null) {
                    Unit unit2;
                    void $receiver$iv;
                    StateStorage stateStorage2 = stateStorage;
                    StateStorage it = (StateStorage)$receiver$iv;
                    StateStorage.ExternalizationSession externalizationSession = this.getExternalizationSession(it);
                    if (externalizationSession != null) {
                        externalizationSession.setState(component, componentName, state);
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    unit = unit2;
                } else {
                    unit = null;
                }
            }

            private final StateStorage.ExternalizationSession getExternalizationSession(StateStorage storage2) {
                StateStorage.ExternalizationSession session = this.sessions.get(storage2);
                if (session == null && (session = storage2.startExternalization()) != null) {
                    this.sessions.put(storage2, session);
                }
                return session;
            }

            @NotNull
            public List<StateStorage.SaveSession> createSaveSessions() {
                if (this.sessions.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                List saveSessions = null;
                Collection<StateStorage.ExternalizationSession> externalizationSessions = this.sessions.values();
                for (StateStorage.ExternalizationSession session : externalizationSessions) {
                    StateStorage.SaveSession saveSession = session.createSaveSession();
                    if (saveSession == null) continue;
                    if (saveSessions == null) {
                        if (externalizationSessions.size() == 1) {
                            return CollectionsKt.listOf((Object)saveSession);
                        }
                        saveSessions = (List)new SmartList();
                    }
                    saveSessions.add(saveSession);
                }
                List list = ContainerUtil.notNullize((List)saveSessions);
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.notNullize(saveSessions)");
                return list;
            }
            {
                this.this$0 = $outer;
                this.sessions = new LinkedHashMap<K, V>();
            }
        };
    }

    @Override
    @Nullable
    public final StateStorage getOldStorage(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        String string = this.getOldStorageSpec(component, componentName, operation);
        if (string == null) {
            return null;
        }
        String oldStorageSpec = string;
        return StateStorageManagerImpl.getOrCreateStorage$default(this, oldStorageSpec, component instanceof RoamingTypeDisabled ? RoamingType.DISABLED : RoamingType.DEFAULT, null, null, 12);
    }

    @Nullable
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        return null;
    }

    @Nullable
    public final ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public StateStorageManagerImpl(@NotNull String rootTagName, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @Nullable ComponentManager componentManager, @Nullable StorageVirtualFileTracker virtualFileTracker) {
        Intrinsics.checkParameterIsNotNull((Object)rootTagName, (String)"rootTagName");
        this.rootTagName = rootTagName;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
        this.componentManager = componentManager;
        this.virtualFileTracker = virtualFileTracker;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLockFreeCopyOnWriteList()");
        this.macros = list;
        this.storageLock = new ReentrantLock();
        this.storages = new THashMap();
        this.isUseVfsListener = this.componentManager == null ? ThreeState.NO : ThreeState.UNSURE;
    }

    public /* synthetic */ StateStorageManagerImpl(String string, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, ComponentManager componentManager, StorageVirtualFileTracker storageVirtualFileTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        if ((n & 4) != 0) {
            componentManager = null;
        }
        if ((n & 8) != 0) {
            storageVirtualFileTracker = Companion.createDefaultVirtualTracker(componentManager);
        }
        this(string, trackingPathMacroSubstitutor, componentManager, storageVirtualFileTracker);
    }

    static {
        Companion = com.intellij.configurationStore.StateStorageManagerImpl$Companion.INSTANCE;
        MACRO_PATTERN = Pattern.compile("(\\$[^\\$]*\\$)");
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\tA!\u0002\u0003B\t1\u0001\u0011$\u0001M\u0001C+I1\u0001C\u0001\u000e\u0003a\r\u0011b\u0001\u0005\u0003\u001b\u0005A\u001a!U\u0002\u0002\u0011\u000b)K\u0001B\"\b\u0011\u0017i\u0011\u0001g\u0001&\n\u0011\u0019u\u0001\u0003\u0004\u000e\u0003a\rQU\u0004\u0003D\u0007!5Q\"\u0001\r\u00013\u0011!\u0011\u0001C\u0001\u000e\u0003a\r\u0011\u0004\u0002\u0003\u0002\u0011\ti\u0011\u0001g\u0001*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011Aa\u0001E\u0004S5!1\t\b\u0005\u0003\u001b\u0005A\u001a!U\u0002\b\u000b\u0001i!\u0001\u0002\u0003\t\bE\u0011A\u0011\u0002\u0005\u0006"}, strings={"Lcom/intellij/configurationStore/StateStorageManagerImpl$Macro;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getValue", "setValue", "(Ljava/lang/String;)V", "component1", "component2", "copy"}, moduleName="configuration-store-impl")
    private static final class Macro {
        @NotNull
        private final String key;
        @NotNull
        private String value;

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public final void setValue(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.value = string;
        }

        public Macro(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final Macro copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new Macro(key, value);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Macro copy$default(Macro macro, String string, String string2, int n) {
            if ((n & 1) != 0) {
                string = macro.key;
            }
            if ((n & 2) != 0) {
                string2 = macro.value;
            }
            return macro.copy(string, string2);
        }

        public String toString() {
            return "Macro(key=" + this.key + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.key;
            String string2 = this.value;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Macro)) break block3;
                    Macro macro = (Macro)object;
                    if (!Intrinsics.areEqual((Object)this.key, (Object)macro.key) || !Intrinsics.areEqual((Object)this.value, (Object)macro.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"#\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\t\u0005a\u0001!G\u0001\u0019\u0002e\t\u0001$AQ\u0010\u0013\rA\u0019!D\u0001\u0019\u0005%\u0019\u0001RA\u0007\u00021\rIA\u0001\"\u0001\t\b5\t\u0001\u0004B)\u0004\u0003!%\u0011F\u0003\u0003L\u0011!\rQ\"\u0001\r\u0003#\u000e!Q\u0001A\u0007\u0003\t\u0015AY\u0001"}, strings={"Lcom/intellij/configurationStore/StateStorageManagerImpl$MyDirectoryStorage;", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "file", "Ljava/io/File;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "(Lcom/intellij/configurationStore/StateStorageManagerImpl;Ljava/io/File;Lcom/intellij/openapi/components/StateSplitter;)V", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;"}, moduleName="configuration-store-impl")
    private static final class MyDirectoryStorage
    extends DirectoryBasedStorage
    implements StorageVirtualFileTracker.TrackedStorage {
        @NotNull
        private final StateStorageManagerImpl storageManager;

        @Override
        @NotNull
        public StateStorageManagerImpl getStorageManager() {
            return this.storageManager;
        }

        public MyDirectoryStorage(@NotNull StateStorageManagerImpl storageManager2, @NotNull File file2, @NotNull StateSplitter splitter) {
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)splitter, (String)"splitter");
            super(file2, splitter, storageManager2.pathMacroSubstitutor);
            this.storageManager = storageManager2;
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"M\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q!\u0001\u0003\u0003\u000b\u0005A\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\t\u0005a\u0001!G\u0001\u0019\u0002e\t\u0001$AQ#\u0013\rA\u0019!D\u0001\u0019\u0005%\u0019\u0001RA\u0007\u00021\rI1\u0001c\u0002\u000e\u0003a!\u0011b\u0001E\u0005\u001b\u0005AB!C\u0002\t\u000b5\t\u00014B\u0005\u0006\t\u0005Aa!\u0004\u0002\r\u0002a5\u0011\"\u0002\u0003\u0002\u0011\u001di!\u0001$\u0001\u0019\u0010E\u001b\u0011\u0001\u0003\u0005&\u0011\u0011Q\u0001bC\u0007\u00021/I2\u0001\u0003\u0007\u000e\u0003aeQ\u0005\u0003\u0003\u000b\u00115i\u0011\u0001g\u0006\u001a\u0007!aQ\"\u0001M\rK%!!\u0002c\u0007\u000e\u0003a]\u0011\u0004\u0002\u0005\r\u001b\ta\t\u0001'\u0007*\u0015\u0011Q\u0005\u0002#\u0005\u000e\u0003aIADK)\u0004\u00075\u0011A\u0011\u0003E\nS)!1\n\u0003E\u0002\u001b\u0005A\"!U\u0002\u0005\u000b\u0001i!\u0001\u0002\u0006\t\u0016\u0001"}, strings={"Lcom/intellij/configurationStore/StateStorageManagerImpl$MyFileStorage;", "Lcom/intellij/configurationStore/FileBasedStorage;", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "file", "Ljava/io/File;", "fileSpec", "", "rootElementName", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "pathMacroManager", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Lcom/intellij/configurationStore/StateStorageManagerImpl;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/configurationStore/StreamProvider;)V", "isUseXmlProlog", "", "()Z", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "beforeElementLoaded", "", "element", "Lorg/jdom/Element;", "beforeElementSaved", "dataLoadedFromProvider"}, moduleName="configuration-store-impl")
    private static final class MyFileStorage
    extends FileBasedStorage
    implements StorageVirtualFileTracker.TrackedStorage {
        @NotNull
        private final StateStorageManagerImpl storageManager;

        @Override
        protected boolean isUseXmlProlog() {
            return this.getStorageManager().isUseXmlProlog();
        }

        @Override
        protected void beforeElementSaved(@NotNull Element element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.getStorageManager().beforeElementSaved(element);
            super.beforeElementSaved(element);
        }

        @Override
        protected void beforeElementLoaded(@NotNull Element element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            this.getStorageManager().beforeElementLoaded(element);
            super.beforeElementLoaded(element);
        }

        @Override
        protected void dataLoadedFromProvider(@Nullable Element element) {
            this.getStorageManager().dataLoadedFromProvider(this, element);
        }

        @Override
        @NotNull
        public StateStorageManagerImpl getStorageManager() {
            return this.storageManager;
        }

        public MyFileStorage(@NotNull StateStorageManagerImpl storageManager2, @NotNull File file2, @NotNull String fileSpec, @NotNull String rootElementName, @NotNull RoamingType roamingType, @Nullable TrackingPathMacroSubstitutor pathMacroManager, @Nullable StreamProvider provider) {
            Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkParameterIsNotNull((Object)rootElementName, (String)"rootElementName");
            Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
            super(file2, fileSpec, rootElementName, pathMacroManager, roamingType, provider);
            this.storageManager = storageManager2;
        }

        public /* synthetic */ MyFileStorage(StateStorageManagerImpl stateStorageManagerImpl, File file2, String string, String string2, RoamingType roamingType, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                trackingPathMacroSubstitutor = null;
            }
            if ((n & 0x40) != 0) {
                streamProvider = null;
            }
            this(stateStorageManagerImpl, file2, string, string2, roamingType, trackingPathMacroSubstitutor, streamProvider);
        }
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tAaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K%AA!\u0004\u0002\r\u0002a%\u0011\u0004\u0002\u0005\u0006\u001b\ta\t\u0001g\u0003*\u001f\u0011\t\u0005\u0002c\u0001\u000e\u000bA\u0015QC\u0001G\u00011\tA\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0007!\u001d\u0001"}, strings={"Lcom/intellij/configurationStore/StateStorageManagerImpl$Companion;", "", "()V", "MACRO_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getMACRO_PATTERN", "()Ljava/util/regex/Pattern;", "createDefaultVirtualTracker", "Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;"}, moduleName="configuration-store-impl")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final Pattern getMACRO_PATTERN() {
            return MACRO_PATTERN;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final StorageVirtualFileTracker createDefaultVirtualTracker(@Nullable ComponentManager componentManager) {
            StorageVirtualFileTracker storageVirtualFileTracker;
            ComponentManager componentManager2 = componentManager;
            if (Intrinsics.areEqual((Object)componentManager2, null)) {
                storageVirtualFileTracker = null;
            } else if (componentManager2 instanceof Application) {
                MessageBus messageBus = ((Application)componentManager).getMessageBus();
                Intrinsics.checkExpressionValueIsNotNull((Object)messageBus, (String)"componentManager.messageBus");
                storageVirtualFileTracker = new StorageVirtualFileTracker(messageBus);
            } else {
                void var3_3;
                StorageVirtualFileTracker tracker;
                StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStateStorageManager();
                if (!(stateStorageManager instanceof StateStorageManagerImpl)) {
                    stateStorageManager = null;
                }
                StateStorageManagerImpl stateStorageManagerImpl = (StateStorageManagerImpl)stateStorageManager;
                StorageVirtualFileTracker storageVirtualFileTracker2 = tracker = stateStorageManagerImpl != null ? stateStorageManagerImpl.virtualFileTracker : null;
                if (tracker != null) {
                    Disposer.register((Disposable)((Disposable)componentManager), (Disposable)new Disposable(tracker, componentManager){
                        final /* synthetic */ StorageVirtualFileTracker $tracker;
                        final /* synthetic */ ComponentManager $componentManager;

                        public final void dispose() {
                            this.$tracker.remove((Function1<? super StorageVirtualFileTracker.TrackedStorage, Boolean>)((Function1)new Function1<StorageVirtualFileTracker.TrackedStorage, Boolean>(this){
                                final /* synthetic */ createDefaultVirtualTracker.1 this$0;

                                public final boolean invoke(@NotNull StorageVirtualFileTracker.TrackedStorage it) {
                                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                    return Intrinsics.areEqual((Object)it.getStorageManager().getComponentManager(), (Object)this.this$0.$componentManager);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }));
                        }
                        {
                            this.$tracker = storageVirtualFileTracker;
                            this.$componentManager = componentManager;
                        }
                    });
                }
                storageVirtualFileTracker = var3_3;
            }
            return storageVirtualFileTracker;
        }

        private Companion() {
            INSTANCE = this;
        }

        static {
            new Companion();
        }
    }
}

