/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0004\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\u0001A\u0002A\r\u00021\u0003i\nQCQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&\t\u0011\t\u0001RB\u0007\u00021\u001d)3\u0002c\u0004\u000e\u0003a9\u0011d\u0001\u0005\t\u001b\u0005A:!G\u0002\t\u00125\t\u0001\u0004B\u0013\u000e\u0011%i\u0011\u0001G\u0004\u001a\u0013!MQbB\u0005\u0003\u0013\u0005AB!\u0003\u0002\n\u0003a)\u0001DC\u0013\b\u0011%i\u0011\u0001G\u0004\u001a\u0007!AQ\"\u0001M\u0004S5!\u0011\t\u0003E\u0003\u001b\u001dI!!C\u0001\u0019\b%\u0011\u0011\"\u0001\r\u00051\r\t6!A\u0003\u0001S%!\u0019\t\bE\u0005\u001b\u0005AR\u0001H\u0001!\u0003E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002C\u0001\u000e\u0003a\r\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\f5\t\u0001DB)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "(Lcom/intellij/util/messages/MessageBus;)V", "filePathToStorage", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "hasDirectoryBasedStorages", "", "vfsListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addVfsChangesListener", "", "put", "path", "storage", "remove", "processor", "Lkotlin/Function1;", "TrackedStorage"}, moduleName="configuration-store-impl")
public final class StorageVirtualFileTracker {
    private final ConcurrentMap<String, TrackedStorage> filePathToStorage;
    private volatile boolean hasDirectoryBasedStorages;
    private final AtomicBoolean vfsListenerAdded;
    private final MessageBus messageBus;

    public final void put(@NotNull String path, @NotNull TrackedStorage storage2) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
        this.filePathToStorage.put(path, storage2);
        if (storage2 instanceof DirectoryBasedStorage) {
            this.hasDirectoryBasedStorages = true;
        }
        if (this.vfsListenerAdded.compareAndSet(false, true)) {
            this.addVfsChangesListener();
        }
    }

    public final void remove(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.filePathToStorage.remove(path);
    }

    public final void remove(@NotNull Function1<? super TrackedStorage, Boolean> processor2) {
        Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
        Iterator iterator = this.filePathToStorage.values().iterator();
        Iterator iterator2 = CollectionsKt.iterator(iterator);
        while (iterator2.hasNext()) {
            TrackedStorage storage2;
            TrackedStorage trackedStorage = storage2 = (TrackedStorage)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)trackedStorage, (String)"storage");
            if (!((Boolean)processor2.invoke((Object)trackedStorage)).booleanValue()) continue;
            iterator.remove();
        }
    }

    private final void addVfsChangesListener() {
        this.messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(this){
            final /* synthetic */ StorageVirtualFileTracker this$0;

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkParameterIsNotNull(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    ComponentManager componentManager;
                    String path;
                    StateStorage storage2;
                    if (vFileEvent instanceof VFilePropertyChangeEvent && "name".equals(((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) {
                        String oldPath = ((VFilePropertyChangeEvent)vFileEvent).getOldPath();
                        storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).remove(oldPath);
                        if (storage2 != null) {
                            StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).put(((VFilePropertyChangeEvent)vFileEvent).getPath(), storage2);
                            if (storage2 instanceof FileBasedStorage) {
                                ((FileBasedStorage)storage2).setFile(null, new File(((VFilePropertyChangeEvent)vFileEvent).getPath()));
                            }
                            StateStorageManagerImpl stateStorageManagerImpl = ((TrackedStorage)storage2).getStorageManager();
                            String string = oldPath;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oldPath");
                            String string2 = ((VFilePropertyChangeEvent)vFileEvent).getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"event.path");
                            stateStorageManagerImpl.pathRenamed(string, string2, vFileEvent);
                        }
                    } else {
                        path = vFileEvent.getPath();
                        storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).get(path);
                        if (storage2 == null && StorageVirtualFileTracker.access$getHasDirectoryBasedStorages$p(this.this$0) && StringUtilRt.endsWithIgnoreCase((CharSequence)path, (CharSequence)".xml")) {
                            storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).get(VfsUtil.getParentDir((String)path));
                        }
                    }
                    if (storage2 == null) continue;
                    path = vFileEvent;
                    if (path instanceof VFileMoveEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(null, new File(((VFileMoveEvent)vFileEvent).getPath()));
                        }
                    } else if (path instanceof VFileCreateEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(((VFileCreateEvent)vFileEvent).getFile(), null);
                        }
                    } else if (path instanceof VFileDeleteEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(null, null);
                        } else {
                            StateStorage stateStorage = storage2;
                            if (stateStorage == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.DirectoryBasedStorage");
                            }
                            ((DirectoryBasedStorage)stateStorage).setVirtualDir(null);
                        }
                    } else if (path instanceof VFileCopyEvent) continue;
                    if (((TrackedStorage)storage2).getStorageManager().getComponentManager() == null) {
                        Intrinsics.throwNpe();
                    }
                    ((StateStorageManager.IStorageManagerListener)componentManager.getMessageBus().syncPublisher(StateStorageManager.STORAGE_TOPIC)).storageFileChanged(vFileEvent, storage2, componentManager);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public StorageVirtualFileTracker(@NotNull MessageBus messageBus) {
        Intrinsics.checkParameterIsNotNull((Object)messageBus, (String)"messageBus");
        this.messageBus = messageBus;
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap()");
        this.filePathToStorage = concurrentMap;
        this.vfsListenerAdded = new AtomicBoolean();
    }

    @NotNull
    public static final /* synthetic */ ConcurrentMap access$getFilePathToStorage$p(StorageVirtualFileTracker $this) {
        return $this.filePathToStorage;
    }

    public static final /* synthetic */ boolean access$getHasDirectoryBasedStorages$p(StorageVirtualFileTracker $this) {
        return $this.hasDirectoryBasedStorages;
    }

    public static final /* synthetic */ void access$setHasDirectoryBasedStorages$p(StorageVirtualFileTracker $this, boolean bl) {
        $this.hasDirectoryBasedStorages = bl;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!\u0001\u00034\u0019\u0001I\u0012\u0001'\u0001*\u0013\u0011\u0019\u0006\u0002C\u0001\u000e\u0003a\r\u0011kA\u0002\u000e\u0005\u0011\u0011\u0001R\u0001"}, strings={"Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "Lcom/intellij/openapi/components/StateStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;"}, moduleName="configuration-store-impl")
    public static interface TrackedStorage
    extends StateStorage {
        @NotNull
        public StateStorageManagerImpl getStorageManager();
    }
}

