/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class ChangeCorrector {
    @NotNull
    private final List<? extends CorrectableData> myData1;
    @NotNull
    private final List<? extends CorrectableData> myData2;
    private final int myLength1;
    private final int myLength2;
    @NotNull
    private final FairDiffIterable myChanges;
    @NotNull
    protected final ProgressIndicator myIndicator;
    @NotNull
    protected final DiffIterableUtil.ChangeBuilder myBuilder;
    private int offset1;
    private int offset2;

    public ChangeCorrector(@NotNull List<? extends CorrectableData> data1, @NotNull List<? extends CorrectableData> data2, int length1, int length2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
        if (data1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data1", "com/intellij/diff/comparison/ChangeCorrector", "<init>"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data2", "com/intellij/diff/comparison/ChangeCorrector", "<init>"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ChangeCorrector", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ChangeCorrector", "<init>"));
        }
        this.offset1 = 0;
        this.offset2 = 0;
        this.myData1 = data1;
        this.myData2 = data2;
        this.myLength1 = length1;
        this.myLength2 = length2;
        this.myChanges = changes;
        this.myIndicator = indicator;
        this.myBuilder = new DiffIterableUtil.ChangeBuilder(length1, length2);
    }

    @NotNull
    public FairDiffIterable build() {
        this.execute();
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(this.myBuilder.finish());
        if (fairDiffIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ChangeCorrector", "build"));
        }
        return fairDiffIterable;
    }

    protected void execute() {
        for (Range ch : this.myChanges.iterateUnchanged()) {
            int count = ch.end1 - ch.start1;
            for (int i = 0; i < count; ++i) {
                CorrectableData data1 = this.myData1.get(ch.start1 + i);
                CorrectableData data2 = this.myData2.get(ch.start2 + i);
                this.matchedPair(data1.getOriginalIndex(), data2.getOriginalIndex());
            }
        }
        this.matchGap(this.offset1, this.myLength1, this.offset2, this.myLength2);
    }

    private void matchedPair(int off1, int off2) {
        this.matchGap(this.offset1, off1, this.offset2, off2);
        this.myBuilder.markEqual(off1, off2);
        this.offset1 = off1 + 1;
        this.offset2 = off2 + 1;
    }

    protected abstract void matchGap(int var1, int var2, int var3, int var4);

    public static class SmartLineChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final List<ByLine.Line> myLines1;
        @NotNull
        private final List<ByLine.Line> myLines2;

        public SmartLineChangeCorrector(@NotNull List<ByLine.LineWrapper> newLines1, @NotNull List<ByLine.LineWrapper> newLines2, @NotNull List<ByLine.Line> lines1, @NotNull List<ByLine.Line> lines2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            if (newLines1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLines1", "com/intellij/diff/comparison/ChangeCorrector$SmartLineChangeCorrector", "<init>"));
            }
            if (newLines2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLines2", "com/intellij/diff/comparison/ChangeCorrector$SmartLineChangeCorrector", "<init>"));
            }
            if (lines1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines1", "com/intellij/diff/comparison/ChangeCorrector$SmartLineChangeCorrector", "<init>"));
            }
            if (lines2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines2", "com/intellij/diff/comparison/ChangeCorrector$SmartLineChangeCorrector", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ChangeCorrector$SmartLineChangeCorrector", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ChangeCorrector$SmartLineChangeCorrector", "<init>"));
            }
            super(newLines1, newLines2, lines1.size(), lines2.size(), changes, indicator);
            this.myLines1 = lines1;
            this.myLines2 = lines2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            Range expand = TrimUtil.expand(this.myLines1, this.myLines2, start1, start2, end1, end2);
            List<ByLine.Line> inner1 = this.myLines1.subList(expand.start1, expand.end1);
            List<ByLine.Line> inner2 = this.myLines2.subList(expand.start2, expand.end2);
            FairDiffIterable innerChanges = DiffIterableUtil.diff(inner1, inner2, this.myIndicator);
            this.myBuilder.markEqual(start1, start2, expand.start1, expand.start2);
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.myBuilder.markEqual(expand.start1 + chunk.start1, expand.start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
            this.myBuilder.markEqual(expand.end1, expand.end2, end1, end2);
        }
    }

    public static class DefaultCharChangeCorrector
    extends ChangeCorrector {
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;

        public DefaultCharChangeCorrector(@NotNull List<ByChar.Char> chars1, @NotNull List<ByChar.Char> chars2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull FairDiffIterable changes, @NotNull ProgressIndicator indicator) {
            if (chars1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars1", "com/intellij/diff/comparison/ChangeCorrector$DefaultCharChangeCorrector", "<init>"));
            }
            if (chars2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars2", "com/intellij/diff/comparison/ChangeCorrector$DefaultCharChangeCorrector", "<init>"));
            }
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ChangeCorrector$DefaultCharChangeCorrector", "<init>"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ChangeCorrector$DefaultCharChangeCorrector", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/comparison/ChangeCorrector$DefaultCharChangeCorrector", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ChangeCorrector$DefaultCharChangeCorrector", "<init>"));
            }
            super(chars1, chars2, text1.length(), text2.length(), changes, indicator);
            this.myText1 = text1;
            this.myText2 = text2;
        }

        @Override
        protected void matchGap(int start1, int end1, int start2, int end2) {
            Range expand = TrimUtil.expand(this.myText1, this.myText2, start1, start2, end1, end2);
            CharSequence inner1 = this.myText1.subSequence(expand.start1, expand.end1);
            CharSequence inner2 = this.myText2.subSequence(expand.start2, expand.end2);
            FairDiffIterable innerChanges = ByChar.compare(inner1, inner2, this.myIndicator);
            this.myBuilder.markEqual(start1, start2, expand.start1, expand.start2);
            for (Range chunk : innerChanges.iterateUnchanged()) {
                this.myBuilder.markEqual(expand.start1 + chunk.start1, expand.start2 + chunk.start2, chunk.end1 - chunk.start1);
            }
            this.myBuilder.markEqual(expand.end1, expand.end2, end1, end2);
        }
    }

    public static interface CorrectableData {
        public int getOriginalIndex();
    }
}

