/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.CommonBundle;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.BinaryMergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryMergeRequestImpl
extends BinaryMergeRequest {
    private static final Logger LOG = Logger.getInstance(BinaryMergeRequestImpl.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileContent myFile;
    @NotNull
    private final List<DiffContent> myContents;
    @NotNull
    private final List<byte[]> myByteContents;
    @NotNull
    private final byte[] myOriginalContent;
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;
    @Nullable
    private final Consumer<MergeResult> myApplyCallback;

    public BinaryMergeRequestImpl(@Nullable Project project, @NotNull FileContent file2, @NotNull byte[] originalContent, @NotNull List<DiffContent> contents, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/requests/BinaryMergeRequestImpl", "<init>"));
        }
        if (originalContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalContent", "com/intellij/diff/requests/BinaryMergeRequestImpl", "<init>"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/requests/BinaryMergeRequestImpl", "<init>"));
        }
        if (byteContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteContents", "com/intellij/diff/requests/BinaryMergeRequestImpl", "<init>"));
        }
        if (contentTitles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentTitles", "com/intellij/diff/requests/BinaryMergeRequestImpl", "<init>"));
        }
        assert (byteContents.size() == 3);
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project;
        this.myFile = file2;
        this.myOriginalContent = originalContent;
        this.myByteContents = byteContents;
        this.myContents = contents;
        this.myTitle = title;
        this.myTitles = contentTitles;
        this.myApplyCallback = applyCallback;
    }

    @NotNull
    public FileContent getOutputContent() {
        FileContent fileContent = this.myFile;
        if (fileContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/BinaryMergeRequestImpl", "getOutputContent"));
        }
        return fileContent;
    }

    @NotNull
    public List<DiffContent> getContents() {
        List<DiffContent> list = this.myContents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/BinaryMergeRequestImpl", "getContents"));
        }
        return list;
    }

    @NotNull
    public List<byte[]> getByteContents() {
        List<byte[]> list = this.myByteContents;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/BinaryMergeRequestImpl", "getByteContents"));
        }
        return list;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        List<String> list = this.myTitles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/requests/BinaryMergeRequestImpl", "getContentTitles"));
        }
        return list;
    }

    public void applyResult(@NotNull MergeResult result2) {
        byte[] applyContent;
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/requests/BinaryMergeRequestImpl", "applyResult"));
        }
        switch (result2) {
            case CANCEL: {
                applyContent = this.myOriginalContent;
                break;
            }
            case LEFT: {
                applyContent = (byte[])ThreeSide.LEFT.select(this.myByteContents);
                break;
            }
            case RIGHT: {
                applyContent = (byte[])ThreeSide.RIGHT.select(this.myByteContents);
                break;
            }
            case RESOLVED: {
                applyContent = null;
                break;
            }
            default: {
                throw new IllegalArgumentException(result2.toString());
            }
        }
        if (applyContent != null) {
            new WriteCommandAction.Simple(null, new PsiFile[0]){

                protected void run() throws Throwable {
                    try {
                        VirtualFile file2 = BinaryMergeRequestImpl.this.myFile.getFile();
                        if (!DiffUtil.makeWritable(BinaryMergeRequestImpl.this.myProject, file2)) {
                            throw new IOException("File is read-only: " + file2.getPresentableName());
                        }
                        file2.setBinaryContent(applyContent);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                        Messages.showErrorDialog((Project)BinaryMergeRequestImpl.this.myProject, (String)"Can't apply result", (String)CommonBundle.getErrorTitle());
                    }
                }
            }.execute();
        }
        if (this.myApplyCallback != null) {
            this.myApplyCallback.consume((Object)result2);
        }
    }
}

