/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.side.OnesideDiffViewer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnesideBinaryDiffViewer
extends OnesideDiffViewer<BinaryEditorHolder> {
    public static final Logger LOG = Logger.getInstance(OnesideBinaryDiffViewer.class);

    public OnesideBinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/OnesideBinaryDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/OnesideBinaryDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/binary/OnesideBinaryDiffViewer", "performRediff"));
        }
        JComponent notification = (JComponent)this.getSide().select((Object)DiffNotifications.createRemovedContent(), (Object)DiffNotifications.createInsertedContent());
        Runnable runnable2 = this.applyNotification(notification);
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/OnesideBinaryDiffViewer", "performRediff"));
        }
        return runnable2;
    }

    @NotNull
    private Runnable applyNotification(final @Nullable JComponent notification) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                OnesideBinaryDiffViewer.this.clearDiffPresentation();
                if (notification != null) {
                    OnesideBinaryDiffViewer.this.myPanel.addNotification(notification);
                }
            }
        };
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/OnesideBinaryDiffViewer", "applyNotification"));
        }
        return runnable2;
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
    }

    @NotNull
    FileEditor getEditor() {
        FileEditor fileEditor = ((BinaryEditorHolder)this.getEditorHolder()).getEditor();
        if (fileEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/OnesideBinaryDiffViewer", "getEditor"));
        }
        return fileEditor;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/OnesideBinaryDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/OnesideBinaryDiffViewer", "canShowRequest"));
        }
        return OnesideDiffViewer.canShowRequest(context, request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }
}

