/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConsoleHistoryModel
extends SimpleModificationTracker {
    private final ConsoleHistoryModel myMasterModel;
    private int myIndex;
    private final LinkedList<String> myEntries;

    ConsoleHistoryModel(ConsoleHistoryModel masterModel) {
        this.myMasterModel = masterModel;
        this.myEntries = this.myMasterModel == null ? new LinkedList() : this.myMasterModel.myEntries;
        this.resetIndex();
    }

    ConsoleHistoryModel copy() {
        return new ConsoleHistoryModel(this);
    }

    public synchronized void resetEntries(@NotNull List<String> entries) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/execution/console/ConsoleHistoryModel", "resetEntries"));
        }
        this.myEntries.clear();
        this.myEntries.addAll(entries.subList(0, Math.min(entries.size(), this.getMaxHistorySize())));
        this.incModificationCount();
    }

    public synchronized void addToHistory(@Nullable String statement) {
        if (StringUtil.isEmptyOrSpaces((String)statement)) {
            return;
        }
        int maxHistorySize = this.getMaxHistorySize();
        this.myEntries.remove(statement);
        int size = this.myEntries.size();
        if (size >= maxHistorySize && size > 0) {
            this.myEntries.removeFirst();
        }
        this.myEntries.addLast(statement);
        this.incModificationCount();
    }

    public void incModificationCount() {
        this.resetIndex();
        super.incModificationCount();
    }

    protected synchronized void resetIndex() {
        this.myIndex = this.myEntries.size();
    }

    public int getMaxHistorySize() {
        return UISettings.getInstance().CONSOLE_COMMAND_HISTORY_LIMIT;
    }

    public synchronized void removeFromHistory(String statement) {
        this.myEntries.remove(statement);
        this.incModificationCount();
    }

    public synchronized List<String> getEntries() {
        return new ArrayList<String>(this.myEntries);
    }

    public synchronized int getHistorySize() {
        return this.myEntries.size();
    }

    @Nullable
    public synchronized String getHistoryNext() {
        if (this.myIndex >= 0) {
            --this.myIndex;
        }
        return this.getCurrentEntry();
    }

    @Nullable
    public synchronized String getHistoryPrev() {
        if (this.myIndex <= this.myEntries.size() - 1) {
            ++this.myIndex;
        }
        return this.getCurrentEntry();
    }

    public synchronized boolean hasHistory(boolean next) {
        return next ? this.myIndex > 0 : this.myIndex < this.myEntries.size() - 1;
    }

    synchronized String getCurrentEntry() {
        return this.myIndex >= 0 && this.myIndex < this.myEntries.size() ? this.myEntries.get(this.myIndex) : null;
    }

    synchronized int getCurrentIndex() {
        return this.myIndex;
    }
}

