/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.NotNull;

public class SelectedTextFormatter {
    private Project myProject;
    private Editor myEditor;
    private PsiFile myFile;
    private final String myTextBefore;
    private final int mySelectionStart;
    private final int mySelectionEnd;

    public SelectedTextFormatter(Project project, Editor editor, PsiFile file2) {
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file2;
        this.myTextBefore = this.myEditor.getSelectionModel().getSelectedText();
        this.mySelectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        this.mySelectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
    }

    public void restoreSelectedText() {
        final Document document = this.myEditor.getDocument();
        final int start = this.myEditor.getSelectionModel().getSelectionStart();
        final int end = this.myEditor.getSelectionModel().getSelectionEnd();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(SelectedTextFormatter.this.myProject, new Runnable(){

                    @Override
                    public void run() {
                        document.replaceString(start, end, (CharSequence)SelectedTextFormatter.this.myTextBefore);
                    }
                }, "Configure code style on selected fragment: restore text before", null);
            }
        });
        this.myEditor.getSelectionModel().setSelection(this.mySelectionStart, this.mySelectionEnd);
    }

    void reformatSelectedText(@NotNull CodeStyleSettings reformatSettings) {
        if (reformatSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reformatSettings", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "reformatSelectedText"));
        }
        SelectionModel model = this.myEditor.getSelectionModel();
        if (model.hasSelection()) {
            try {
                CodeStyleSettingsManager.getInstance((Project)this.myProject).setTemporarySettings(reformatSettings);
                SelectedTextFormatter.reformatRange(this.myFile, this.getSelectedRange());
            }
            finally {
                CodeStyleSettingsManager.getInstance((Project)this.myProject).dropTemporarySettings();
            }
        }
    }

    void reformatWholeFile() {
        SelectedTextFormatter.reformatRange(this.myFile, this.myFile.getTextRange());
    }

    private static void reformatRange(final @NotNull PsiFile file2, final @NotNull TextRange range) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "reformatRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "reformatRange"));
        }
        final Project project = file2.getProject();
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        CodeStyleManager.getInstance((Project)project).reformatText(file2, range.getStartOffset(), range.getEndOffset());
                    }
                });
            }
        }, "Reformat", null);
    }

    @NotNull
    TextRange getSelectedRange() {
        SelectionModel model = this.myEditor.getSelectionModel();
        int start = model.getSelectionStart();
        int end = model.getSelectionEnd();
        TextRange textRange = TextRange.create((int)start, (int)end);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/contextConfiguration/SelectedTextFormatter", "getSelectedRange"));
        }
        return textRange;
    }
}

