/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.lang.Language;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RelatedItemLineMarkerGotoAdapter
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/actions/RelatedItemLineMarkerGotoAdapter", "getItems"));
        }
        ArrayList<PsiElement> parents = new ArrayList<PsiElement>();
        HashSet<Language> languages = new HashSet<Language>();
        for (PsiElement current = context; current != null; current = current.getParent()) {
            parents.add(current);
            languages.add(current.getLanguage());
            if (current instanceof PsiFile) break;
        }
        ArrayList<LineMarkerProvider> providers = new ArrayList<LineMarkerProvider>();
        for (Language language : languages) {
            providers.addAll(LineMarkersPass.getMarkerProviders(language, context.getProject()));
        }
        ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>();
        for (LineMarkerProvider provider : providers) {
            if (!(provider instanceof RelatedItemLineMarkerProvider)) continue;
            ArrayList<RelatedItemLineMarkerInfo> markers = new ArrayList<RelatedItemLineMarkerInfo>();
            RelatedItemLineMarkerProvider relatedItemLineMarkerProvider = (RelatedItemLineMarkerProvider)provider;
            for (PsiElement parent : parents) {
                ContainerUtil.addIfNotNull((Object)relatedItemLineMarkerProvider.getLineMarkerInfo(parent), markers);
            }
            relatedItemLineMarkerProvider.collectNavigationMarkers(parents, markers, true);
            RelatedItemLineMarkerGotoAdapter.addItemsForMarkers(markers, items);
        }
        ArrayList<GotoRelatedItem> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/RelatedItemLineMarkerGotoAdapter", "getItems"));
        }
        return arrayList;
    }

    private static void addItemsForMarkers(List<RelatedItemLineMarkerInfo> markers, List<GotoRelatedItem> result2) {
        HashSet addedFiles = new HashSet();
        for (RelatedItemLineMarkerInfo marker : markers) {
            Collection items = marker.createGotoRelatedItems();
            for (GotoRelatedItem item : items) {
                PsiFile file2;
                PsiElement element = item.getElement();
                if (element instanceof PsiFile && addedFiles.contains(file2 = (PsiFile)element)) continue;
                if (element != null) {
                    ContainerUtil.addIfNotNull((Object)element.getContainingFile(), addedFiles);
                }
                result2.add(item);
            }
        }
    }
}

