/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.customize;

import com.intellij.ide.actions.CreateDesktopEntryAction;
import com.intellij.ide.customize.AbstractCustomizeWizardStep;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CustomizeDesktopEntryStep
extends AbstractCustomizeWizardStep {
    private final JCheckBox myCreateEntryCheckBox = new JCheckBox(ActionsBundle.message((String)"action.CreateDesktopEntry.description", (Object[])new Object[0]));
    private final JCheckBox myGlobalEntryCheckBox = new JCheckBox("For all users");

    public CustomizeDesktopEntryStep(String iconPath) {
        this.setLayout(new BorderLayout());
        JPanel panel = CustomizeDesktopEntryStep.createBigButtonPanel(CustomizeDesktopEntryStep.createSmallBorderLayout(), this.myCreateEntryCheckBox, EmptyRunnable.INSTANCE);
        panel.setBorder(CustomizeDesktopEntryStep.createSmallEmptyBorder());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setOpaque(false);
        GridBag gbc = new GridBag().setDefaultAnchor(17).setDefaultFill(2).setDefaultWeightX(1.0);
        this.myCreateEntryCheckBox.setOpaque(false);
        buttonPanel.add((Component)this.myCreateEntryCheckBox, gbc.nextLine());
        this.myGlobalEntryCheckBox.setOpaque(false);
        gbc.nextLine().insets.left = UIUtil.PANEL_REGULAR_INSETS.left;
        buttonPanel.add((Component)this.myGlobalEntryCheckBox, gbc);
        panel.add((Component)buttonPanel, "North");
        JLabel label = new JLabel(IconLoader.getIcon((String)iconPath));
        label.setVerticalAlignment(1);
        panel.add((Component)label, "Center");
        this.add((Component)panel, "Center");
        this.myCreateEntryCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CustomizeDesktopEntryStep.this.myGlobalEntryCheckBox.setEnabled(CustomizeDesktopEntryStep.this.myCreateEntryCheckBox.isSelected());
                CustomizeDesktopEntryStep.this.myGlobalEntryCheckBox.setSelected(CustomizeDesktopEntryStep.this.myCreateEntryCheckBox.isSelected() && !PathManager.getHomePath().startsWith("/home"));
            }
        });
        this.myCreateEntryCheckBox.setSelected(true);
    }

    public static boolean isAvailable() {
        return CreateDesktopEntryAction.isAvailable();
    }

    @Override
    public boolean beforeOkAction() {
        if (this.myCreateEntryCheckBox.isSelected()) {
            try {
                CreateDesktopEntryAction.createDesktopEntry(null, (ProgressIndicator)new EmptyProgressIndicator(), this.myGlobalEntryCheckBox.isSelected());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected String getTitle() {
        return "Desktop Entry";
    }

    @Override
    protected String getHTMLHeader() {
        return "<html><body><h2>Create Desktop Entry</h2>&nbsp;</body></html>";
    }

    @Override
    protected String getHTMLFooter() {
        return "Desktop entry can be created later in Tools | Create Desktop Entry...";
    }
}

