/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnmarkRootAction
extends MarkRootActionBase {
    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module, @NotNull MarkRootActionBase.RootsSelection selection) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/projectView/actions/UnmarkRootAction", "doUpdate"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkRootAction", "doUpdate"));
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && !selection.mySelectedExcludeRoots.isEmpty() && selection.mySelectedDirectories.isEmpty() && selection.mySelectedRoots.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText("Cancel Exclusion");
            return;
        }
        super.doUpdate(e, module, selection);
        Set<ModuleSourceRootEditHandler<?>> selectedRootHandlers = UnmarkRootAction.getHandlersForSelectedRoots(selection);
        if (!selectedRootHandlers.isEmpty()) {
            String text;
            if (selectedRootHandlers.size() == 1) {
                ModuleSourceRootEditHandler<?> handler2 = selectedRootHandlers.iterator().next();
                text = "Unmark as " + handler2.getRootTypeName() + " " + StringUtil.pluralize((String)"Root", (int)selection.mySelectedRoots.size());
            } else {
                text = "Unmark Roots";
            }
            e.getPresentation().setText(text);
        }
    }

    @NotNull
    private static Set<ModuleSourceRootEditHandler<?>> getHandlersForSelectedRoots(@NotNull MarkRootActionBase.RootsSelection selection) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkRootAction", "getHandlersForSelectedRoots"));
        }
        HashSet selectedRootHandlers = new HashSet();
        for (SourceFolder root : selection.mySelectedRoots) {
            ContainerUtil.addIfNotNull((Collection)selectedRootHandlers, ModuleSourceRootEditHandler.getEditHandler(root.getRootType()));
        }
        HashSet hashSet = selectedRootHandlers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/actions/UnmarkRootAction", "getHandlersForSelectedRoots"));
        }
        return hashSet;
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkRootAction", "isEnabled"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectView/actions/UnmarkRootAction", "isEnabled"));
        }
        return selection.mySelectedDirectories.isEmpty() && !UnmarkRootAction.getHandlersForSelectedRoots(selection).isEmpty();
    }

    @Override
    protected void modifyRoots(VirtualFile file2, ContentEntry entry) {
        for (ExcludeFolder excludeFolder : entry.getExcludeFolders()) {
            if (!file2.equals(excludeFolder.getFile())) continue;
            entry.removeExcludeFolder(excludeFolder);
            break;
        }
    }
}

