/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.ui.SimpleTextAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModuleNode
extends ProjectViewNode<Module>
implements NavigatableWithText {
    protected AbstractModuleNode(Project project, Module module, ViewSettings viewSettings) {
        super(project, (Object)module, viewSettings);
    }

    public void update(PresentationData presentation) {
        if (((Module)this.getValue()).isDisposed()) {
            this.setValue(null);
            return;
        }
        presentation.setPresentableText(((Module)this.getValue()).getName());
        if (this.showModuleNameInBold()) {
            presentation.addText(((Module)this.getValue()).getName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        presentation.setIcon(ModuleType.get((Module)((Module)this.getValue())).getIcon());
    }

    protected boolean showModuleNameInBold() {
        return true;
    }

    public String getTestPresentation() {
        return "Module";
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        List<VirtualFile> list = Arrays.asList(ModuleRootManager.getInstance((Module)((Module)this.getValue())).getContentRoots());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/AbstractModuleNode", "getRoots"));
        }
        return list;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        VirtualFile testee;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/AbstractModuleNode", "contains"));
        }
        Module module = (Module)this.getValue();
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (file2.getFileSystem() instanceof JarFileSystem) {
            testee = JarFileSystem.getInstance().getVirtualFileForJar(file2);
            if (testee == null) {
                return false;
            }
        } else {
            testee = file2;
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)testee, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public String getToolTip() {
        Module module = (Module)this.getValue();
        return ModuleType.get((Module)module).getName();
    }

    public void navigate(boolean requestFocus) {
        Module module = (Module)this.getValue();
        if (module != null) {
            ProjectSettingsService.getInstance(this.myProject).openModuleSettings(module);
        }
    }

    public String getNavigateActionText(boolean focusEditor) {
        return "Open Module Settings";
    }

    public boolean canNavigate() {
        return ProjectSettingsService.getInstance(this.myProject).canOpenModuleSettings() && this.getValue() != null;
    }
}

