/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.impl.ProjectViewSelectInTarget;
import com.intellij.ide.scopeView.ScopeViewPane;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePaneSelectInTarget
extends ProjectViewSelectInTarget {
    public ScopePaneSelectInTarget(Project project) {
        super(project);
    }

    @Override
    public String toString() {
        return SelectInManager.SCOPE;
    }

    @Override
    public boolean canSelect(PsiFileSystemItem fileSystemItem) {
        if (!super.canSelect(fileSystemItem)) {
            return false;
        }
        if (!(fileSystemItem instanceof PsiFile)) {
            return false;
        }
        return this.getContainingScope((PsiFile)fileSystemItem) != null;
    }

    @Nullable
    private NamedScope getContainingScope(PsiFile file2) {
        DependencyValidationManager scopesHolder = DependencyValidationManager.getInstance((Project)this.myProject);
        for (NamedScope scope : ScopeViewPane.getShownScopes(this.myProject)) {
            PackageSet packageSet = scope.getValue();
            if (packageSet == null || !packageSet.contains(file2, (NamedScopesHolder)scopesHolder)) continue;
            return scope;
        }
        return null;
    }

    @Override
    public void select(PsiElement element, boolean requestFocus) {
        if (this.getSubId() == null) {
            NamedScope scope = this.getContainingScope(element.getContainingFile());
            if (scope == null) {
                return;
            }
            this.setSubId(scope.getName());
        }
        super.select(element, requestFocus);
    }

    public String getMinorViewId() {
        return "Scope";
    }

    public float getWeight() {
        return 6.5f;
    }

    @Override
    protected boolean canWorkWithCustomObjects() {
        return false;
    }

    @Override
    public boolean isSubIdSelectable(@NotNull String subId, @NotNull SelectInContext context) {
        PackageSet packageSet;
        if (subId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subId", "com/intellij/ide/scopeView/ScopePaneSelectInTarget", "isSubIdSelectable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/scopeView/ScopePaneSelectInTarget", "isSubIdSelectable"));
        }
        PsiFileSystemItem file2 = this.getContextPsiFile(context);
        if (!(file2 instanceof PsiFile)) {
            return false;
        }
        NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)subId);
        PackageSet packageSet2 = packageSet = scope != null ? scope.getValue() : null;
        if (packageSet == null) {
            return false;
        }
        NamedScopesHolder holder = NamedScopesHolder.getHolder((Project)this.myProject, (String)subId, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)this.myProject));
        return packageSet.contains((PsiFile)file2, holder);
    }
}

