/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiElement;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="StructureViewFactory", storages={@Storage(file="$WORKSPACE_FILE$")})
public final class StructureViewFactoryImpl
extends StructureViewFactoryEx
implements PersistentStateComponent<State> {
    private final Project myProject;
    private StructureViewWrapperImpl myStructureViewWrapperImpl;
    private State myState = new State();
    private Runnable myRunWhenInitialized = null;
    private static final NotNullLazyValue<MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension>> myExtensions = new NotNullLazyValue<MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension>>(){

        @NotNull
        protected MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension> compute() {
            StructureViewExtension[] extensions;
            MultiValuesMap map = new MultiValuesMap();
            for (StructureViewExtension extension : extensions = (StructureViewExtension[])Extensions.getExtensions(StructureViewExtension.EXTENSION_POINT_NAME)) {
                map.put(extension.getType(), (Object)extension);
            }
            MultiValuesMap multiValuesMap = map;
            if (multiValuesMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl$1", "compute"));
            }
            return multiValuesMap;
        }
    };
    private final MultiValuesMap<Class<? extends PsiElement>, StructureViewExtension> myImplExtensions = new MultiValuesMap();

    public StructureViewFactoryImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public StructureViewWrapper getStructureViewWrapper() {
        return this.myStructureViewWrapperImpl;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "getState"));
        }
        return state;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public void initToolWindow(ToolWindowEx toolWindow) {
        this.myStructureViewWrapperImpl = new StructureViewWrapperImpl(this.myProject, toolWindow);
        if (this.myRunWhenInitialized != null) {
            this.myRunWhenInitialized.run();
            this.myRunWhenInitialized = null;
        }
    }

    @Override
    @NotNull
    public Collection<StructureViewExtension> getAllExtensions(@NotNull Class<? extends PsiElement> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "getAllExtensions"));
        }
        Collection result2 = this.myImplExtensions.get(type);
        if (result2 == null) {
            MultiValuesMap map = (MultiValuesMap)myExtensions.getValue();
            for (Class registeredType : map.keySet()) {
                if (!ReflectionUtil.isAssignable((Class)registeredType, type)) continue;
                Collection extensions = map.get((Object)registeredType);
                for (StructureViewExtension extension : extensions) {
                    this.myImplExtensions.put(type, (Object)extension);
                }
            }
            result2 = this.myImplExtensions.get(type);
            if (result2 == null) {
                List<StructureViewExtension> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "getAllExtensions"));
                }
                return list;
            }
        }
        Collection collection = result2;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "getAllExtensions"));
        }
        return collection;
    }

    @Override
    public void setActiveAction(String name, boolean state) {
        Collection<String> activeActions = this.collectActiveActions();
        if (state) {
            activeActions.add(name);
        } else {
            activeActions.remove(name);
        }
        this.myState.ACTIVE_ACTIONS = StructureViewFactoryImpl.toString(activeActions);
    }

    private static String toString(Collection<String> activeActions) {
        return StringUtil.join(activeActions, (String)",");
    }

    private Collection<String> collectActiveActions() {
        return ContainerUtil.newLinkedHashSet((Object[])this.myState.ACTIVE_ACTIONS.split(","));
    }

    @Override
    public boolean isActionActive(String name) {
        return this.collectActiveActions().contains(name);
    }

    @Override
    public void runWhenInitialized(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "runWhenInitialized"));
        }
        if (this.myStructureViewWrapperImpl != null) {
            runnable2.run();
        } else {
            this.myRunWhenInitialized = runnable2;
        }
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull StructureViewModel treeModel, @NotNull Project project) {
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "createStructureView"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "createStructureView"));
        }
        StructureView structureView = this.createStructureView(fileEditor, treeModel, project, true);
        if (structureView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "createStructureView"));
        }
        return structureView;
    }

    @NotNull
    public StructureView createStructureView(FileEditor fileEditor, @NotNull StructureViewModel treeModel, @NotNull Project project, boolean showRootNode) {
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "createStructureView"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "createStructureView"));
        }
        StructureViewComponent structureViewComponent = new StructureViewComponent(fileEditor, treeModel, project, showRootNode);
        if (structureViewComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/structureView/impl/StructureViewFactoryImpl", "createStructureView"));
        }
        return structureViewComponent;
    }

    public static class State {
        public boolean AUTOSCROLL_MODE = true;
        public boolean AUTOSCROLL_FROM_SOURCE = false;
        public String ACTIVE_ACTIONS = "";
    }
}

