/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf;

import com.intellij.ide.ui.laf.IdeaBlueMetalTheme;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import java.awt.Font;
import java.io.File;
import java.util.HashSet;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import org.jetbrains.annotations.NotNull;

public class IntelliJLaf
extends DarculaLaf {
    @Override
    public String getName() {
        return "IntelliJ";
    }

    @Override
    protected String getPrefix() {
        return "intellijlaf";
    }

    @Override
    protected DefaultMetalTheme createMetalTheme() {
        return new IdeaBlueMetalTheme();
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults defaults = super.getDefaults();
        if (SystemInfo.isMacOSYosemite) {
            IntelliJLaf.installMacOSXFonts(defaults);
        }
        return defaults;
    }

    private static void installMacOSXFonts(UIDefaults defaults) {
        String face = "HelveticaNeue-Regular";
        LafManagerImpl.initFontDefaults(defaults, face, 13);
        for (Object key : new HashSet(defaults.keySet())) {
            FontUIResource font;
            Object value = defaults.get(key);
            if (!(value instanceof FontUIResource) || !(font = (FontUIResource)value).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key.toString().contains("Menu")) continue;
            defaults.put(key, new FontUIResource(face, font.getStyle(), font.getSize()));
        }
        FontUIResource uiFont11 = new FontUIResource("HelveticaNeue-Medium", 0, 11);
        defaults.put("TableHeader.font", uiFont11);
        FontUIResource buttonFont = new FontUIResource("HelveticaNeue-Medium", 0, 13);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = new FontUIResource("Lucida Grande", 0, 14);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
        defaults.put("PasswordField.font", defaults.getFont("TextField.font"));
    }

    @NotNull
    private static FontUIResource getFont(String yosemite, String elCapitan, int size, int style) {
        if (SystemInfo.isMacOSElCapitan && elCapitan != null) {
            FontUIResource fontUIResource;
            block4: {
                try {
                    Font sfFont = Font.createFont(0, new File("/System/Library/Fonts/" + elCapitan + ".otf"));
                    fontUIResource = new FontUIResource(sfFont.deriveFont((float)size + 0.0f));
                    if (fontUIResource != null) break block4;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/IntelliJLaf", "getFont"));
            }
            return fontUIResource;
        }
        FontUIResource fontUIResource = new FontUIResource(yosemite, style, size);
        if (fontUIResource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/laf/IntelliJLaf", "getFont"));
        }
        return fontUIResource;
    }

    public static boolean isGraphite() {
        try {
            return Foundation.invoke((String)"NSColor", (String)"currentControlTint", (Object[])new Object[0]).intValue() == 6;
        }
        catch (Exception e) {
            return false;
        }
    }
}

