/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.PatternUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class GotoLineNumberDialog
extends DialogWrapper {
    private JTextField myField;
    private JTextField myOffsetField;
    private final Editor myEditor;
    private final Pattern myPattern = PatternUtil.compileSafe((String)"\\s*(\\d+)\\s*(?:[,:]?\\s*(\\d+)?)?\\s*", null);

    public GotoLineNumberDialog(Project project, Editor editor) {
        super(project, true);
        this.myEditor = editor;
        this.setTitle("Go to Line");
        this.init();
    }

    protected void doOKAction() {
        LogicalPosition position = this.getLogicalPosition();
        if (position == null) {
            return;
        }
        this.myEditor.getCaretModel().removeSecondaryCarets();
        this.myEditor.getCaretModel().moveToLogicalPosition(position);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        this.myEditor.getSelectionModel().removeSelection();
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEditor.getContentComponent(), true);
        super.doOKAction();
    }

    @Nullable
    private LogicalPosition getLogicalPosition() {
        Matcher m = this.myPattern.matcher(this.getText());
        if (!m.matches()) {
            return null;
        }
        int l = StringUtil.parseInt((String)m.group(1), (int)-1);
        int c = StringUtil.parseInt((String)m.group(2), (int)-1);
        return l > 0 ? new LogicalPosition(l - 1, Math.max(0, c - 1)) : null;
    }

    private static boolean isInternal() {
        return ApplicationManagerEx.getApplicationEx().isInternal();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myField;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    private String getText() {
        return this.myField.getText();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 0, 8, 8);
        gbConstraints.fill = 3;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 13;
        JLabel label = new JLabel("Line [:column]:");
        panel.add((Component)label, gbConstraints);
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        class MyTextField
        extends JTextField {
            public MyTextField() {
                super("");
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(200, d.height);
            }
        }
        this.myField = new MyTextField();
        panel.add((Component)this.myField, gbConstraints);
        LogicalPosition position = this.myEditor.getCaretModel().getLogicalPosition();
        this.myField.setText(String.format("%d:%d", position.line + 1, position.column + 1));
        if (GotoLineNumberDialog.isInternal()) {
            gbConstraints.gridy = 1;
            gbConstraints.weightx = 0.0;
            gbConstraints.weighty = 1.0;
            gbConstraints.anchor = 13;
            JLabel offsetLabel = new JLabel("Offset:");
            panel.add((Component)offsetLabel, gbConstraints);
            gbConstraints.fill = 1;
            gbConstraints.weightx = 1.0;
            this.myOffsetField = new MyTextField();
            panel.add((Component)this.myOffsetField, gbConstraints);
            this.myOffsetField.setText(String.valueOf(this.myEditor.getCaretModel().getOffset()));
            DocumentAdapter valueSync = new DocumentAdapter(){
                boolean inSync;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void textChanged(DocumentEvent e) {
                    if (this.inSync) {
                        return;
                    }
                    this.inSync = true;
                    String s = "<invalid>";
                    JTextComponent f = null;
                    try {
                        if (e.getDocument() == GotoLineNumberDialog.this.myField.getDocument()) {
                            f = GotoLineNumberDialog.this.myOffsetField;
                            LogicalPosition p = GotoLineNumberDialog.this.getLogicalPosition();
                            s = p == null ? s : String.valueOf(GotoLineNumberDialog.this.myEditor.logicalPositionToOffset(p));
                        } else {
                            f = GotoLineNumberDialog.this.myField;
                            int offset = StringUtil.parseInt((String)GotoLineNumberDialog.this.myOffsetField.getText(), (int)-1);
                            LogicalPosition p = offset >= 0 ? GotoLineNumberDialog.this.myEditor.offsetToLogicalPosition(Math.min(GotoLineNumberDialog.this.myEditor.getDocument().getTextLength() - 1, offset)) : null;
                            s = p == null ? s : String.format("%d:%d", p.line + 1, p.column + 1);
                        }
                        f.setText(s);
                    }
                    catch (IndexOutOfBoundsException ignored) {
                        if (f != null) {
                            f.setText(s);
                        }
                    }
                    finally {
                        this.inSync = false;
                    }
                }
            };
            this.myField.getDocument().addDocumentListener((DocumentListener)valueSync);
            this.myOffsetField.getDocument().addDocumentListener((DocumentListener)valueSync);
        }
        return panel;
    }
}

