/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.AbnormalCommandTerminationException;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.command.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;

class CommandProcessorImpl
extends CoreCommandProcessor {
    CommandProcessorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishCommand(Project project, Object command, Throwable throwable) {
        boolean failed;
        if (this.myCurrentCommand != command) {
            return;
        }
        try {
            if (throwable instanceof AbnormalCommandTerminationException) {
                AbnormalCommandTerminationException rollback = (AbnormalCommandTerminationException)throwable;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new RuntimeException((Throwable)rollback);
                }
                failed = true;
            } else if (throwable != null) {
                failed = true;
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                CommandLog.LOG.error(throwable);
            } else {
                failed = false;
            }
        }
        finally {
            super.finishCommand(project, command, throwable);
        }
        if (failed) {
            if (project != null) {
                FileEditor editor = new FocusBasedCurrentEditorProvider().getCurrentEditor();
                UndoManager undoManager = UndoManager.getInstance((Project)project);
                if (undoManager.isUndoAvailable(editor)) {
                    undoManager.undo(editor);
                }
            }
            Messages.showErrorDialog((Project)project, (String)"Cannot perform operation. Too complex, sorry.", (String)"Failed to Perform Operation");
        }
    }

    @Override
    public void markCurrentCommandAsGlobal(Project project) {
        CommandProcessorImpl.getUndoManager(project).markCurrentCommandAsGlobal();
    }

    private static UndoManagerImpl getUndoManager(Project project) {
        return (UndoManagerImpl)(project != null ? UndoManager.getInstance((Project)project) : UndoManager.getGlobalInstance());
    }

    @Override
    public void addAffectedDocuments(Project project, Document ... docs) {
        if (docs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docs", "com/intellij/openapi/command/impl/CommandProcessorImpl", "addAffectedDocuments"));
        }
        CommandProcessorImpl.getUndoManager(project).addAffectedDocuments(docs);
    }

    @Override
    public void addAffectedFiles(Project project, VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/command/impl/CommandProcessorImpl", "addAffectedFiles"));
        }
        CommandProcessorImpl.getUndoManager(project).addAffectedFiles(files);
    }
}

