/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasePasteHandler
extends EditorWriteActionHandler {
    protected Transferable myTransferable;

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/BasePasteHandler", "isEnabledForCaret"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/openapi/editor/actions/BasePasteHandler", "isEnabledForCaret"));
        }
        return !editor.isViewer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        this.myTransferable = this.getContentsToPaste(editor, dataContext);
        try {
            super.doExecute(editor, caret, dataContext);
        }
        finally {
            this.myTransferable = null;
        }
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (this.myTransferable != null) {
            EditorCopyPasteHelper.getInstance().pasteTransferable(editor, this.myTransferable);
        }
    }

    protected Transferable getContentsToPaste(Editor editor, DataContext dataContext) {
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return EditorModificationUtil.getContentsToPasteToEditor((Producer)producer);
    }
}

