/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483648)
public class ProjectDataServiceImpl
extends AbstractProjectDataService<ProjectData, Project> {
    @NotNull
    public Key<ProjectData> getTargetDataKey() {
        Key key = ProjectKeys.PROJECT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<ProjectData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single project but got %d: %s", toImport.size(), toImport));
        }
        DataNode<ProjectData> node = toImport.iterator().next();
        assert (projectData == node.getData());
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, node)) {
            return;
        }
        if (!project.getName().equals(projectData.getInternalName())) {
            ProjectDataServiceImpl.renameProject(projectData.getInternalName(), projectData.getOwner(), project);
        }
    }

    private static void renameProject(final @NotNull String newName, final @NotNull ProjectSystemId externalSystemId, final @NotNull Project project) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl", "renameProject"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl", "renameProject"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataServiceImpl", "renameProject"));
        }
        if (!(project instanceof ProjectEx) || newName.equals(project.getName())) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                String oldName = project.getName();
                ((ProjectEx)project).setProjectName(newName);
                ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)externalSystemId).getPublisher().onProjectRenamed(oldName, newName);
            }
        });
    }
}

