/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileTypeUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final String GROUP_ID = "file-type";

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/FileTypeUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(final @NotNull Project project) throws CollectUsagesException {
        FileType[] registeredFileTypes;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileTypes/FileTypeUsagesCollector", "getProjectUsages"));
        }
        final HashSet<FileType> usedFileTypes = new HashSet<FileType>();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager == null) {
            throw new CollectUsagesException("Cannot get instance of FileTypeManager");
        }
        for (final FileType fileType : registeredFileTypes = fileTypeManager.getRegisteredFileTypes()) {
            if (project.isDisposed()) {
                throw new CollectUsagesException("Project is disposed");
            }
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    FileBasedIndex.getInstance().processValues(FileTypeIndex.NAME, (Object)fileType, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Void>(){

                        public boolean process(VirtualFile file2, Void value) {
                            usedFileTypes.add(fileType);
                            return false;
                        }
                    }, GlobalSearchScope.projectScope((Project)project));
                }
            });
        }
        usedFileTypes.add(UnknownFileType.INSTANCE);
        Set set = ContainerUtil.map2Set(usedFileTypes, (Function)new NotNullFunction<FileType, UsageDescriptor>(){

            @NotNull
            public UsageDescriptor fun(FileType fileType) {
                UsageDescriptor usageDescriptor = new UsageDescriptor(fileType.getName(), 1);
                if (usageDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/FileTypeUsagesCollector$2", "fun"));
                }
                return usageDescriptor;
            }
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/FileTypeUsagesCollector", "getProjectUsages"));
        }
        return set;
    }
}

