/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ExternalizableSchemeAdapter;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompoundScheme<E extends SchemeElement>
extends ExternalizableSchemeAdapter {
    protected final ArrayList<E> myElements = new ArrayList();

    public CompoundScheme(String name) {
        this.myName = name;
    }

    public final void addElement(E t) {
        if (!this.contains(t)) {
            this.myElements.add(t);
        }
    }

    @NotNull
    public final List<E> getElements() {
        List<E> list = Collections.unmodifiableList(new ArrayList<E>(this.myElements));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompoundScheme", "getElements"));
        }
        return list;
    }

    public final void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/CompoundScheme", "setName"));
        }
        this.myName = name;
        for (SchemeElement template : this.myElements) {
            template.setGroupName(name);
        }
    }

    public final void removeElement(E template) {
        Iterator<E> templateIterator = this.myElements.iterator();
        while (templateIterator.hasNext()) {
            SchemeElement t = (SchemeElement)templateIterator.next();
            if (t.getKey() == null || !t.getKey().equals(template.getKey())) continue;
            templateIterator.remove();
        }
    }

    public final boolean isEmpty() {
        return this.myElements.isEmpty();
    }

    @NotNull
    private CompoundScheme<E> createNewInstance(String name) {
        CompoundScheme compoundScheme;
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(String.class);
            try {
                constructor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            compoundScheme = (CompoundScheme)((Object)constructor.newInstance(name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (compoundScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompoundScheme", "createNewInstance"));
        }
        return compoundScheme;
    }

    @NotNull
    CompoundScheme<E> copy() {
        CompoundScheme<E> result2 = this.createNewInstance(this.getName());
        result2.resetFrom(this);
        CompoundScheme<E> compoundScheme = result2;
        if (compoundScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompoundScheme", "copy"));
        }
        return compoundScheme;
    }

    void resetFrom(@NotNull CompoundScheme<E> template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/openapi/options/CompoundScheme", "resetFrom"));
        }
        this.myElements.clear();
        this.myElements.ensureCapacity(template.myElements.size());
        for (SchemeElement element : template.myElements) {
            this.myElements.add(element.copy());
        }
    }

    public boolean contains(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/options/CompoundScheme", "contains"));
        }
        for (SchemeElement t : this.myElements) {
            String key = t.getKey();
            if (key == null || !key.equals(element.getKey())) continue;
            return true;
        }
        return false;
    }

    public static final class MutatorHelper<T extends CompoundScheme<E>, E extends SchemeElement> {
        private final THashMap<T, T> copiedToOriginal = new THashMap(ContainerUtil.identityStrategy());

        @NotNull
        public T copy(@NotNull T scheme) {
            if (scheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/CompoundScheme$MutatorHelper", "copy"));
            }
            CompoundScheme copied = ((CompoundScheme)((Object)scheme)).copy();
            this.copiedToOriginal.put(copied, scheme);
            CompoundScheme compoundScheme = copied;
            if (compoundScheme == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompoundScheme$MutatorHelper", "copy"));
            }
            return (T)((Object)compoundScheme);
        }

        @NotNull
        public List<T> apply(final @NotNull List<T> copiedSchemes) {
            if (copiedSchemes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copiedSchemes", "com/intellij/openapi/options/CompoundScheme$MutatorHelper", "apply"));
            }
            this.copiedToOriginal.retainEntries(new TObjectObjectProcedure<T, T>(){

                public boolean execute(T copied, T original) {
                    return ContainerUtil.containsIdentity((Iterable)copiedSchemes, copied);
                }
            });
            ArrayList originals = new ArrayList(copiedSchemes.size());
            for (CompoundScheme copied : copiedSchemes) {
                CompoundScheme original = (CompoundScheme)((Object)this.copiedToOriginal.remove((Object)copied));
                if (original == null) {
                    original = copied.copy();
                    this.copiedToOriginal.put((Object)copied, original);
                } else {
                    original.resetFrom(copied);
                }
                originals.add(original);
            }
            ArrayList arrayList = originals;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/CompoundScheme$MutatorHelper", "apply"));
            }
            return arrayList;
        }

        public void clear() {
            this.copiedToOriginal.clear();
        }
    }
}

