/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.CreateNewLibraryAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.AddLibraryToModuleDependenciesAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ChangeLibraryLevelAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLibrariesConfigurable
extends BaseStructureConfigurable {
    protected final String myLevel;

    protected BaseLibrariesConfigurable(@NotNull Project project, @NotNull String libraryTableLevel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable", "<init>"));
        }
        if (libraryTableLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryTableLevel", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable", "<init>"));
        }
        super(project);
        this.myLevel = libraryTableLevel;
    }

    public static BaseLibrariesConfigurable getInstance(@NotNull Project project, @NotNull String tableLevel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable", "getInstance"));
        }
        if (tableLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableLevel", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable", "getInstance"));
        }
        if (tableLevel.equals("project")) {
            return ProjectLibrariesConfigurable.getInstance(project);
        }
        return GlobalLibrariesConfigurable.getInstance(project);
    }

    public abstract LibraryTablePresentation getLibraryTablePresentation();

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.library";
    }

    public boolean isModified() {
        boolean isModified = false;
        for (LibrariesModifiableModel provider : this.myContext.myLevel2Providers.values()) {
            isModified |= provider.isChanged();
        }
        return isModified || super.isModified();
    }

    @Override
    public void checkCanApply() throws ConfigurationException {
        super.checkCanApply();
        this.checkForEmptyAndDuplicatedNames("Library", CommonBundle.getErrorTitle(), LibraryConfigurable.class);
        for (LibraryConfigurable configurable : this.getLibraryConfigurables()) {
            if (!configurable.getDisplayName().isEmpty()) continue;
            ((LibraryProjectStructureElement)configurable.getProjectStructureElement()).navigate();
            throw new ConfigurationException("Library name is not specified");
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.myTree.setRootVisible(false);
    }

    @Override
    protected void loadTree() {
        this.createLibrariesNode(this.myContext.createModifiableModelProvider(this.myLevel));
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<LibraryProjectStructureElement> result2 = new ArrayList<LibraryProjectStructureElement>();
        for (LibraryConfigurable libraryConfigurable : this.getLibraryConfigurables()) {
            result2.add(new LibraryProjectStructureElement(this.myContext, libraryConfigurable.getEditableObject()));
        }
        ArrayList<LibraryProjectStructureElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable", "getProjectStructureElements"));
        }
        return arrayList;
    }

    private List<LibraryConfigurable> getLibraryConfigurables() {
        ArrayList<LibraryConfigurable> libraryConfigurables = new ArrayList<LibraryConfigurable>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            NamedConfigurable configurable;
            TreeNode node = this.myRoot.getChildAt(i);
            if (!(node instanceof MasterDetailsComponent.MyNode) || !((configurable = ((MasterDetailsComponent.MyNode)node).getConfigurable()) instanceof LibraryConfigurable)) continue;
            libraryConfigurables.add((LibraryConfigurable)configurable);
        }
        return libraryConfigurables;
    }

    private void createLibrariesNode(StructureLibraryTableModifiableModelProvider modelProvider) {
        Library[] libraries;
        for (Library library : libraries = modelProvider.getModifiableModel().getLibraries()) {
            this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new LibraryConfigurable(modelProvider, library, this.myContext, this.TREE_UPDATER)));
        }
        TreeUtil.sort((DefaultMutableTreeNode)this.myRoot, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                MasterDetailsComponent.MyNode node1 = (MasterDetailsComponent.MyNode)o1;
                MasterDetailsComponent.MyNode node2 = (MasterDetailsComponent.MyNode)o2;
                return node1.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
            }
        });
        ((DefaultTreeModel)this.myTree.getModel()).reload((TreeNode)this.myRoot);
    }

    public void apply() throws ConfigurationException {
        super.apply();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (LibrariesModifiableModel provider : BaseLibrariesConfigurable.this.myContext.myLevel2Providers.values()) {
                    provider.deferredCommit();
                }
            }
        });
    }

    public String getLevel() {
        return this.myLevel;
    }

    public void createLibraryNode(Library library) {
        LibraryTable table = library.getTable();
        if (table != null) {
            String level = table.getTableLevel();
            LibraryConfigurable configurable = new LibraryConfigurable(this.myContext.createModifiableModelProvider(level), library, this.myContext, this.TREE_UPDATER);
            MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)configurable);
            this.addNode(node, this.myRoot);
            ProjectStructureDaemonAnalyzer daemonAnalyzer = this.myContext.getDaemonAnalyzer();
            daemonAnalyzer.queueUpdate(new LibraryProjectStructureElement(this.myContext, library));
            daemonAnalyzer.queueUpdateForAllElementsWithErrors();
        }
    }

    public void dispose() {
        if (this.myContext != null) {
            for (LibrariesModifiableModel provider : this.myContext.myLevel2Providers.values()) {
                Disposer.dispose((Disposable)provider);
            }
        }
    }

    @Override
    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean fromPopup) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add((Object)new CopyLibraryAction());
        if (fromPopup) {
            BaseLibrariesConfigurable targetGroup = this.getOppositeGroup();
            actions.add((Object)new ChangeLibraryLevelAction(this.myProject, (JComponent)this.myTree, this, targetGroup));
            actions.add((Object)new AddLibraryToModuleDependenciesAction(this.myProject, this));
        }
        ArrayList<Object> arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable", "createCopyActions"));
        }
        return arrayList;
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(this.getAddText()){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = CreateNewLibraryAction.createActionOrGroup(BaseLibrariesConfigurable.this.getAddText(), BaseLibrariesConfigurable.this, BaseLibrariesConfigurable.this.myProject);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable$3", "getChildren"));
                }
                return anActionArray;
            }
        };
    }

    protected abstract String getAddText();

    public abstract StructureLibraryTableModifiableModelProvider getModelProvider();

    public abstract BaseLibrariesConfigurable getOppositeGroup();

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        boolean selectionChanged;
        boolean bl = selectionChanged = !Comparing.equal((Object)this.myCurrentConfigurable, (Object)configurable);
        if (this.myCurrentConfigurable instanceof LibraryConfigurable && selectionChanged) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onUnselected();
        }
        super.updateSelection(configurable);
        if (this.myCurrentConfigurable instanceof LibraryConfigurable && selectionChanged) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onSelected();
        }
    }

    @Override
    public void onStructureUnselected() {
        if (this.myCurrentConfigurable instanceof LibraryConfigurable) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onUnselected();
        }
    }

    @Override
    public void onStructureSelected() {
        if (this.myCurrentConfigurable instanceof LibraryConfigurable) {
            ((LibraryConfigurable)this.myCurrentConfigurable).onSelected();
        }
    }

    public void removeLibrary(@NotNull LibraryProjectStructureElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable", "removeLibrary"));
        }
        this.removeLibraries(Collections.singletonList(element));
    }

    public void removeLibraries(@NotNull List<LibraryProjectStructureElement> libraries) {
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable", "removeLibraries"));
        }
        ArrayList<TreePath> pathsToRemove = new ArrayList<TreePath>();
        for (LibraryProjectStructureElement element : libraries) {
            this.getModelProvider().getModifiableModel().removeLibrary(element.getLibrary());
            MasterDetailsComponent.MyNode node = BaseLibrariesConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)element.getLibrary());
            if (node == null) continue;
            pathsToRemove.add(TreeUtil.getPathFromRoot((TreeNode)node));
        }
        this.myContext.getDaemonAnalyzer().removeElements(libraries);
        this.removePaths(pathsToRemove.toArray(new TreePath[pathsToRemove.size()]));
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new RemoveConfigurableHandler<Library>(LibraryConfigurable.class){

            @Override
            public boolean remove(@NotNull Collection<Library> libraries) {
                String message;
                if (libraries == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable$4", "remove"));
                }
                ArrayList<Pair> toRemove = new ArrayList<Pair>();
                String firstLibraryUsageDescription = null;
                String firstLibraryWithUsageName = null;
                int librariesWithUsages = 0;
                for (Library library : libraries) {
                    LibraryTable table = library.getTable();
                    if (table == null) continue;
                    LibraryProjectStructureElement libraryElement = new LibraryProjectStructureElement(BaseLibrariesConfigurable.this.myContext, library);
                    ArrayList<ProjectStructureElementUsage> usages = new ArrayList<ProjectStructureElementUsage>(BaseLibrariesConfigurable.this.myContext.getDaemonAnalyzer().getUsages(libraryElement));
                    if (usages.size() > 0) {
                        if (librariesWithUsages == 0) {
                            MultiMap containerType2Usage = new MultiMap();
                            for (ProjectStructureElementUsage usage : usages) {
                                containerType2Usage.putValue((Object)usage.getContainingElement().getTypeName(), (Object)usage);
                            }
                            ArrayList types = new ArrayList(containerType2Usage.keySet());
                            Collections.sort(types);
                            StringBuilder sb = new StringBuilder("Library '");
                            Library libraryModel = BaseLibrariesConfigurable.this.myContext.getLibraryModel(library);
                            sb.append(libraryModel != null ? libraryModel.getName() : library.getName()).append("' is used in ");
                            for (int i = 0; i < types.size(); ++i) {
                                if (i > 0 && i == types.size() - 1) {
                                    sb.append(" and in ");
                                } else if (i > 0) {
                                    sb.append(", in ");
                                }
                                String type = (String)types.get(i);
                                Collection usagesOfType = containerType2Usage.get((Object)type);
                                if (usagesOfType.size() > 1) {
                                    sb.append(usagesOfType.size()).append(" ").append(StringUtil.decapitalize((String)StringUtil.pluralize((String)type)));
                                    continue;
                                }
                                sb.append(StringUtil.decapitalize((String)((ProjectStructureElementUsage)usagesOfType.iterator().next()).getContainingElement().getPresentableName()));
                            }
                            firstLibraryWithUsageName = library.getName();
                            firstLibraryUsageDescription = sb.toString();
                        }
                        ++librariesWithUsages;
                    }
                    toRemove.add(Pair.create((Object)libraryElement, usages));
                }
                if (librariesWithUsages > 0 && 0 != Messages.showOkCancelDialog((Project)BaseLibrariesConfigurable.this.myProject, (String)(message = librariesWithUsages == 1 ? firstLibraryUsageDescription + ".\nAre you sure you want to delete this library?" : ProjectBundle.message((String)"libraries.remove.confirmation.text", (Object[])new Object[]{firstLibraryWithUsageName, librariesWithUsages - 1})), (String)ProjectBundle.message((String)"libraries.remove.confirmation.title", (Object[])new Object[]{librariesWithUsages}), (Icon)Messages.getQuestionIcon())) {
                    return false;
                }
                for (Pair pair : toRemove) {
                    for (ProjectStructureElementUsage usage : (Collection)pair.getSecond()) {
                        usage.removeSourceElement();
                    }
                    BaseLibrariesConfigurable.this.getModelProvider().getModifiableModel().removeLibrary(((LibraryProjectStructureElement)pair.getFirst()).getLibrary());
                    BaseLibrariesConfigurable.this.myContext.getDaemonAnalyzer().removeElement((ProjectStructureElement)pair.getFirst());
                }
                return true;
            }

            @Override
            public boolean canBeRemoved(@NotNull Collection<Library> libraries) {
                if (libraries == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable$4", "canBeRemoved"));
                }
                for (Library library : libraries) {
                    LibraryTable table = library.getTable();
                    if (table == null || table.isEditable()) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select a library to view or edit its details here";
    }

    private class CopyLibraryAction
    extends AnAction {
        private CopyLibraryAction() {
            super(CommonBundle.message((String)"button.copy", (Object[])new Object[0]), CommonBundle.message((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(AnActionEvent e) {
            Object o = BaseLibrariesConfigurable.this.getSelectedObject();
            if (o instanceof LibraryEx) {
                LibraryEx selected = (LibraryEx)o;
                String newName = Messages.showInputDialog((String)"Enter library name:", (String)"Copy Library", null, (String)(selected.getName() + "2"), (InputValidator)new NonEmptyInputValidator());
                if (newName == null) {
                    return;
                }
                BaseLibrariesConfigurable configurable = BaseLibrariesConfigurable.this;
                LibraryEx library = (LibraryEx)BaseLibrariesConfigurable.this.myContext.getLibrary(selected.getName(), BaseLibrariesConfigurable.this.myLevel);
                LOG.assertTrue(library != null);
                LibrariesModifiableModel libsModel = configurable.getModelProvider().getModifiableModel();
                Library lib = libsModel.createLibrary(newName, library.getKind());
                LibraryEx.ModifiableModelEx model = libsModel.getLibraryEditor(lib).getModel();
                LibraryEditingUtil.copyLibrary(library, Collections.<String, String>emptyMap(), model);
            }
        }

        public void update(AnActionEvent e) {
            if (BaseLibrariesConfigurable.this.myTree.getSelectionPaths() == null || BaseLibrariesConfigurable.this.myTree.getSelectionPaths().length != 1) {
                e.getPresentation().setEnabled(false);
            } else {
                e.getPresentation().setEnabled(BaseLibrariesConfigurable.this.getSelectedObject() instanceof LibraryImpl);
            }
        }
    }
}

