/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.util.ActionCallback;
import org.jetbrains.annotations.NotNull;

public class PlaceInModuleClasspath
extends PlaceInProjectStructure {
    private final StructureConfigurableContext myContext;
    private final Module myModule;
    private final ProjectStructureElement myElement;
    private final OrderEntry myOrderEntry;

    public PlaceInModuleClasspath(StructureConfigurableContext context, Module module, ProjectStructureElement element, OrderEntry orderEntry) {
        this.myContext = context;
        this.myModule = module;
        this.myElement = element;
        this.myOrderEntry = orderEntry;
    }

    public PlaceInModuleClasspath(@NotNull StructureConfigurableContext context, @NotNull Module module, ProjectStructureElement element, @NotNull ProjectStructureElement elementInClasspath) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/PlaceInModuleClasspath", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/PlaceInModuleClasspath", "<init>"));
        }
        if (elementInClasspath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementInClasspath", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/PlaceInModuleClasspath", "<init>"));
        }
        this.myContext = context;
        this.myModule = module;
        this.myElement = element;
        ModuleRootModel rootModel = this.myContext.getModulesConfigurator().getRootModel(this.myModule);
        this.myOrderEntry = elementInClasspath instanceof LibraryProjectStructureElement ? OrderEntryUtil.findLibraryOrderEntry(rootModel, ((LibraryProjectStructureElement)elementInClasspath).getLibrary()) : (elementInClasspath instanceof ModuleProjectStructureElement ? OrderEntryUtil.findModuleOrderEntry(rootModel, ((ModuleProjectStructureElement)elementInClasspath).getModule()) : (elementInClasspath instanceof SdkProjectStructureElement ? OrderEntryUtil.findJdkOrderEntry(rootModel, ((SdkProjectStructureElement)elementInClasspath).getSdk()) : null));
    }

    @Override
    @NotNull
    public ProjectStructureElement getContainingElement() {
        ProjectStructureElement projectStructureElement = this.myElement;
        if (projectStructureElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/PlaceInModuleClasspath", "getContainingElement"));
        }
        return projectStructureElement;
    }

    @Override
    public String getPlacePath() {
        return this.myOrderEntry != null ? this.myOrderEntry.getPresentableName() : null;
    }

    @Override
    @NotNull
    public ActionCallback navigate() {
        ActionCallback actionCallback = ProjectStructureConfigurable.getInstance(this.myContext.getProject()).selectOrderEntry(this.myModule, this.myOrderEntry);
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/PlaceInModuleClasspath", "navigate"));
        }
        return actionCallback;
    }
}

