/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.impl;

import com.intellij.icons.AllIcons;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jdesktop.swingx.graphics.GraphicsUtilities;
import org.jdesktop.swingx.graphics.ShadowRenderer;

public class ShadowBorderPainter {
    private static final Icon TOP = AllIcons.Ide.Shadow.Top;
    private static final Icon TOP_RIGHT = AllIcons.Ide.Shadow.Top_right;
    private static final Icon RIGHT = AllIcons.Ide.Shadow.Right;
    private static final Icon BOTTOM_RIGHT = AllIcons.Ide.Shadow.Bottom_right;
    private static final Icon BOTTOM = AllIcons.Ide.Shadow.Bottom;
    private static final Icon BOTTOM_LEFT = AllIcons.Ide.Shadow.Bottom_left;
    private static final Icon LEFT = AllIcons.Ide.Shadow.Left;
    private static final Icon TOP_LEFT = AllIcons.Ide.Shadow.Top_left;
    public static final int SIDE_SIZE = 35;
    public static final int TOP_SIZE = 20;
    public static final int BOTTOM_SIZE = 49;
    private static final Icon POPUP_TOP = AllIcons.Ide.Shadow.Popup.Top;
    private static final Icon POPUP_TOP_RIGHT = AllIcons.Ide.Shadow.Popup.Top_right;
    private static final Icon POPUP_RIGHT = AllIcons.Ide.Shadow.Popup.Right;
    private static final Icon POPUP_BOTTOM_RIGHT = AllIcons.Ide.Shadow.Popup.Bottom_right;
    private static final Icon POPUP_BOTTOM = AllIcons.Ide.Shadow.Popup.Bottom;
    private static final Icon POPUP_BOTTOM_LEFT = AllIcons.Ide.Shadow.Popup.Bottom_left;
    private static final Icon POPUP_LEFT = AllIcons.Ide.Shadow.Popup.Left;
    private static final Icon POPUP_TOP_LEFT = AllIcons.Ide.Shadow.Popup.Top_left;
    public static final int POPUP_SIDE_SIZE = 7;
    public static final int POPUP_TOP_SIZE = 4;
    public static final int POPUP_BOTTOM_SIZE = 10;

    private ShadowBorderPainter() {
    }

    public static BufferedImage createShadow(JComponent c, int width, int height, boolean isPopup) {
        int _y;
        int _x;
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage image = graphicsConfiguration.createCompatibleImage(width, height, 3);
        Graphics2D g = image.createGraphics();
        Icon topLeft = isPopup ? POPUP_TOP_LEFT : TOP_LEFT;
        Icon topRight = isPopup ? POPUP_TOP_RIGHT : TOP_RIGHT;
        Icon bottom = isPopup ? POPUP_BOTTOM : BOTTOM;
        Icon top = isPopup ? POPUP_TOP : TOP;
        Icon bottomRight = isPopup ? POPUP_BOTTOM_RIGHT : BOTTOM_RIGHT;
        Icon bottomLeft = isPopup ? POPUP_BOTTOM_LEFT : BOTTOM_LEFT;
        Icon left = isPopup ? POPUP_LEFT : LEFT;
        Icon right = isPopup ? POPUP_RIGHT : RIGHT;
        int sideSize = isPopup ? 7 : 35;
        int bottomSize = isPopup ? 10 : 49;
        topLeft.paintIcon(c, g, 0, 0);
        topRight.paintIcon(c, g, width - topRight.getIconWidth(), 0);
        bottomRight.paintIcon(c, g, width - bottomRight.getIconWidth(), height - bottomRight.getIconHeight());
        bottomLeft.paintIcon(c, g, 0, height - bottomLeft.getIconHeight());
        for (_x = topLeft.getIconWidth(); _x < width - topRight.getIconWidth(); ++_x) {
            top.paintIcon(c, g, _x, 0);
        }
        for (_x = bottomLeft.getIconWidth(); _x < width - bottomLeft.getIconWidth(); ++_x) {
            bottom.paintIcon(c, g, _x, height - bottomSize);
        }
        for (_y = topLeft.getIconHeight(); _y < height - bottomLeft.getIconHeight(); ++_y) {
            left.paintIcon(c, g, 0, _y);
        }
        for (_y = topRight.getIconHeight(); _y < height - bottomRight.getIconHeight(); ++_y) {
            right.paintIcon(c, g, width - sideSize, _y);
        }
        g.setColor(new Color(0, 0, 0, 30));
        g.drawRect(34, 19, width - 70 + 1, height - 20 - 49 + 1);
        g.dispose();
        return image;
    }

    public static BufferedImage createShadow(JComponent c, int width, int height) {
        return ShadowBorderPainter.createShadow(c, width, height, false);
    }

    public static BufferedImage createPopupShadow(JComponent c, int width, int height) {
        return ShadowBorderPainter.createShadow(c, width, height, true);
    }

    public static Shadow createShadow(Image source, int x, int y, boolean paintSource, int shadowSize) {
        int size = shadowSize;
        float w = source.getWidth(null);
        float h = source.getHeight(null);
        float ratio = w / h;
        float deltaX = size;
        float deltaY = (float)size / ratio;
        Image scaled = source.getScaledInstance((int)(w + deltaX), (int)(h + deltaY), 4);
        BufferedImage s = GraphicsUtilities.createCompatibleTranslucentImage((int)scaled.getWidth(null), (int)scaled.getHeight(null));
        Graphics2D graphics = (Graphics2D)s.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.drawImage(scaled, 0, 0, null);
        BufferedImage shadow = new ShadowRenderer(size, 0.25f, Color.black).createShadow(s);
        if (paintSource) {
            Graphics imgG = shadow.getGraphics();
            double d = (double)size * 0.5;
            imgG.drawImage(source, (int)((double)size + d), (int)((double)size + d / (double)ratio), null);
        }
        return new Shadow(shadow, x - size - 5, y - size + 2);
    }

    public static class Shadow {
        int x;
        int y;
        Image image;

        public Shadow(Image image, int x, int y) {
            this.x = x;
            this.y = y;
            this.image = image;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

